/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.zhiqim.kernel.httpclient.HttpClient;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Validates;

public class HttpDownload
extends HttpClient {
    private String fileDir;
    private String fileName;
    private File file;

    public HttpDownload(String url) {
        super(url, "GET");
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    protected boolean doPreRequestProperty() {
        if (Files.exists(this.fileDir)) {
            if (!Files.isDirectory(this.fileDir)) {
                this.responseStatus = 72;
                this.responseText = "\u8bf7\u6c42\u7684\u6587\u4ef6\u5b58\u653e\u76ee\u5f55\u4e0d\u6b63\u786e";
                return false;
            }
        } else if (!Files.mkDirectory(this.fileDir)) {
            this.responseStatus = 72;
            this.responseText = "\u8bf7\u6c42\u7684\u6587\u4ef6\u5b58\u653e\u76ee\u5f55\u4e0d\u6b63\u786e";
            return false;
        }
        if (!this.hasRequestProperty("Accept")) {
            this.addRequestProperty("Accept", "*/*");
        }
        return true;
    }

    @Override
    protected void doReadResponseContent(HttpURLConnection conn) throws IOException {
        String fileExt;
        if (this.responseStatus == 302) {
            this.responseText = conn.getHeaderField("Location");
            return;
        }
        if (this.responseStatus != 200) {
            this.responseText = HttpDownload.getResponseError(conn);
            return;
        }
        if (Validates.isEmpty(this.fileName)) {
            this.fileName = HttpDownload.getFileName(conn);
        }
        if (Validates.isEmpty(this.fileName) && Validates.isAlphabeticLen(fileExt = Files.getFileExt(this.url), 2, 5)) {
            this.fileName = Files.getFileName(this.url, "/");
        }
        if (Validates.isEmpty(this.fileName)) {
            this.responseStatus = 72;
            this.responseText = "\u672a\u6307\u5b9a\u6587\u4ef6\u540d\u79f0";
            return;
        }
        this.file = new File(this.fileDir, this.fileName);
        FileOutputStream output = new FileOutputStream(this.file);
        InputStream input = conn.getInputStream();
        try {
            Streams.putBytes(input, output);
        }
        catch (Throwable throwable) {
            try {
                output.close();
            }
            catch (Exception exception) {}
            try {
                input.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            output.close();
        }
        catch (Exception exception) {}
        try {
            input.close();
        }
        catch (Exception exception) {}
        this.responseText = "\u4e0b\u8f7d\u6210\u529f";
    }
}

