/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import org.zhiqim.kernel.control.ThreaderController;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.seqs.Sequence;

public class Threader
extends Threadx
implements Runnable {
    private static final Log log = LogFactory.getLog(Threader.class);
    private static final Sequence sequence = new Sequence();
    private final ThreaderController controller;
    private final String threadName;
    private volatile boolean isIdle = true;
    private long idleTime = System.currentTimeMillis();
    private long completedCount;

    public Threader(ThreaderController controller) {
        this.controller = controller;
        this.threadName = String.valueOf(controller.getThreadGroup().getName()) + "-" + sequence.next();
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    protected ThreadGroup getThreadGroup() {
        return this.controller.getThreadGroup();
    }

    @Override
    protected void loop() {
        Runnable command = this.controller.accept();
        if (command == null) {
            return;
        }
        try {
            try {
                this.isIdle = false;
                command.run();
            }
            catch (Exception e) {
                log.error((Object)"\u7ebf\u7a0b\u6c60\u5904\u7406\u65f6\u5f02\u5e38\uff1a[%s]", e, e.getMessage());
                this.controller.addCompletedCount();
                ++this.completedCount;
                this.idleTime = System.currentTimeMillis();
                this.isIdle = true;
                command = null;
            }
        }
        finally {
            this.controller.addCompletedCount();
            ++this.completedCount;
            this.idleTime = System.currentTimeMillis();
            this.isIdle = true;
            command = null;
        }
    }

    public boolean isActive() {
        return !this.isIdle;
    }

    public boolean isIdle() {
        return this.isIdle;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String getIdleTimeString() {
        return DateTimes.toDateTimeString(this.idleTime);
    }

    public long getCompletedCount() {
        return this.completedCount;
    }

    public boolean isExecessMaxIdleTime(long maxIdleMilliTime) {
        return this.isIdle ? System.currentTimeMillis() - this.idleTime - maxIdleMilliTime > 0L : false;
    }
}

