;(function(Z)
{
//BEGIN
var TopBase = window.TopBase = {};

/********************************************************/
//全局使用相关
/********************************************************/
TopBase.doHide = function(id, theEvent)
{//下拉菜单隐藏
    var ul = Z.Document.id(id);
    if(Z.Browser.firefox)
    { //如果是Firefox
        if(ul.contains(theEvent.relatedTarget)) //如果是子元素
            return;
    }
    else
    { //其他浏览器IE,chrom
        if (ul.contains(theEvent.toElement)) //如果是子元素
            return;
    }

    ul.style.display = "none";
};

TopBase.doDisplay = function(id, theEvent)
{//下拉菜单显示
    var ul = Z.Document.id(id);
    if(Z.Browser.firefox)
    { //如果是Firefox
        if(ul.contains(theEvent.relatedTarget)) //如果是子元素
            return;
    }
    else
    {//其他浏览器IE,chrom
        if (ul.contains(theEvent.toElement)) //如果是子元素
            return;
    }
    
    ul.style.display = "";
};

TopBase.doClock = function()
{//短授权时钟
    var $clock = Z("#clock");
    if ($clock.length == 0)
        return;
        
    var ct = new Date().getTime();
    if (ct > st)
        $clock.text('0分0秒');
    else
    {
        var count = Math.floor((st-ct)/1000);
        $clock.text(Math.floor(count / 60)+'分'+(count%60)+'秒');
    }
};

TopBase.openPermission = function(appUrl)
{//弹出版本权限检查对话框
    var dialog = new Z.Dialog();
    dialog.title = "温馨提示";
    dialog.url = "/permission.htm?&appUrl="+encodeURIComponent(appUrl);
    dialog.width = 580;
    dialog.height = 150;
    dialog.execute();
};

TopBase.openAuthW2 = function()
{//弹出短授权对话框
    var dialog = new Z.Dialog();
    dialog.title = "淘宝授权";
    dialog.url = "/w2Req.htm";
    dialog.width = 640;
    dialog.height = 320;
    dialog.execute();
};

TopBase.isAuthW2 = function()
{//判断是否有短授权
    var ajax = new Z.Ajax();
    ajax.setSync();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("isAuthW2");
    ajax.execute();
    
    return (ajax.responseStatus == 0)
};

TopBase.doSyncOrderTid = function()
{//同步单个订单
    var dialog = new Z.Dialog();
    dialog.title = "指定交易号同步订单";
    dialog.url = "/tradeTidSyncPopup.htm";
    dialog.width = 420;
    dialog.height = 130;
    dialog.execute();
};

TopBase.doSyncOrderModified = function()
{//同步日期订单
    var dialog = new Z.Dialog();
    dialog.title = "按日期同步订单";
    dialog.url = "/tradeModifiedSyncPopup.htm";
    dialog.width = 420;
    dialog.height = 130;
    dialog.execute();
};

TopBase.doCloseTopNotice = function()
{//关闭消息通知栏
    var ajax = new Z.Ajax();
    ajax.setSync();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("doCloseTopNotice");
    ajax.execute();
    
    Z("#topnotice").hide();
};

TopBase.doRefreshUserInfo = function()
{//刷新用户信息
    var ajax = new Z.Ajax();
    ajax.setSync();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("doRefreshUserInfo");
    ajax.execute();
    
    location.href = "/index.htm";
};

TopBase.doRefreshUserOrder = function(url)
{//刷新用户订购信息
    var ajax = new Z.Ajax();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("doRefreshUserOrder");
    ajax.execute();
    
    if(url)
    {//弹出窗口时需要重新打开订购页面
        window.open(url);
    }
};

TopBase.doUpdateMobile = function()
{//更新手机号码，打折活动共用
    var dialog = new Z.Dialog();
    dialog.title = "更新手机号";
    dialog.url = "/userUpdateMobile.htm";
    dialog.width = 350;
    dialog.height = 120;
    dialog.execute();
};

TopBase.doRefreshExpireDay = function()
{
    var ajax = new Z.Ajax();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("doRefreshExpireDay");
    ajax.setCallback(function(responseText){
        if (ajax.responseStatus != 0)
            Z.alert(responseText);
        else
            Z("#expireDayTop").html(responseText);
    });
    ajax.setLoading("doRefreshExpireDay", "<i class='z-ico z-loading z-small'></i>");
    ajax.execute();
}

TopBase.selectPic = function(allowWidth, allowHeight)
{//图片选择
    TopBase._selPicDialog = new Z.Dialog();
    TopBase._selPicDialog.title = "图片小工具";
    TopBase._selPicDialog.url = "/selSysPic.htm?allowWidth="+allowWidth+"&allowHeight="+allowHeight;
    TopBase._selPicDialog.width = 1000;
    TopBase._selPicDialog.height = 520;
    TopBase._selPicDialog.drag = false;
    TopBase._selPicDialog.execute();
};

TopBase.doSwitchTab = function(url)
{//切换图片选择
 	TopBase._selPicDialog.close();
    TopBase._selPicDialog = new Z.Dialog();
    TopBase._selPicDialog.title = "图片小工具";
    TopBase._selPicDialog.url = url;
    TopBase._selPicDialog.width = 1000;
    TopBase._selPicDialog.height = 520;
    TopBase._selPicDialog.drag = false;
    TopBase._selPicDialog.execute();
};

//END
})(zhiqim);