/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import net.redxyz.top.TaobaoException;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.message.tools.TopSecretGetResponse26567;
import net.redxyz.top.security.Base64;
import net.redxyz.top.security.LruHashMap;
import net.redxyz.top.security.SecretContext;
import net.redxyz.top.security.SecurityConstants;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;

public class SecurityCore
implements SecurityConstants {
    private static final Log log = LogFactory.getLog(SecurityCore.class);
    private static final LruHashMap<String, SecretContext> appUserSecretCache = new LruHashMap(16, 131072);
    private static final Map<String, SecretContext> appSecretCache = new ConcurrentHashMap<String, SecretContext>();
    private static ExecutorService asynUpdateSecret;
    private static final ConcurrentHashMap<String, Object> asynQueueKey;
    private static final Object emptyValue;
    private HashMapSO appConfig;

    static {
        asynQueueKey = new ConcurrentHashMap();
        emptyValue = new Object();
    }

    public static LruHashMap<String, SecretContext> getAppUserSecretCache() {
        return appUserSecretCache;
    }

    public boolean isIndexEncrypt(String key, Long version) {
        key = version != null && version < 0L ? "previous_" + key : "current_" + key;
        return this.appConfig != null && "2".equals(this.appConfig.get(key));
    }

    public int getCompressLen() {
        String compressLen;
        if (this.appConfig != null && (compressLen = (String)this.appConfig.get("encrypt_index_compress_len")) != null) {
            return Integer.parseInt(compressLen);
        }
        return 3;
    }

    public int getSlideSize() {
        String encryptSlideSize;
        if (this.appConfig != null && (encryptSlideSize = (String)this.appConfig.get("encrypt_slide_size")) != null) {
            return Integer.parseInt(encryptSlideSize);
        }
        return 4;
    }

    public SecretContext getSecret(String session, Long secretVersion) throws TaobaoException {
        SecretContext secretContext = this.getSecret(session, this.generateSecretKey(session, secretVersion));
        if (secretContext != null) {
            if (secretContext.isValid()) {
                return secretContext;
            }
            if (secretContext.isMaxValid()) {
                this.asynUpdateSecret(session, secretVersion);
                return secretContext;
            }
            String cacheKey = this.generateSecretKey(session, secretVersion);
            if (session != null) {
                appUserSecretCache.remove(cacheKey);
            } else {
                appSecretCache.remove(cacheKey);
            }
            return this.callSecretApi(session, secretVersion);
        }
        return this.callSecretApi(session, secretVersion);
    }

    private String generateSecretKey(String session, Long secretVersion) {
        if (session == null) {
            return TaobaoService.getServer().getAppKey();
        }
        if (secretVersion == null) {
            return session;
        }
        return String.valueOf(session) + "_" + secretVersion;
    }

    private SecretContext getSecret(String session, String cacheKey) {
        SecretContext secretContext = session != null ? appUserSecretCache.get(cacheKey) : appSecretCache.get(cacheKey);
        return secretContext;
    }

    private SecretContext callSecretApi(String session, Long secretVersion) throws TaobaoException {
        TopSecretGetResponse26567 response = TaobaoService.getToolService().getTopSecret(session, secretVersion);
        if (response.isSuccess()) {
            if (!Validates.isEmpty((String)response.getAppConfig())) {
                this.appConfig = Jsons.toMapSO((String)response.getAppConfig());
            }
            SecretContext secretContext = new SecretContext();
            if (response.getSecret() != null) {
                long currentTime = System.currentTimeMillis();
                secretContext.setInvalidTime(currentTime + response.getInterval() * 1000L);
                secretContext.setMaxInvalidTime(currentTime + response.getMaxInterval() * 1000L);
                secretContext.setSecret(Base64.decode(response.getSecret()));
                secretContext.setSecretVersion(response.getSecretVersion());
            } else if (this.appConfig != null && "0".equals(this.appConfig.get("publish_status"))) {
                this.setNullCache(secretContext);
            }
            String cacheKey = this.generateSecretKey(session, secretVersion);
            if (session != null) {
                appUserSecretCache.put(cacheKey, secretContext);
            } else {
                appSecretCache.put(cacheKey, secretContext);
            }
            return secretContext;
        }
        if ("20005".equals(response.getSubCode())) {
            SecretContext secretContext = new SecretContext();
            this.setNullCache(secretContext);
            String cacheKey = this.generateSecretKey(session, secretVersion);
            if (session != null) {
                appUserSecretCache.put(cacheKey, secretContext);
            } else {
                appSecretCache.put(cacheKey, secretContext);
            }
            return secretContext;
        }
        throw new TaobaoException(response.getError(), response.getErrorMsg());
    }

    private void setNullCache(SecretContext secretContext) {
        long currentTime = System.currentTimeMillis();
        secretContext.setInvalidTime(currentTime + 300000L);
        secretContext.setMaxInvalidTime(currentTime + 600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynUpdateSecret(final String session, final Long secretVersion) {
        final String cacheKey = this.generateSecretKey(session, secretVersion);
        try {
            Class<SecurityCore> clazz = SecurityCore.class;
            synchronized (SecurityCore.class) {
                if (asynQueueKey.containsKey(cacheKey)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                SecretContext secretContext = this.getSecret(session, this.generateSecretKey(session, secretVersion));
                if (secretContext != null && secretContext.isValid()) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                asynQueueKey.put(cacheKey, emptyValue);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                asynUpdateSecret.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                SecurityCore.this.callSecretApi(session, secretVersion);
                            }
                            catch (Exception e) {
                                if (log.isErrorEnabled()) {
                                    log.error((Object)"asyn update secret error", (Throwable)e, new Object[0]);
                                }
                                asynQueueKey.remove(cacheKey);
                            }
                        }
                        finally {
                            asynQueueKey.remove(cacheKey);
                        }
                    }
                });
            }
        }
        catch (RuntimeException e) {
            asynQueueKey.remove(cacheKey);
            throw e;
        }
    }
}

