/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.message;

import org.zhiqim.kernel.util.Validates;

public class ErrorResponse {
    private int code;
    private String msg;
    private String subCode;
    private String subMsg;
    private String args;

    public ErrorResponse() {
    }

    public ErrorResponse(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ErrorResponse(int code, String msg, String subCode, String subMsg, String args) {
        this.code = code;
        this.msg = msg;
        this.subCode = subCode;
        this.subMsg = subMsg;
        this.args = args;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getSubCode() {
        return this.subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public String getSubMsg() {
        return this.subMsg;
    }

    public void setSubMsg(String subMsg) {
        this.subMsg = subMsg;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public boolean isUserFail() {
        if ("session-expired".equals(this.subCode)) {
            return true;
        }
        if ("invalid-sessionkey".equals(this.subCode)) {
            return true;
        }
        if ("session-not-exist".equals(this.subCode)) {
            return true;
        }
        return "isv.shop-not-exist".equals(this.subCode);
    }

    public boolean isTaobaoFail() {
        if ("isp.item-update-service-error:GENERIC_FAILURE".equals(this.subCode)) {
            return true;
        }
        if ("accesscontrol.limited-by-api-access-count".equals(this.subCode)) {
            return true;
        }
        if ("accesscontrol.limited-by-dynamic-access-count".equals(this.subCode)) {
            return true;
        }
        if ("isp.top-remote-connection-timeout-tmall".equals(this.subCode)) {
            return true;
        }
        if ("isp.top-remote-connection-timeout".equals(this.subCode)) {
            return true;
        }
        if ("isp.top-remote-service-unavailable".equals(this.subCode)) {
            return true;
        }
        if ("isp.remote-service-error".equals(this.subCode)) {
            return true;
        }
        if ("isp.remote-service-timeout".equals(this.subCode)) {
            return true;
        }
        if ("isp.remote-connection-error".equals(this.subCode)) {
            return true;
        }
        if ("isp.null-pointer-exception".equals(this.subCode)) {
            return true;
        }
        if ("isp.top-remote-connection-error".equals(this.subCode)) {
            return true;
        }
        if ("isp.unknown-error".equals(this.subCode)) {
            return true;
        }
        return !Validates.isEmpty((String)this.subMsg) && (this.subMsg.indexOf("\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5") != -1 || this.subMsg.indexOf("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u6b21\u5c1d\u8bd5") != -1);
    }

    public boolean isGetFail() {
        if (this.isNotExist()) {
            return true;
        }
        if ("isv.item-is-delete:invalid-numIid-or-iid".equals(this.subCode)) {
            return true;
        }
        if ("isv.item-is-delete:invalid-numIid-or-iid-tmall".equals(this.subCode)) {
            return true;
        }
        if ("isv.pictureServiceClient-service-error:PICTURE_QUERY_PICTURE_FAILED".equals(this.subCode)) {
            return true;
        }
        if (Validates.isNotEmpty((String)this.subCode) && this.subCode.contains("ITEM_NOT_FOUND")) {
            return true;
        }
        return "isv.invalid-parameters:item_delete".equals(this.subCode);
    }

    public boolean isUpdateFail() {
        if ("isv.item-update-service-error:IC_LIMIT_FOR_DPC".equals(this.subCode)) {
            return true;
        }
        if ("isv.item-update-service-error:ITEM_PROPERTIES_ERROR".equals(this.subCode)) {
            return true;
        }
        if ("isv.item-update-service-error:IC_CHECKSTEP_SKU_PROP_NOT_FOUND_IN_ITEM".equals(this.subCode)) {
            return true;
        }
        if ("isv.item-update-service-error:IC_PERMISSION_FOR_TBCP_ONLY".equals(this.subCode)) {
            return true;
        }
        if ("isv.antisteal-service-error".equals(this.subCode)) {
            return true;
        }
        return "isv.error-food-security-required".equals(this.subCode);
    }

    public boolean isNotExist() {
        if (Validates.isEmpty((String)this.subCode)) {
            return false;
        }
        return this.subCode.contains("not-exist");
    }

    public String toString() {
        return "{error_response:{\"code\":" + this.code + ", \"msg\":\"" + this.msg + "\",\"subcode\":" + this.subCode + ", \"submsg\":\"" + this.subMsg + "\", \"args\":" + this.args + "}}";
    }
}

