/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.order.client;

import net.redxyz.order.client.ErrorResponse;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Validates;

public abstract class RestClientResponse {
    private ErrorResponse error;
    private String responseText;

    protected abstract void buildResponse(String var1);

    public void buildResponseError(int code, String msg) {
        this.error = new ErrorResponse(code, msg);
    }

    public void buildResponseText(String responseText) {
        this.responseText = responseText;
        if (responseText.startsWith("{error:")) {
            String errorMsg = Jsons.getObject((String)responseText, (String)"error");
            this.error = (ErrorResponse)Jsons.toObject((String)errorMsg, ErrorResponse.class);
        } else if (responseText.startsWith("<?xml")) {
            if (Validates.isEmpty((String)responseText)) {
                return;
            }
            this.buildResponse(responseText);
        } else {
            if (Validates.isEmpty((String)responseText)) {
                return;
            }
            this.buildResponse(responseText);
        }
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public int getErrorCode() {
        if (this.error == null) {
            return 0;
        }
        return this.error.getCode();
    }

    public String getErrorMsg() {
        if (this.error == null) {
            return "";
        }
        return this.error.getMsg();
    }

    public ErrorResponse getError() {
        return this.error;
    }

    public String toString() {
        if (this.error != null) {
            return this.error.toString();
        }
        return this.responseText;
    }
}

