/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.model.serialize;

import com.aliyun.mq.http.model.TopicMessage;
import com.aliyun.mq.http.model.request.PublishMessageRequest;
import com.aliyun.mq.http.model.serialize.XMLSerializer;
import com.aliyun.mq.http.model.serialize.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TopicMessageSerializer
extends XMLSerializer<PublishMessageRequest> {
    @Override
    public InputStream serialize(PublishMessageRequest request, String encoding) throws Exception {
        Document doc = this.getDocmentBuilder().newDocument();
        TopicMessage msg = request.getMessage();
        Element root = doc.createElementNS("http://mq.aliyuncs.com/doc/v1", "Message");
        doc.appendChild(root);
        Element node = TopicMessageSerializer.safeCreateContentElement(doc, "MessageBody", msg.getMessageBodyString(), "");
        if (node != null) {
            root.appendChild(node);
        }
        if (msg.getMessageTag() != null && msg.getMessageTag().length() > 0 && (node = TopicMessageSerializer.safeCreateContentElement(doc, "MessageTag", msg.getMessageTag(), null)) != null) {
            root.appendChild(node);
        }
        if (msg.getProperties() != null && !msg.getProperties().isEmpty() && (node = TopicMessageSerializer.safeCreateContentElement(doc, "Properties", XmlUtil.mapToString(msg.getProperties()), null)) != null) {
            root.appendChild(node);
        }
        String xml = XmlUtil.xmlNodeToString(doc, encoding);
        return new ByteArrayInputStream(xml.getBytes(encoding));
    }
}

