/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.model.action;

import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.HttpMethod;
import com.aliyun.mq.http.common.ServiceException;
import com.aliyun.mq.http.common.auth.ServiceCredentials;
import com.aliyun.mq.http.common.auth.ServiceSignature;
import com.aliyun.mq.http.common.comm.ExecutionContext;
import com.aliyun.mq.http.common.http.ExceptionResultParser;
import com.aliyun.mq.http.common.http.HttpCallback;
import com.aliyun.mq.http.common.http.RequestMessage;
import com.aliyun.mq.http.common.http.ServiceClient;
import com.aliyun.mq.http.common.parser.ResultParser;
import com.aliyun.mq.http.common.utils.DateUtil;
import com.aliyun.mq.http.model.AbstractRequest;
import com.aliyun.mq.http.model.AsyncCallback;
import com.aliyun.mq.http.model.AsyncResult;
import com.aliyun.mq.http.model.action.Action;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.log4j.Logger;

public abstract class AbstractAction<T extends AbstractRequest, V>
implements Action<T, V> {
    public static Logger logger = Logger.getLogger(AbstractAction.class);
    protected String actionName = "";
    private ServiceClient client;
    private ServiceCredentials credentials;
    private HttpMethod method;
    private URI endpoint;

    public AbstractAction(HttpMethod method, String actionName, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        this.method = method;
        this.actionName = actionName;
        this.client = client;
        this.endpoint = endpoint;
        this.credentials = credentials;
    }

    private static TreeMap<String, String> sortHeader(Map<String, String> headers) {
        TreeMap<String, String> tmpHeaders = new TreeMap<String, String>();
        Set<String> keySet = headers.keySet();
        for (String key : keySet) {
            if (key.toLowerCase().startsWith("x-mq-")) {
                tmpHeaders.put(key.toLowerCase(), headers.get(key));
                continue;
            }
            tmpHeaders.put(key, headers.get(key));
        }
        return tmpHeaders;
    }

    private static String safeGetHeader(String key, Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        String value = headers.get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public ServiceClient getClient() {
        return this.client;
    }

    @Override
    public ServiceCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public AsyncResult<V> execute(T reqObject, AsyncCallback<V> asyncHandler) throws ClientException, ServiceException {
        return this.executeWithCustomHeaders(reqObject, asyncHandler, null);
    }

    public AsyncResult<V> executeWithCustomHeaders(T reqObject, AsyncCallback<V> asyncHandler, Map<String, String> customHeaders) throws ClientException, ServiceException {
        RequestMessage request = this.buildRequestMessage(reqObject);
        request.setMethod(this.getMethod());
        this.addRequiredHeader(request);
        this.addCustomHeader(request, customHeaders);
        this.addSignatureHeader(request);
        HttpCallback<V> callback = new HttpCallback<V>(this.buildResultParser(), this.buildExceptionParser(), asyncHandler);
        AsyncResult<V> asyncResult = callback.getAsyncResult();
        asyncResult.setTimewait(this.client.getClientConfiguration().getSocketTimeout());
        Future<HttpResponse> future = this.client.sendRequest(request, new ExecutionContext(), callback);
        asyncResult.setFuture(future);
        return asyncResult;
    }

    @Override
    public V execute(T reqObject) throws ClientException, ServiceException {
        return this.executeWithCustomHeaders(reqObject, null);
    }

    public V executeWithCustomHeaders(T reqObject, Map<String, String> customHeaders) throws ClientException, ServiceException {
        AsyncResult<V> result = this.executeWithCustomHeaders(reqObject, null, customHeaders);
        V value = result.getResult();
        if (result.isSuccess()) {
            return value;
        }
        if (result.getException() instanceof ClientException) {
            throw (ClientException)result.getException();
        }
        if (result.getException() instanceof ServiceException) {
            throw (ServiceException)result.getException();
        }
        ClientException ce = new ClientException(result.getException().toString(), null, result.getException());
        ce.setStackTrace(result.getException().getStackTrace());
        throw ce;
    }

    private void addCustomHeader(RequestMessage request, Map<String, String> customHeaders) {
        if (customHeaders == null || customHeaders.size() == 0) {
            return;
        }
        for (String key : customHeaders.keySet()) {
            request.getHeaders().put(key, customHeaders.get(key));
        }
    }

    protected void addRequiredHeader(RequestMessage request) {
        request.getHeaders().put("x-mq-version", "2015-06-06");
        if (request.getHeaders().get("Date") == null) {
            request.getHeaders().put("Date", DateUtil.formatRfc822Date(new Date()));
        }
        if (request.getHeaders().get("Content-Type") == null) {
            request.getHeaders().put("Content-Type", "text/xml;charset=UTF-8");
        }
    }

    protected void addSignatureHeader(RequestMessage request) throws ClientException {
        if (this.credentials != null && this.credentials.getAccessKeyId() != null && this.credentials.getAccessKeySecret() != null) {
            request.addHeader("Authorization", "MQ " + this.credentials.getAccessKeyId() + ":" + this.getSignature(request));
            String securityToken = this.credentials.getSecurityToken();
            if (securityToken != null && !"".equals(securityToken)) {
                request.addHeader("security-token", securityToken);
            }
        }
    }

    private String getRelativeResourcePath(String subPath) {
        String rootPath = this.endpoint.getPath();
        if (subPath != null && !"".equals(subPath.trim())) {
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            if (!rootPath.endsWith("/")) {
                return rootPath + "/" + subPath;
            }
            return rootPath + subPath;
        }
        return rootPath;
    }

    private String getSignature(RequestMessage request) throws ClientException {
        String signature;
        Map<String, String> headers = request.getHeaders();
        StringBuffer canonicalizedHeaders = new StringBuffer();
        StringBuffer stringToSign = new StringBuffer();
        String contentMd5 = AbstractAction.safeGetHeader("Content-MD5", headers);
        String contentType = AbstractAction.safeGetHeader("Content-Type", headers);
        String date = AbstractAction.safeGetHeader("Date", headers);
        String canonicalizedResource = this.getRelativeResourcePath(request.getResourcePath());
        TreeMap<String, String> tmpHeaders = AbstractAction.sortHeader(request.getHeaders());
        if (tmpHeaders.size() > 0) {
            Set<String> keySet = tmpHeaders.keySet();
            for (String key : keySet) {
                if (!key.toLowerCase().startsWith("x-mq-")) continue;
                canonicalizedHeaders.append(key).append(":").append(tmpHeaders.get(key)).append("\n");
            }
        }
        stringToSign.append((Object)this.method).append("\n").append(contentMd5).append("\n").append(contentType).append("\n").append(date).append("\n").append(canonicalizedHeaders).append(canonicalizedResource);
        try {
            signature = ServiceSignature.create().computeSignature(this.credentials.getAccessKeySecret(), stringToSign.toString());
        }
        catch (Exception e) {
            throw new ClientException("Signature fail", null, e);
        }
        return signature;
    }

    protected RequestMessage buildRequestMessage(T reqObject) throws ClientException {
        RequestMessage request = this.buildRequest(reqObject);
        String requestPath = request.getResourcePath();
        if (requestPath != null && (requestPath.startsWith("http://") || requestPath.startsWith("https://"))) {
            if (!requestPath.startsWith(this.endpoint.toString())) {
                throw new IllegalArgumentException("Endpoint[" + this.endpoint.toString() + "]\u548c\u8bbf\u95ee\u5730\u5740[" + requestPath + "]\u4e0d\u5339\u914d.");
            }
            if ((requestPath = requestPath.substring(this.endpoint.toString().length())).startsWith("/")) {
                requestPath = requestPath.substring(1);
            }
            request.setResourcePath(requestPath);
        }
        request.setEndpoint(this.endpoint);
        return request;
    }

    protected ResultParser<V> buildResultParser() {
        return null;
    }

    protected ResultParser<Exception> buildExceptionParser() {
        return new ExceptionResultParser(null);
    }

    protected abstract RequestMessage buildRequest(T var1) throws ClientException;
}

