/*
 * Decompiled with CFR 0.152.
 */
package yangcai.messagebox.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yangcai.messagebox.config.MessageBoxConfig;

@Component
public class TokenUtil {
    private static final Log log = LogFactory.getLog(TokenUtil.class);
    private static MessageBoxConfig config;

    public static String getAccessToken() {
        String url = null;
        try {
            url = URLDecoder.decode(config.getAccessTokenUrl(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpPost post = new HttpPost(url);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String access_token = "";
        CloseableHttpResponse resultRep = null;
        try {
            resultRep = httpclient.execute((HttpUriRequest)post);
            int statusCode = resultRep.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                JSONObject json = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)resultRep.getEntity()));
                access_token = json.getString("access_token");
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return access_token;
    }

    @Autowired
    public void setMessageBoxConfig(MessageBoxConfig config) {
        TokenUtil.config = config;
    }
}

