/*
 * Decompiled with CFR 0.152.
 */
package yangcai.messagebox.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import yangcai.messagebox.model.LoginUser;

public final class MessageUtil {
    private static final Log log = LogFactory.getLog(MessageUtil.class);
    private static final ConcurrentHashMap<String, LoginUser> userMap = new ConcurrentHashMap(100);
    private static final ConcurrentHashMap<ChannelId, LoginUser> channelIdMap = new ConcurrentHashMap(100);

    public static LoginUser getUserById(String sysCode, String userType, String userId) {
        return userMap.get(sysCode + "-" + userType + "-" + userId);
    }

    public static LoginUser getUserByTag(String tag) {
        if (null != tag && tag.length() > 4) {
            return userMap.get(tag.substring(0, tag.length() - 4));
        }
        return null;
    }

    public static LoginUser getUserByChannelId(ChannelId channelId) {
        return channelIdMap.get(channelId);
    }

    public static boolean removeChannelsById(Channel channel) {
        LoginUser user = channelIdMap.get(channel.id());
        if (user != null) {
            channelIdMap.remove(channel.id());
            user.destroyChannel(channel);
            if (!user.hasChannels()) {
                userMap.remove(user.getSysCode() + "-" + user.getUserType() + "-" + user.getUserId());
            }
        }
        return true;
    }

    public static boolean putUserChannel(String sysCode, int userType, String userId, Channel channel) throws Exception {
        LoginUser user = userMap.get(sysCode + "-" + userType + "-" + userId);
        List<Channel> channelList = null;
        if (user == null) {
            channelList = new ArrayList<Channel>();
            channelList.add(channel);
            user = new LoginUser(sysCode, userType, userId, channelList);
            log.debug((Object)("user == null:" + user));
            userMap.put(sysCode + "-" + userType + "-" + userId, user);
        } else {
            channelList = user.getChannels();
        }
        log.debug((Object)("channelList" + channelList));
        if (!channelList.contains(channel)) {
            channelList.add(channel);
        }
        log.debug((Object)("user:" + user));
        channelIdMap.put(channel.id(), user);
        return true;
    }
}

