/*
 * Decompiled with CFR 0.152.
 */
package yangcai.messagebox.handler;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import yangcai.messagebox.config.MessageBoxConfig;
import yangcai.messagebox.model.MessageBusi;
import yangcai.messagebox.model.MessageResult;
import yangcai.messagebox.util.TokenUtil;

@Component
public class MessageProducerHandler {
    private static final Log log = LogFactory.getLog(MessageProducerHandler.class);
    private static MessageBoxConfig config;

    public static MessageResult sendMessage(MessageBusi messageBusi, HashMap<String, String> propertyMap) {
        try {
            messageBusi.setState(1);
            messageBusi.setSendTime(new Date());
            if (StringUtils.isEmpty((Object)messageBusi.getProducerPlatformType())) {
                messageBusi.setProducerPlatformType(config.getSysCode());
            }
            StringBuffer tagName = new StringBuffer();
            tagName.append(messageBusi.getConsumerPlatformType());
            tagName.append("-");
            tagName.append(messageBusi.getConsumerOperateType());
            tagName.append("-");
            tagName.append(messageBusi.getConsumerOperateCode());
            tagName.append("-tag");
            messageBusi.setTags(URLEncoder.encode(tagName.toString(), "GBK"));
            HttpPost post = new HttpPost(config.getBusiAddress() + "save");
            post.setHeader("Authorization", "bearer " + TokenUtil.getAccessToken());
            CloseableHttpClient httpclient = HttpClients.createDefault();
            StringEntity stringEntity = new StringEntity(JSONObject.toJSONString((Object)messageBusi), ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)stringEntity);
            try {
                CloseableHttpResponse resultRep = httpclient.execute((HttpUriRequest)post);
                int statusCode = resultRep.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    log.info((Object)"\u65b0\u589e\u6d88\u606f\u6210\u529f");
                }
            }
            catch (Exception e) {
                log.error((Object)e.toString());
                return MessageResult.failed(e.toString());
            }
            return MessageResult.succeed("\u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            log.error((Object)e);
            return MessageResult.failed(e.toString());
        }
    }

    @Autowired
    public void setMessageBoxConfig(MessageBoxConfig config) {
        MessageProducerHandler.config = config;
    }
}

