/*
 * Decompiled with CFR 0.152.
 */
package yangcai.messagebox.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yangcai.messagebox.config.MessageBoxConfig;
import yangcai.messagebox.model.LoginUser;
import yangcai.messagebox.model.MessageBusi;
import yangcai.messagebox.util.MessageUtil;
import yangcai.messagebox.util.TokenUtil;

@Component
public class CusumerThreads
extends Thread {
    private static final Log log = LogFactory.getLog(CusumerThreads.class);
    private static MessageBoxConfig config;

    @Autowired
    public void setMessageBoxConfig(MessageBoxConfig config) {
        CusumerThreads.config = config;
    }

    @Override
    public void run() {
        log.info((Object)("\u6d88\u606f\u76d2\u5b50\u6d88\u8d39\u7ebf\u7a0b\u540d\u79f0\uff1a" + this.getName() + "\u5f00\u59cb\u8fd0\u884c\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002"));
        while (true) {
            try {
                while (true) {
                    CloseableHttpClient httpclient = HttpClients.createDefault();
                    HttpGet get = new HttpGet(config.getBusiAddress() + "list?consumerPlatformType=" + config.getSysCode() + "&state=1&page=1&limit=100");
                    get.setHeader("Authorization", "bearer " + TokenUtil.getAccessToken());
                    CloseableHttpResponse resultRep = httpclient.execute((HttpUriRequest)get);
                    int statusCode = resultRep.getStatusLine().getStatusCode();
                    List messages = null;
                    if (statusCode == 200) {
                        String resultString = EntityUtils.toString((HttpEntity)resultRep.getEntity());
                        JSONObject jsonObject = JSONObject.parseObject((String)resultString);
                        int total = jsonObject.getIntValue("count");
                        if (total == 0) {
                            Thread.sleep(7000L);
                            continue;
                        }
                        JSONArray array = jsonObject.getJSONArray("data");
                        messages = array.toJavaList(MessageBusi.class);
                    } else {
                        try {
                            Thread.sleep(60000L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    log.info((Object)("\u6d88\u606f\u76d2\u5b50\u7ebf\u7a0b\u540d\u79f0\uff1a" + Thread.currentThread().getName() + ": \u6536\u5230\u6d88\u606f!"));
                    StringBuffer tempIds = new StringBuffer();
                    for (MessageBusi message : messages) {
                        tempIds.append(message.getId());
                        tempIds.append(",");
                    }
                    tempIds.deleteCharAt(tempIds.length() - 1);
                    HttpPost post = new HttpPost(config.getBusiAddress() + "consumeMessage?ids=" + tempIds);
                    post.setHeader("Authorization", "bearer " + TokenUtil.getAccessToken());
                    resultRep = httpclient.execute((HttpUriRequest)post);
                    statusCode = resultRep.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        log.info((Object)"\u66f4\u65b0\u6d88\u606f\u6d88\u8d39\u72b6\u6001\u6210\u529f");
                    } else {
                        log.error((Object)"\u66f4\u65b0\u6d88\u606f\u6d88\u8d39\u72b6\u6001\u5931\u8d25(\u975e\u91cd\u8981)");
                    }
                    for (MessageBusi message : messages) {
                        LoginUser user = MessageUtil.getUserById(message.getConsumerPlatformType(), message.getConsumerOperateType(), message.getConsumerOperateCode());
                        JSONArray array = new JSONArray();
                        JSONObject obj = (JSONObject)JSON.toJSON((Object)message);
                        array.add((Object)obj);
                        if (user == null || !user.hasChannels()) continue;
                        for (Channel channel : user.getChannels()) {
                            channel.writeAndFlush((Object)new TextWebSocketFrame(array.toJSONString()));
                        }
                    }
                    Thread.sleep(7000L);
                }
            }
            catch (Throwable e) {
                log.error((Object)("::::" + e.toString()), e);
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    static {
        new CusumerThreads().start();
    }
}

