/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.face;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AipFace
extends BaseClient {
    public AipFace(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject detect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject detect(String image, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(image);
            return this.detect(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject match(byte[][] images, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        ArrayList<String> buffer = new ArrayList<String>();
        for (byte[] data : images) {
            String base64Str = Base64Util.encode(data);
            buffer.add(base64Str);
        }
        String imgDataAll = Util.mkString(buffer.iterator(), ',');
        request.addBody("images", imgDataAll);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/match");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject match(List<String> images, HashMap<String, String> options) {
        try {
            byte[][] imgData = new byte[images.size()][];
            int idx = 0;
            for (String path : images) {
                imgData[idx] = Util.readFileByBytes(path);
                ++idx;
            }
            return this.match(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject identifyUser(String groupId, byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/identify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject identifyUser(String groupId, String image, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(image);
            return this.identifyUser(groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject verifyUser(String uid, String groupId, byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("group_id", groupId);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/verify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject verifyUser(String uid, String groupId, String image, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(image);
            return this.verifyUser(uid, groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject multiIdentify(String groupId, byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/multi-identify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multiIdentify(String groupId, String image, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(image);
            return this.multiIdentify(groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject addUser(String uid, String userInfo, String groupId, byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("user_info", userInfo);
        request.addBody("group_id", groupId);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject addUser(String uid, String userInfo, String groupId, String image, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(image);
            return this.addUser(uid, userInfo, groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject updateUser(String uid, String userInfo, String groupId, byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("user_info", userInfo);
        request.addBody("group_id", groupId);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject updateUser(String uid, String userInfo, String groupId, String image, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(image);
            return this.updateUser(uid, userInfo, groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject deleteUser(String uid, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getUser(String uid, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/get");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getGroupList(HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/getlist");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getGroupUsers(String groupId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/getusers");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject addGroupUser(String srcGroupId, String groupId, String uid, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("src_group_id", srcGroupId);
        request.addBody("group_id", groupId);
        request.addBody("uid", uid);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/adduser");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject deleteGroupUser(String groupId, String uid, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        request.addBody("uid", uid);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/deleteuser");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject livenessVerify(String imgPath, HashMap<String, Object> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.livenessVerify(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject livenessVerify(byte[] imgData, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Str = Base64Util.encode(imgData);
        request.addBody("image", base64Str);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceverify");
        this.postOperation(request);
        return this.requestServer(request);
    }
}

