/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.oss.service.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.Callback;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.zhiqim.oss.service.OssServer;
import com.zhiqim.oss.service.oss.OssService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class OssUploadService {
    private OssServer server = null;

    public OssUploadService(OssServer server) {
        this.server = server;
    }

    public OssServer getServer() {
        return this.server;
    }

    public String uploadString(String bucketName, String key, String content) throws Exception {
        return this.uploadString(bucketName, key, content, false);
    }

    public String uploadString(String bucketName, String key, String content, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            ossClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(content.getBytes()));
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String uploadByte(String bucketName, String key, byte[] content) throws Exception {
        return this.uploadByte(bucketName, key, content, false);
    }

    public String uploadByte(String bucketName, String key, byte[] content, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            ossClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(content));
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String uploadNetFlow(String bucketName, String key, String url) throws Exception {
        return this.uploadNetFlow(bucketName, key, url, false);
    }

    public String uploadNetFlow(String bucketName, String key, String url, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            InputStream inputStream = new URL(url).openStream();
            ossClient.putObject(bucketName, key, inputStream);
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String uploadFileFlow(String bucketName, String key, String filePath) throws Exception {
        return this.uploadFileFlow(bucketName, key, filePath, false);
    }

    public String uploadFileFlow(String bucketName, String key, String filePath, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            FileInputStream inputStream = new FileInputStream(filePath);
            ossClient.putObject(bucketName, key, (InputStream)inputStream);
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String uploadFile(String bucketName, String key, String filePath) throws Exception {
        return this.uploadFile(bucketName, key, filePath, false);
    }

    public String uploadFile(String bucketName, String key, String filePath, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            ossClient.putObject(bucketName, key, new File(filePath));
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String uploadFileInfo(String bucketName, String key, String content) throws Exception {
        return this.uploadFileInfo(bucketName, key, content, false);
    }

    public String uploadFileInfo(String bucketName, String key, String content, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength((long)content.length());
            String md5 = BinaryUtil.toBase64String((byte[])BinaryUtil.calculateMd5((byte[])content.getBytes()));
            meta.setContentMD5(md5);
            meta.setContentType("text/plain");
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            ossClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(content.getBytes()), meta);
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String uploadFileUserInfo(String bucketName, String key, String content, Map<String, String> maps) throws Exception {
        return this.uploadFileUserInfo(bucketName, key, content, maps, false);
    }

    public String uploadFileUserInfo(String bucketName, String key, String content, Map<String, String> maps, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            ObjectMetadata meta = new ObjectMetadata();
            for (String item : maps.keySet()) {
                meta.addUserMetadata(item, maps.get(item));
            }
            ossClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(content.getBytes()), meta);
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String addUpload(String bucketName, String key, String content) throws Exception {
        return this.addUpload(bucketName, key, content, false);
    }

    public String addUpload(String bucketName, String key, String content, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucketName, key, (InputStream)new ByteArrayInputStream(content.getBytes()));
            appendObjectRequest.setPosition(Long.valueOf(0L));
            AppendObjectResult appendObjectResult = ossClient.appendObject(appendObjectRequest);
            appendObjectRequest.setPosition(appendObjectResult.getNextPosition());
            appendObjectResult = ossClient.appendObject(appendObjectRequest);
            appendObjectRequest.setPosition(appendObjectResult.getNextPosition());
            appendObjectResult = ossClient.appendObject(appendObjectRequest);
            OssService ossService = new OssService(this.server);
            String string = ossService.getUrl(bucketName, key);
            return string;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String uploadFileBreak(String bucketName, String key, String filePath) throws Exception {
        return this.uploadFileBreak(bucketName, key, filePath, false);
    }

    public String uploadFileBreak(String bucketName, String key, String filePath, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, key);
            uploadFileRequest.setUploadFile(filePath);
            uploadFileRequest.setTaskNum(5);
            uploadFileRequest.setPartSize(0x100000L);
            uploadFileRequest.setEnableCheckpoint(true);
            try {
                ossClient.uploadFile(uploadFileRequest);
                OssService ossService = new OssService(this.server);
                String string = ossService.getUrl(bucketName, key);
                return string;
            }
            catch (Throwable e) {
                try {
                    throw new Exception("\u6587\u4ef6" + filePath + "\u4e0a\u4f20\u5931\u8d25", e);
                }
                catch (OSSException oe) {
                    throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
                }
                catch (ClientException ce) {
                    throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
                }
            }
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public void uploadFileCallback(String bucketName, String key, String content, String callbackUrl, String callbackBody) throws Exception {
        this.uploadFileCallback(bucketName, key, content, callbackUrl, callbackBody, false);
    }

    public void uploadFileCallback(String bucketName, String key, String content, String callbackUrl, String callbackBody, boolean isInternal) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        ossClient = isInternal ? new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret()) : new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, (InputStream)new ByteArrayInputStream(content.getBytes()));
        Callback callback = new Callback();
        callback.setCallbackUrl(callbackUrl);
        callback.setCallbackHost("oss-cn-shenzhen.aliyuncs.com");
        callback.setCallbackBody(callbackBody);
        putObjectRequest.setCallback(callback);
        PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
        byte[] buffer = new byte[1024];
        putObjectResult.getCallbackResponseBody().read(buffer);
        putObjectResult.getCallbackResponseBody().close();
        ossClient.shutdown();
    }
}

