/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.oss.service.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.zhiqim.oss.service.OssServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zhiqim.kernel.util.Strings;

public class OssService {
    private OssServer server = null;

    public OssService(OssServer server) {
        this.server = server;
    }

    public OssServer getServer() {
        return this.server;
    }

    public void createFolder(String bucketName, String key) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            try {
                ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
                ossClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(new byte[0]));
            }
            catch (OSSException oe) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
            }
            catch (ClientException ce) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
            }
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public List<OSSObjectSummary> getObject(String bucketName, String KeyPrifex) throws Exception {
        OSSClient ossClient = null;
        try {
            List sums;
            ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            ObjectListing objectListing = ossClient.listObjects(bucketName, KeyPrifex);
            List list = sums = objectListing.getObjectSummaries();
            return list;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String getAccessUrl(String bucketName, String key, OSSClient ossClient) throws Exception {
        this.server.checkKey(key);
        Date expiration = new Date(new Date().getTime() + 3600000L);
        URL url = ossClient.generatePresignedUrl(bucketName, key, expiration);
        return Strings.toString((Object)url);
    }

    public String getUrl(String bucketName, String key) throws Exception {
        this.server.checkKey(key);
        String endpoint = this.server.getEndpointExternal();
        String prefix = Strings.substring((String)endpoint, (int)0, (int)(endpoint.indexOf("//") + 2));
        endpoint = endpoint.replace("http://", "");
        endpoint = endpoint.replace("https://", "");
        String url = String.valueOf(prefix) + bucketName + "." + endpoint;
        url = String.valueOf(Strings.addEndsWith((String)url, (String)"/")) + Strings.removeStartsWith((String)key, (String)"/");
        return url;
    }

    public void deleteFile(String bucketName, String key) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            try {
                ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
                ossClient.deleteObject(bucketName, key);
            }
            catch (OSSException oe) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
            }
            catch (ClientException ce) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
            }
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public DeleteObjectsResult deleteFiles(String bucketName, List<String> keys) throws Exception {
        OSSClient ossClient = null;
        try {
            DeleteObjectsResult deleteObjectsResult;
            ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            DeleteObjectsResult deleteObjectsResult2 = deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(bucketName).withKeys(keys));
            return deleteObjectsResult2;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public CopyObjectResult doCopy(String srcBucketName, String srcKey, String destBucketName, String destKey) throws Exception {
        this.server.checkKey(srcKey);
        this.server.checkKey(destKey);
        OSSClient ossClient = null;
        try {
            CopyObjectResult result;
            ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            CopyObjectResult copyObjectResult = result = ossClient.copyObject(srcBucketName, srcKey, destBucketName, destKey);
            return copyObjectResult;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public CopyObjectResult doCopyObject(String srcBucketName, String srcKey, String destBucketName, String destKey) throws Exception {
        this.server.checkKey(srcKey);
        this.server.checkKey(destKey);
        OSSClient ossClient = null;
        try {
            CopyObjectResult result;
            ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketName, srcKey, destBucketName, destKey);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("text/html");
            copyObjectRequest.setNewObjectMetadata(meta);
            CopyObjectResult copyObjectResult = result = ossClient.copyObject(copyObjectRequest);
            return copyObjectResult;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public void doCopyLarge(String srcBucketName, String srcKey, String destBucketName, String destKey) throws Exception {
        this.server.checkKey(srcKey);
        this.server.checkKey(destKey);
        OSSClient ossClient = null;
        try {
            try {
                ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
                ObjectMetadata objectMetadata = ossClient.getObjectMetadata(srcBucketName, srcKey);
                long contentLength = objectMetadata.getContentLength();
                long partSize = 0xA00000L;
                int partCount = (int)(contentLength / partSize);
                if (contentLength % partSize != 0L) {
                    ++partCount;
                }
                InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(destBucketName, destKey);
                InitiateMultipartUploadResult initiateMultipartUploadResult = ossClient.initiateMultipartUpload(initiateMultipartUploadRequest);
                String uploadId = initiateMultipartUploadResult.getUploadId();
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                int i = 0;
                while (i < partCount) {
                    long skipBytes = partSize * (long)i;
                    long size = partSize < contentLength - skipBytes ? partSize : contentLength - skipBytes;
                    UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest(srcBucketName, srcKey, destBucketName, destKey);
                    uploadPartCopyRequest.setUploadId(uploadId);
                    uploadPartCopyRequest.setPartSize(Long.valueOf(size));
                    uploadPartCopyRequest.setBeginIndex(Long.valueOf(skipBytes));
                    uploadPartCopyRequest.setPartNumber(i + 1);
                    UploadPartCopyResult uploadPartCopyResult = ossClient.uploadPartCopy(uploadPartCopyRequest);
                    partETags.add(uploadPartCopyResult.getPartETag());
                    ++i;
                }
                CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(destBucketName, destKey, uploadId, partETags);
                ossClient.completeMultipartUpload(completeMultipartUploadRequest);
            }
            catch (OSSException oe) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
            }
            catch (ClientException ce) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
            }
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }
}

