/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.policy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMI18n;
import org.zhiqim.orm.ORMPolicy;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ORMType;
import org.zhiqim.orm.dbo.defined._Table;
import org.zhiqim.orm.dbo.defined._TableField;
import org.zhiqim.orm.dbo.defined._TableIndex;

public class _SQLite
implements ORMPolicy {
    private ORMServer server;

    public _SQLite(ORMServer server) {
        this.server = server;
    }

    @Override
    public boolean chkKeepTime(int maxKeepTime) {
        return true;
    }

    @Override
    public String toExistsSQL(String databaseName, String tableName) {
        return Strings.format((String)"select count(*) from sqlite_master where type='table' and name='%s'", (Object[])new Object[]{tableName});
    }

    @Override
    public String toAlertColumnAdd(String table, String column, String columnType, boolean notNull) {
        return "alter table " + table.toUpperCase() + " add column " + column.toUpperCase() + " " + columnType + (notNull ? " not null default 0" : " default null");
    }

    @Override
    public String toColumnType(String type) {
        int ctype = ORMType.getColumnTypeMaybeLength(type);
        switch (ctype) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return "integer";
            }
            case 7: {
                return "datetime";
            }
            case 8: {
                String[] values = Arrays.toStringArray((String)type);
                Asserts.asserts((values.length == 3 ? 1 : 0) != 0, (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                Asserts.asserts((boolean)Validates.isIntegerPositive((String)values[1]), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                Asserts.asserts((boolean)Validates.isIntegerPositive((String)values[2]), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                return "numeric(" + values[1] + "," + values[2] + ")";
            }
            case 1: {
                String[] values = Arrays.toStringArray((String)type);
                Asserts.asserts((values.length > 1 ? 1 : 0) != 0, (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                Asserts.asserts((boolean)Validates.isIntegerPositive((String)values[1]), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                if (values.length == 3 && "char".equals(values[2])) {
                    Asserts.asserts((boolean)Validates.isIntegerValue((String)values[1], (int)1, (int)255), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                    return "char(" + values[1] + ")";
                }
                int length = Ints.toInt((String)values[1]);
                if (length <= 4000) {
                    return "varchar(" + values[1] + ")";
                }
                return "text";
            }
            case 9: {
                return "blob";
            }
        }
        throw Asserts.exception((String)"\u4f20\u5165\u7684\u7c7b\u578b[%s]\u4e0d\u652f\u6301", (Object[])new Object[]{type});
    }

    @Override
    public String toColumnString(_TableField field) {
        String column = field.getColumn();
        String columnType = this.toColumnType(field.getTypeAndLength());
        boolean notNull = field.isNotNull();
        return column.toUpperCase() + " " + columnType + " " + (notNull ? "NOT NULL" : "NULL");
    }

    @Override
    public List<String> toTableString(_Table _table, MapSS replaceMap) {
        String key = _table.getKey();
        String tableReplace = Sqls.formatReplaceMap((String)_table.getTable(), (MapSS)replaceMap);
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuilder strb = new StringBuilder();
        strb.append("create table if not exists ").append(tableReplace).append("\r\n").append("(");
        for (_TableField field : _table.getFieldList()) {
            strb.append("\r\n").append("    ").append(this.toColumnString(field)).append(",");
        }
        if (_table.getKeyArr().length == 0) {
            strb.setLength(strb.length() - 1);
        } else {
            strb.append("\r\n").append("    ").append("primary key (").append(key).append(")");
        }
        strb.append("\r\n").append(");").append("\r\n");
        sqlList.add(Sqls.formatSpace((String)strb.toString()));
        for (_TableIndex index : _table.getIndexList()) {
            String indexNameReplace = Sqls.formatReplaceMap((String)index.getName(), (MapSS)replaceMap);
            StringBuilder strbIndex = new StringBuilder("create ").append(index.getType()).append(" index ").append(indexNameReplace).append(" on ").append(tableReplace).append("(").append(index.getColumn()).append(");").append("\r\n");
            sqlList.add(Sqls.formatSpace((String)strbIndex.toString()));
        }
        return Lists.trim(sqlList);
    }

    @Override
    public String toItemSQL(String fieldSQL, String tableName, String whereSQL, String orderbySQL, String groupbySQL) {
        return "select " + fieldSQL + " from " + tableName + whereSQL + orderbySQL + groupbySQL + " limit 1";
    }

    @Override
    public String toPageSQL(String fieldSQL, String tableName, String whereSQL, String orderbySQL, String groupbySQL, int maxNum, int pageNo) {
        return "select " + fieldSQL + " from " + tableName + whereSQL + orderbySQL + groupbySQL + " limit #minSize#, #pageSize#";
    }

    @Override
    public String toPageViewSQL(StringBuilder innerTableSQL, int maxNum, int pageNo) {
        return "select * from " + innerTableSQL + " p_ limit #minSize#, #pageSize#";
    }

    @Override
    public void executeAlertColumnDrop(String table, String column) throws ORMException, SQLException {
        table = table.toUpperCase();
        List<LinkedMapSO> list = this.getTableColumnList(table);
        column = column.toUpperCase();
        boolean exists = false;
        StringBuilder oldColumns = new StringBuilder();
        StringBuilder tempTableKeys = new StringBuilder();
        Iterator<LinkedMapSO> it = list.iterator();
        while (it.hasNext()) {
            LinkedMapSO map = it.next();
            String columnName = (String)map.get("name");
            if (columnName.equalsIgnoreCase(column)) {
                it.remove();
                exists = true;
                continue;
            }
            oldColumns.append(columnName).append(",");
            if ((Integer)map.get("pk") != 1) continue;
            tempTableKeys.append(columnName).append(",");
        }
        if (!exists) {
            throw new ORMException("\u8868[%s]\u6ca1\u6709\u5217[%s]", table, column);
        }
        if (list.isEmpty()) {
            throw new ORMException("\u8868[%s]\u53ea\u6709\u8be5[%s]\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u5982\u679c\u8981\u5220\u9664\u8bf7\u5220\u9664\u8868", table, column);
        }
        oldColumns.setLength(oldColumns.length() - 1);
        if (tempTableKeys.length() > 0) {
            tempTableKeys.setLength(tempTableKeys.length() - 1);
        }
        this.recreateTable("\u5220\u9664\u5217", table, list, oldColumns, tempTableKeys);
    }

    @Override
    public void executeAlertColumnType(String table, String column, String newColumnType, boolean newNotNull) throws ORMException, SQLException {
        table = table.toUpperCase();
        List<LinkedMapSO> list = this.getTableColumnList(table);
        column = column.toUpperCase();
        boolean exists = false;
        StringBuilder oldColumns = new StringBuilder();
        StringBuilder tempTableKeys = new StringBuilder();
        for (LinkedMapSO map : list) {
            String columnName = (String)map.get("name");
            oldColumns.append(columnName).append(",");
            if (columnName.equalsIgnoreCase(column)) {
                map.put("type", (Object)newColumnType);
                map.put("notnull", (Object)(newNotNull ? 1 : 0));
                exists = true;
            }
            if ((Integer)map.get("pk") != 1) continue;
            tempTableKeys.append(columnName).append(",");
        }
        if (!exists) {
            throw Asserts.exception((String)"\u8868[%s]\u6ca1\u6709\u5217[%s]", (Object[])new Object[]{table, column});
        }
        oldColumns.setLength(oldColumns.length() - 1);
        if (tempTableKeys.length() > 0) {
            tempTableKeys.setLength(tempTableKeys.length() - 1);
        }
        this.recreateTable("\u4fee\u6539\u5217\u7c7b\u578b", table, list, oldColumns, tempTableKeys);
    }

    @Override
    public void executeAlertColumnName(String table, String column, String newColumn) throws ORMException, SQLException {
        table = table.toUpperCase();
        List<LinkedMapSO> list = this.getTableColumnList(table);
        column = column.toUpperCase();
        boolean exists = false;
        StringBuilder oldColumns = new StringBuilder();
        StringBuilder tempTableKeys = new StringBuilder();
        for (LinkedMapSO map : list) {
            String columnName = (String)map.get("name");
            oldColumns.append(columnName).append(",");
            if (columnName.equalsIgnoreCase(column)) {
                columnName = newColumn;
                map.put("name", (Object)newColumn);
                exists = true;
            }
            if ((Integer)map.get("pk") != 1) continue;
            tempTableKeys.append(columnName).append(",");
        }
        if (!exists) {
            throw new ORMException("\u8868[%s]\u6ca1\u6709\u5217[%s]", table, column);
        }
        oldColumns.setLength(oldColumns.length() - 1);
        if (tempTableKeys.length() > 0) {
            tempTableKeys.setLength(tempTableKeys.length() - 1);
        }
        this.recreateTable("\u4fee\u6539\u5217\u540d", table, list, oldColumns, tempTableKeys);
    }

    @Override
    public void executeAlertColumnInfo(String table, String column, String newColumn, String newColumnType, boolean newNotNull) throws ORMException, SQLException {
        table = table.toUpperCase();
        List<LinkedMapSO> list = this.getTableColumnList(table);
        column = column.toUpperCase();
        boolean exists = false;
        StringBuilder oldColumns = new StringBuilder();
        StringBuilder tempTableKeys = new StringBuilder();
        for (LinkedMapSO map : list) {
            String columnName = (String)map.get("name");
            oldColumns.append(columnName).append(",");
            if (columnName.equalsIgnoreCase(column)) {
                columnName = newColumn;
                map.put("name", (Object)newColumn);
                map.put("type", (Object)newColumnType);
                map.put("notnull", (Object)(newNotNull ? 1 : 0));
                exists = true;
            }
            if ((Integer)map.get("pk") != 1) continue;
            tempTableKeys.append(columnName).append(",");
        }
        if (!exists) {
            throw new ORMException("\u8868[%s]\u6ca1\u6709\u5217[%s]", table, column);
        }
        oldColumns.setLength(oldColumns.length() - 1);
        tempTableKeys.setLength(tempTableKeys.length() - 1);
        if (tempTableKeys.length() > 0) {
            tempTableKeys.setLength(tempTableKeys.length() - 1);
        }
        this.recreateTable("\u4fee\u6539\u5217\u4fe1\u606f", table, list, oldColumns, tempTableKeys);
    }

    @Override
    public void executeAlertPrimaryKeyAdd(String table, String columns) throws ORMException, SQLException {
        table = table.toUpperCase();
        List<LinkedMapSO> list = this.getTableColumnList(table);
        StringBuilder oldColumns = new StringBuilder();
        for (LinkedMapSO map : list) {
            String columnName = (String)map.get("name");
            oldColumns.append(columnName).append(",");
        }
        oldColumns.setLength(oldColumns.length() - 1);
        StringBuilder tempTableKeys = new StringBuilder(columns);
        this.recreateTable("\u4fee\u6539\u4e3b\u952e", table, list, oldColumns, tempTableKeys);
    }

    @Override
    public void executeAlertPrimaryKeyDrop(String table) throws ORMException, SQLException {
        table = table.toUpperCase();
        List<LinkedMapSO> list = this.getTableColumnList(table);
        StringBuilder oldColumns = new StringBuilder();
        for (LinkedMapSO map : list) {
            String columnName = (String)map.get("name");
            oldColumns.append(columnName).append(",");
        }
        oldColumns.setLength(oldColumns.length() - 1);
        StringBuilder tempTableKeys = new StringBuilder();
        this.recreateTable("\u4fee\u6539\u4e3b\u952e", table, list, oldColumns, tempTableKeys);
    }

    private List<LinkedMapSO> getTableColumnList(String table) throws ORMException, SQLException {
        List<LinkedMapSO> list = this.server.sql().executeQuery("pragma table_info ('" + table + "')");
        if (list.isEmpty()) {
            throw new ORMException("\u8868[%s]\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u4efb\u4f55\u5217", table);
        }
        return list;
    }

    private void recreateTable(String intro, String table, List<LinkedMapSO> list, StringBuilder oldColumns, StringBuilder tempTableKeys) throws ORMException, SQLException {
        String tempTable = String.valueOf(table) + "_TEMP_" + Randoms.upperLetters((int)4);
        String createSQL = this.toTableSQL(tempTable, tempTableKeys.toString(), list);
        String insertSQL = "insert into " + tempTable + " select " + oldColumns.toString() + " from " + table + ";";
        String dropSQL = "drop table " + table + ";";
        String renameSQL = "alter table " + tempTable + " rename to " + table + ";";
        try {
            ArrayList<String> sqlList = new ArrayList<String>(4);
            sqlList.add(createSQL);
            sqlList.add(insertSQL);
            sqlList.add(dropSQL);
            sqlList.add(renameSQL);
            this.server.sql().execute(sqlList);
        }
        catch (Exception e) {
            this.server.sql().execute("drop table if exists " + tempTable);
            throw new ORMException("\u8868[%s][%s]\u65f6\u5f02\u5e38", (Throwable)e, table, intro);
        }
    }

    private String toTableSQL(String table, String key, List<LinkedMapSO> list) {
        StringBuilder strb = new StringBuilder();
        strb.append("create table ").append(table.toUpperCase()).append("\r\n").append("(");
        for (LinkedMapSO map : list) {
            String column = (String)map.get("name");
            String columnType = (String)map.get("type");
            boolean notNull = (Integer)map.get("notnull") == 1;
            strb.append("\r\n").append("    ").append(column.toUpperCase()).append(" ").append(columnType).append(" ").append(notNull ? "NOT NULL" : "NULL").append(",");
        }
        if (Validates.isEmpty((String)key)) {
            strb.setLength(strb.length() - 1);
        } else {
            strb.append("\r\n").append("    ").append("primary key (").append(key.toUpperCase()).append(")");
        }
        strb.append("\r\n").append(");").append("\r\n");
        return strb.toString();
    }
}

