/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.MultiInstancer;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ZSQL;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.ZTableCache;
import org.zhiqim.orm.ZTabler;
import org.zhiqim.orm.annotation.AnIndex;
import org.zhiqim.orm.annotation.AnIndexValue;
import org.zhiqim.orm.annotation.AnTable;
import org.zhiqim.orm.annotation.AnTableField;
import org.zhiqim.orm.annotation.AnTableReplace;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.orm.dbo.defined._Table;
import org.zhiqim.orm.dbo.defined._TableField;

class ZTableImplement
extends MultiInstancer
implements ZTable,
ORMConstants {
    private ORMServer server;
    private ZSQL zSQL;
    private ZTabler zTabler;
    private ZTableCache zCache;
    private HashMapCV<_Table> tableMap;

    public ZTableImplement(ORMServer server) {
        this.server = server;
        this.zSQL = server.sql();
        this.zTabler = server.tabler();
        this.zCache = new ZTableCache(server);
        this.tableMap = new HashMapCV(true);
    }

    public _Table getTable(Class<?> cls) {
        int n;
        int n2;
        Object[] objectArray;
        _Table _table = (_Table)this.tableMap.get(cls);
        if (_table != null) {
            return _table;
        }
        AnTable anTable = cls.getAnnotation(AnTable.class);
        if (anTable == null) {
            return null;
        }
        _table = new _Table(cls.getName(), anTable.table(), anTable.key(), anTable.type());
        AnIndex anIndex = cls.getAnnotation(AnIndex.class);
        if (anIndex != null) {
            AnIndexValue[] values = anIndex.value();
            objectArray = values;
            n2 = values.length;
            n = 0;
            while (n < n2) {
                Object value = objectArray[n];
                _table.addIndex(value.name(), value.column(), value.unique());
                ++n;
            }
        }
        Field[] fields = cls.getDeclaredFields();
        objectArray = fields;
        n2 = fields.length;
        n = 0;
        while (n < n2) {
            AnTableReplace r;
            Object field = objectArray[n];
            String fieldName = ((Field)field).getName();
            AnTableField f = ((Field)field).getAnnotation(AnTableField.class);
            if (f != null) {
                _table.addField(fieldName, f.column(), f.type(), f.notNull());
            }
            if ((r = ((Field)field).getAnnotation(AnTableReplace.class)) != null) {
                _table.addReplace(fieldName, r.value());
            }
            ++n;
        }
        this.tableMap.put(cls, (Object)_table);
        return _table;
    }

    @Override
    public _Table getTableByTableName(String tableName) {
        for (_Table _table : this.tableMap.values()) {
            if (!tableName.equals(_table.getTable())) continue;
            return _table;
        }
        Collection list = Global.getClassList();
        for (Class clazz : list) {
            _Table _table;
            if (!clazz.isAnnotationPresent(AnTable.class) || !tableName.equals((_table = this.getTable(clazz)).getTable())) continue;
            return _table;
        }
        return null;
    }

    void schedule() {
        this.zCache.schedule();
    }

    @Override
    public <T> void cache(Class<T> cls) throws ORMException, SQLException {
        if (!this.server.isCache(cls)) {
            return;
        }
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[cache][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        this.create(cls);
        StringBuilder sql = new StringBuilder("select * from ").append(_table.getTable());
        List<T> list = this.zSQL.executeQuery(sql.toString(), cls);
        this.zCache.cache(cls, list);
    }

    @Override
    public void truncate(Class<?> cls) throws ORMException, SQLException {
        this.truncate(cls, (MapSS)new HashMapSS());
    }

    @Override
    public void truncate(Class<?> cls, String id) throws ORMException, SQLException {
        this.truncate(cls, (MapSS)new HashMapSS("id", id));
    }

    @Override
    public void truncate(Class<?> cls, MapSS replaceMap) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[truncate][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[truncate][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.zTabler.truncate(_table, replaceMap);
        if (this.server.isCache(cls)) {
            this.cache(cls);
        }
    }

    @Override
    public boolean exist(Class<?> cls) throws ORMException, SQLException {
        return this.exist(cls, (MapSS)new HashMapSS());
    }

    @Override
    public boolean exist(Class<?> cls, String id) throws ORMException, SQLException {
        return this.exist(cls, (MapSS)new HashMapSS("id", id));
    }

    @Override
    public boolean exist(Class<?> cls, MapSS replaceMap) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[exist][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[exist][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        return this.zTabler.exist(_table, replaceMap);
    }

    @Override
    public void create(Class<?> cls) throws ORMException, SQLException {
        this.create(cls, (MapSS)new HashMapSS());
    }

    @Override
    public void create(Class<?> cls, String id) throws ORMException, SQLException {
        this.create(cls, (MapSS)new HashMapSS("id", id));
    }

    @Override
    public void create(Class<?> cls, MapSS replaceMap) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[create][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[create][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.zTabler.create(_table, replaceMap);
    }

    @Override
    public void drop(Class<?> cls) throws ORMException, SQLException {
        this.drop(cls, (MapSS)new HashMapSS());
    }

    @Override
    public void drop(Class<?> cls, String id) throws ORMException, SQLException {
        this.drop(cls, (MapSS)new HashMapSS("id", id));
    }

    @Override
    public void drop(Class<?> cls, MapSS replaceMap) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[drop][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[drop][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.zTabler.drop(_table, replaceMap);
    }

    @Override
    public int insert(Object data) throws ORMException, SQLException {
        return this.insert(data, (MapSS)new HashMapSS());
    }

    @Override
    public int insert(Object data, MapSS replaceMap) throws ORMException, SQLException {
        Class<?> cls = data.getClass();
        _Table _table = this.getTable(data.getClass());
        if (_table == null) {
            throw new ORMException("ZTable[insert][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[insert][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.addReplaceToMap(data, replaceMap);
        this.create(cls, replaceMap);
        String sql = this.zTabler.toInsertOrReplaceSQL(_table, "insert");
        int ret = this.zSQL.executeUpdate(sql, data, replaceMap);
        if (ret > 0 && this.server.isCache(cls)) {
            this.cache(cls);
        }
        return ret;
    }

    @Override
    public int insertOrUpdate(Object data, Updater updater) throws ORMException, SQLException {
        Class<?> clazz = data.getClass();
        _Table _table = this.getTable(data.getClass());
        if (_table == null) {
            throw new ORMException("ZTable[insertOrUpdate][" + clazz.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (!this.server.isMysql()) {
            throw new ORMException("ZTable[insertOrUpdate]\u4e0d\u652f\u6301\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b]");
        }
        _table.addReplaceToMap(data, (MapSS)updater.getReplaceMap());
        this.create(clazz, (MapSS)updater.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String insertSQL = this.toInsertOrUpdateSQL(_table, data, (MapSO)paramMap);
        String updateSQL = this.zTabler.toUpdateFieldSQL(_table, updater, (MapSO)paramMap);
        StringBuilder sql = new StringBuilder(insertSQL).append(" on duplicate key update ").append(updateSQL);
        int ret = this.zSQL.executeUpdate(sql.toString(), paramMap, (MapSS)updater.getReplaceMap());
        if (ret > 0 && this.server.isCache(clazz)) {
            this.cache(clazz);
        }
        return ret;
    }

    @Override
    public int[] insertBatch(List<?> dataList) throws ORMException, SQLException {
        return this.insertBatch(dataList, (MapSS)new HashMapSS());
    }

    @Override
    public int[] insertBatch(List<?> dataList, MapSS replaceMap) throws ORMException, SQLException {
        if (dataList == null || dataList.isEmpty()) {
            return new int[0];
        }
        Class<?> cls = dataList.get(0).getClass();
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[insertBatch][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[insertBatch][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.addReplaceToMap(dataList.get(0), replaceMap);
        this.zTabler.create(_table, replaceMap);
        String sql = this.zTabler.toInsertOrReplaceSQL(_table, "insert");
        int[] rets = this.zSQL.executeBatch(sql, dataList, replaceMap);
        if (this.server.isCache(cls)) {
            this.cache(cls);
        }
        return rets;
    }

    @Override
    public int replace(Object data) throws ORMException, SQLException {
        return this.replace(data, (MapSS)new HashMapSS());
    }

    @Override
    public int replace(Object data, MapSS replaceMap) throws ORMException, SQLException {
        Class<?> clazz = data.getClass();
        _Table _table = this.getTable(clazz);
        if (_table == null) {
            throw new ORMException("ZTable[replace][" + clazz.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (!this.server.isMysql() && !this.server.isSqlite()) {
            throw new ORMException("ZTable[replace]\u4e0d\u652f\u6301\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[replace][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.addReplaceToMap(data, replaceMap);
        this.create(data.getClass(), replaceMap);
        String sql = this.zTabler.toInsertOrReplaceSQL(_table, "replace");
        int ret = this.zSQL.executeUpdate(sql, data, replaceMap);
        if (ret > 0 && this.server.isCache(clazz)) {
            this.cache(clazz);
        }
        return ret;
    }

    @Override
    public int[] replaceBatch(List<?> dataList) throws ORMException, SQLException {
        return this.replaceBatch(dataList, (MapSS)new HashMapSS());
    }

    @Override
    public int[] replaceBatch(List<?> dataList, MapSS replaceMap) throws ORMException, SQLException {
        if (dataList == null || dataList.isEmpty()) {
            return new int[0];
        }
        Class<?> clazz = dataList.get(0).getClass();
        String name = clazz.getName();
        _Table _table = this.getTable(clazz);
        if (_table == null) {
            throw new ORMException("ZTable[replaceBatch][" + name + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (!this.server.isMysql() && !this.server.isSqlite()) {
            throw new ORMException("ZTable[replaceBatch]\u4e0d\u652f\u6301\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[replaceBatch][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.addReplaceToMap(dataList.get(0), replaceMap);
        this.create(dataList.get(0).getClass(), replaceMap);
        String sql = this.zTabler.toInsertOrReplaceSQL(_table, "replace");
        int[] rets = this.zSQL.executeBatch(sql, dataList, replaceMap);
        if (this.server.isCache(clazz)) {
            this.cache(clazz);
        }
        return rets;
    }

    @Override
    public int update(Class<?> clazz, Updater updater) throws ORMException, SQLException {
        _Table _table = this.getTable(clazz);
        if (_table == null) {
            throw new ORMException("ZTable[update][" + clazz.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidUpdater(updater);
        if (result != null) {
            throw new ORMException("ZTable[update][" + clazz.getName() + "][\u66f4\u65b0\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        int ret = this.zTabler.update(_table, updater);
        if (ret > 0 && this.server.isCache(clazz)) {
            this.cache(clazz);
        }
        return ret;
    }

    @Override
    public int update(Object data) throws ORMException, SQLException {
        return this.update(data, (MapSS)new HashMapSS());
    }

    @Override
    public int update(Object data, MapSS replaceMap) throws ORMException, SQLException {
        Class<?> clazz = data.getClass();
        _Table _table = this.getTable(clazz);
        if (_table == null) {
            throw new ORMException("ZTable[update][" + clazz.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (_table.isAllKey()) {
            throw new ORMException("ZTable[update][" + clazz.getName() + "][\u6240\u6709\u5b57\u6bb5\u90fd\u662f\u5173\u952e\u5c5e\u6027,\u4e0d\u652f\u6301\u6b64\u66f4\u65b0\u65b9\u6cd5");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTable[update][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.addReplaceToMap(data, replaceMap);
        this.create(clazz, replaceMap);
        StringBuilder sql = new StringBuilder("update ").append(_table.getTable()).append(" set ");
        List<_TableField> fieldList = _table.getFieldListNoKey();
        _TableField field = fieldList.get(0);
        sql.append(field.getColumn()).append("=#").append(field.getColumn()).append("#");
        int i = 1;
        while (i < fieldList.size()) {
            field = fieldList.get(i);
            sql.append(", ").append(field.getColumn()).append("=#").append(field.getColumn()).append("#");
            ++i;
        }
        List<String> keyList = _table.getKeyList();
        StringBuilder where = new StringBuilder();
        where.append(" where ").append(keyList.get(0)).append("=#").append(keyList.get(0)).append("#");
        int i2 = 1;
        while (i2 < keyList.size()) {
            where.append(" and ").append(keyList.get(i2)).append("=#").append(keyList.get(i2)).append("#");
            ++i2;
        }
        sql.append((CharSequence)where);
        int ret = this.zSQL.executeUpdate(sql.toString(), data, replaceMap);
        if (ret > 0 && this.server.isCache(clazz)) {
            this.cache(clazz);
        }
        return ret;
    }

    @Override
    public int delete(Class<?> cls, Object ... ids) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[delete][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (!_table.isValidKeyObj(ids)) {
            throw new ORMException("ZTable[delete][" + cls.getName() + "][\u4f20\u5165\u4e3b\u952e\u503c\u7c7b\u578b\u548c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        int ret = this.zTabler.delete(_table, ids);
        if (ret > 0 && this.server.isCache(cls)) {
            this.cache(cls);
        }
        return ret;
    }

    @Override
    public int delete(Class<?> cls, Selector selector) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[delete][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidSelector(selector);
        if (result != null) {
            throw new ORMException("ZTable[delete][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        int ret = this.zTabler.delete(_table, selector);
        if (ret > 0 && this.server.isCache(cls)) {
            this.cache(cls);
        }
        return ret;
    }

    @Override
    public int count(Class<?> cls, Object ... ids) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[count][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (!_table.isValidKeyObj(ids)) {
            throw new ORMException("ZTable[count][" + cls.getName() + "][\u4f20\u5165\u4e3b\u952e\u503c\u548c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        return this.zTabler.count(_table, ids);
    }

    @Override
    public int count(Class<?> cls) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[count][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        return this.zTabler.count(_table);
    }

    @Override
    public int count(Class<?> cls, Selector selector) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[count][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidSelector(selector);
        if (result != null) {
            throw new ORMException("ZTable[count][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        return this.zTabler.count(_table, selector);
    }

    @Override
    public long sum(Class<?> cls, String field) throws ORMException, SQLException {
        return this.sum(cls, new Selector(), field);
    }

    @Override
    public long sum(Class<?> cls, Selector selector, String field) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[sum][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidSelector(selector);
        if (result != null) {
            throw new ORMException("ZTable[sum][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        return this.zTabler.sum(_table, selector, field);
    }

    @Override
    public long[] sum(Class<?> cls, Selector selector, String ... fields) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[sum][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidSelector(selector);
        if (result != null) {
            throw new ORMException("ZTable[sum][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        return this.zTabler.sum(_table, selector, fields);
    }

    @Override
    public <T> T item(Class<T> cls, Object ... ids) throws ORMException, SQLException {
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[item][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (!_table.isValidKeyObj(ids)) {
            throw new ORMException("ZTable[item][" + cls.getName() + "]\u4f20\u53c2\u4e0e\u4e3b\u952e\u8981\u6c42\u4e0d\u5339\u914d]");
        }
        this.create(cls);
        if (this.server.isCache(cls)) {
            return this.zCache.item(cls, ids);
        }
        StringBuilder sql = new StringBuilder("select * from ").append(_table.getTable());
        String[] keyArr = _table.getKeyArr();
        sql.append(" where ").append(keyArr[0]).append("=?");
        int i = 1;
        while (i < keyArr.length) {
            sql.append(" and ").append(keyArr[i]).append("=?");
            ++i;
        }
        List<T> list = this.zSQL.executeQuery(sql.toString(), cls, ids);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T> T item(Class<T> cls) throws ORMException, SQLException {
        return this.item(cls, new Selector());
    }

    @Override
    public <T> T item(Class<T> cls, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTable[item][selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[item][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String field = _table.isValidSelector(selector);
        if (field != null) {
            throw new ORMException("ZTable[item][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + field + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        this.create(cls, (MapSS)selector.getReplaceMap());
        if (this.server.isCache(cls)) {
            return this.zCache.item(cls, selector);
        }
        HashMapSO paramMap = new HashMapSO();
        String fieldSQL = selector.getFieldSQL(_table);
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_table);
        String groupbySQL = selector.getGroupbySQL(_table);
        String sql = this.server.getPolicy().toItemSQL(fieldSQL, _table.getTable(), whereSQL, orderbySQL, groupbySQL);
        List<T> list = this.zSQL.executeQuery(sql, cls, paramMap, (MapSS)selector.getReplaceMap());
        if (list.isEmpty()) {
            return null;
        }
        T item = list.get(0);
        _table.addReplaceToData(item, (MapSS)selector.getReplaceMap());
        return item;
    }

    @Override
    public <T> List<T> list(Class<T> cls) throws ORMException, SQLException {
        return this.list(cls, new Selector());
    }

    @Override
    public <T> List<T> list(Class<T> cls, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTable[list][Selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[list][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidSelector(selector);
        if (result != null) {
            throw new ORMException("ZTable[list][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        this.create(cls, (MapSS)selector.getReplaceMap());
        if (this.server.isCache(cls)) {
            return this.zCache.list(cls, selector);
        }
        HashMapSO paramMap = new HashMapSO();
        String fieldSQL = selector.getFieldSQL(_table);
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_table);
        String groupbySQL = selector.getGroupbySQL(_table);
        StringBuilder sql = new StringBuilder("select ").append(fieldSQL).append(" from ").append(_table.getTable()).append(whereSQL).append(orderbySQL).append(groupbySQL);
        List<T> list = this.zSQL.executeQuery(sql.toString(), cls, paramMap, (MapSS)selector.getReplaceMap());
        for (T item : list) {
            _table.addReplaceToData(item, (MapSS)selector.getReplaceMap());
        }
        return list;
    }

    @Override
    public <T> List<T> list(Class<T> cls, int pageNo, int pageSize) throws ORMException, SQLException {
        return this.list(cls, pageNo, pageSize, new Selector());
    }

    @Override
    public <T> List<T> list(Class<T> cls, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTable[list][Selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[list][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidSelector(selector);
        if (result != null) {
            throw new ORMException("ZTable[list][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        this.create(cls, (MapSS)selector.getReplaceMap());
        if (this.server.isCache(cls)) {
            return this.zCache.list(cls, pageNo, pageSize, selector);
        }
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        return this.list(cls, _table, pageNo, pageSize, selector);
    }

    @Override
    public <T> PageResult<T> page(Class<T> cls, int pageNo, int pageSize) throws ORMException, SQLException {
        return this.page(cls, pageNo, pageSize, new Selector());
    }

    @Override
    public <T> PageResult<T> page(Class<T> cls, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        int totalRecord;
        if (selector == null) {
            throw new ORMException("ZTable[page][selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _Table _table = this.getTable(cls);
        if (_table == null) {
            throw new ORMException("ZTable[page][" + cls.getName() + "][\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String result = _table.isValidSelector(selector);
        if (result != null) {
            throw new ORMException("ZTable[page][" + cls.getName() + "][\u67e5\u8be2\u5668\u5b57\u6bb5[" + result + "]\u7c7b\u578b\u548c\u503c\u8981\u6c42\u4e0d\u4e00\u81f4]");
        }
        this.create(cls, (MapSS)selector.getReplaceMap());
        if (this.server.isCache(cls)) {
            return this.zCache.page(cls, pageNo, pageSize, selector);
        }
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        if ((totalRecord = this.count(cls, selector)) == 0) {
            return PageBuilder.newResult((int)pageNo, (int)pageSize);
        }
        int maxPage = (totalRecord - 1) / pageSize + 1;
        if (pageNo > maxPage) {
            pageNo = maxPage;
        }
        List<T> resultSet = this.list(cls, _table, pageNo, pageSize, selector);
        return PageBuilder.newResult((int)totalRecord, (int)pageNo, (int)pageSize, resultSet);
    }

    private String toInsertOrUpdateSQL(_Table _table, Object data, MapSO paramMap) throws ORMException {
        Class<?> clazz = data.getClass();
        Dbo dbo = this.server.getDbo(clazz);
        StringBuilder sql = new StringBuilder("insert into ").append(_table.getTable()).append("(");
        StringBuilder values = new StringBuilder("values (");
        List<_TableField> fieldList = _table.getFieldList();
        for (_TableField field : fieldList) {
            String fieldName = field.getField();
            String method = dbo.getGetMethod(fieldName);
            if (method == null) {
                throw new ORMException("_Table/_View/_Dbo[" + clazz.getName() + "]\u6ca1\u6709\u627e\u5230" + fieldName + "\u5bf9\u5e94\u7684\u65b9\u6cd5]");
            }
            try {
                Method m = clazz.getMethod(method, new Class[0]);
                Object value = m.invoke(data, new Object[0]);
                paramMap.put(fieldName, value);
                sql.append(field.getColumn()).append(",");
                values.append("#").append(fieldName).append("#").append(",");
            }
            catch (Exception e) {
                throw new ORMException(e);
            }
        }
        sql.setLength(sql.length() - 1);
        values.setLength(values.length() - 1);
        sql.append(") ").append((CharSequence)values).append(")");
        return sql.toString();
    }

    private <T> List<T> list(Class<T> clazz, _Table _table, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        int minNum = (pageNo - 1) * pageSize + 1;
        int maxNum = pageNo * pageSize;
        HashMapSO paramMap = new HashMapSO();
        paramMap.put("minNum", (Object)minNum);
        paramMap.put("maxNum", (Object)maxNum);
        paramMap.put("minSize", (Object)(minNum - 1));
        paramMap.put("pageSize", (Object)pageSize);
        String fieldSQL = selector.getFieldSQL(_table);
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_table);
        String groupbySQL = selector.getGroupbySQL(_table);
        String sql = this.server.getPolicy().toPageSQL(fieldSQL, _table.getTable(), whereSQL, orderbySQL, groupbySQL, maxNum, pageNo);
        List<T> list = this.zSQL.executeQuery(sql, clazz, paramMap, (MapSS)selector.getReplaceMap());
        for (T item : list) {
            _table.addReplaceToData(item, (MapSS)selector.getReplaceMap());
        }
        return list;
    }
}

