/****************************************
**************** 快捷键  ****************
*****************************************/

Z.onload(function(){

Z(document).keydown(function(event)
{

var code = "" + event.keyCode;                      //按键键值, 字符串型
var isCtrl = event.ctrlKey;                         //是否按下Ctrl
var isShift = event.shiftKey;                       //是否按下Shift
var isAlt = event.altKey;                           //是否按下Alt

/******** keydown事件开始 ******/
//输入内容操作，搜索输入框执行搜索，其他不处理
if (isActiveInput()){
    //输入框内容，分情况执行特殊处理
    var activeEle = document.activeElement;
    //没有按下辅助键
    if (!isCtrl && !isShift && !isShift) {
        if (code === "13")
        {//单独按下回车键
            if (activeEle.tagName.toLowerCase() !== "input") return;
            switch (activeEle.id) {
            case "q":                           //搜索框回车执行
                doClearQueryMaterial();         //清空
                doQueryMaterial();
                break;
            case "fontSize_input":              //文字大小修改
                //Z("#fontSize_input").addClass("invisible").blur();
                Z("#fontSize_input").blur();
                break;
            }
        }
    }
    return;
}

var selectedList = media.selectedList;              //当前选中列表

/* 空格键按下标识 */
//   1):用于标识画布是否可移动
if (code === "32"){
    Z(media.tool.$svgCover).show();
    return;
}

// 参数定义
var firstMid, firstMaterial, i, $curElem, x, y;

/****************************************
************** 全局组合操作 **************
*****************************************/
//   1):=====任何状态都可以进行操作，以下为已实现的操作=====
//   2):全选素材（Ctrl + A [ctrlKey + 65]）
//   3):重做操作（Ctrl + Y [ctrlKey + 89]）
//   4):撤销操作（Ctrl + Z [ctrlKey + 90]）
//   5):移动画布（Space + mousedown + mousemove[32 + mousedown + mousemove]），鼠标事件在 wrapMouseMove 中处理
//   6):多选素材（Shift + mousedown[shiftKey + mousedown]），鼠标事件在 eleMouseDown 中处理
//   7):跨模板粘贴素材（Ctrl + Alt + V [ctrlKey + altKey + 86]）
//   8):全素材锁定（Ctrl + Alt + L [ctrlKey + altKey + 76]）
//   9):全素材解锁（Ctrl + Alt + U [ctrlKey + altKey + 85]）
var globalEditKey = ["65", "89", "90"];
// 全选、重做、撤销
if (Z.AR.contains(globalEditKey, code))
{
    if (!isCtrl || isShift || isAlt)
        return;
    switch (code)
    {
    case "65"://全选，仅限正常素材
        Z.E.forbidden(event);
        doGlobalSelect();
        break;
    case "89"://重做
        redo();
        break;
    case "90"://撤销
        revoke();
        break;
    }
    return;
}
// 多选
if (isShift){
    Z("#selection_tool").css("pointer-events","none");
}

// Ctrl + Alt + ...
if (isCtrl && isAlt && !isShift)
{
    globalEditKey = ["86", "76", "85"];
    if (Z.AR.contains(globalEditKey, code))
    {
        switch (code)
        {
            case "86"://跨模板粘贴素材
                pasteOverPage();
                break;
            case "76"://全素材锁定
                doGlobalLock();
                break;
            case "85"://全素材解锁
                doGlobalUnlock();
                break;
        }
        return;
    }
}

/****************************************
************** 素材操作类型 **************
*****************************************/
//   1):=====需要存在选中对象，以下为已实现的操作=====
//   2):移动素材（left [37]、up [38]、right [39]、down [40]）
//   3):删除素材（Del [46]）
//   4):剪切操作（Ctrl + X [ctrlKey + 88]）
//   5.1):下移图层（Crtl + [ [ctrlKey + 219]）
//   5.2):上移图层（Crtl + ] [ctrlKey + 221]）
//   5.3):置底图层（Crtl + Shift + [ [ctrlKey + shiftKey + 219]）
//   5.4):置顶图层（Crtl + Shift + ] [ctrlKey + shiftKey + 221]）
//   5.5):跨模板复制素材（Ctrl + Shift + C [ctrlKey + shiftKey + 67]）

var materialEditKey = ["37", "38", "39", "40", "46", "88", "219", "221"]
if (Z.AR.contains(materialEditKey, code))
{//存在于素材操作类型
    if (selectedList.length === 0 || isAlt){
        return;
    }
    //取第一个素材，判断是否可编辑
    firstMid = selectedList[0];
    firstMaterial = media.getMaterialByMid(firstMid);
    if (parseFloat(firstMaterial.status) !== 0) {
        return;
    }
    
    switch (code)
    {
    case "37"://左移
        if (isCtrl || isShift || isAlt)
            break;
        for (i = 0;i < selectedList.length;i++){
            $curElem = media.tool.getCurSvgElement(i);
            x = $curElem.transform.baseVal[0].matrix.e;
            y = $curElem.transform.baseVal[0].matrix.f;
            updateMaterialPos(x - 1, y, i);
        }
        Z("#selection_tool").css({
            "left": parseFloat(Z("#selection_tool").css("left")) - media.tool.showRatio,
            "top": parseFloat(Z("#selection_tool").css("top"))
        });
        break;
    case "38"://上移
        if (isCtrl || isShift || isAlt)
            break;
        for (i = 0;i < selectedList.length;i++){
            $curElem = media.tool.getCurSvgElement(i);
            x = $curElem.transform.baseVal[0].matrix.e;
            y = $curElem.transform.baseVal[0].matrix.f;
            updateMaterialPos(x, y - 1, i);
        }
        Z("#selection_tool").css({
            "left": parseFloat(Z("#selection_tool").css("left")),
            "top": parseFloat(Z("#selection_tool").css("top")) - media.tool.showRatio
        });
        break;
    case "39"://右移
        if (isCtrl || isShift || isAlt)
            break;
        for (i = 0;i < selectedList.length;i++) {
            $curElem = media.tool.getCurSvgElement(i);
            x = $curElem.transform.baseVal[0].matrix.e;
            y = $curElem.transform.baseVal[0].matrix.f;
            updateMaterialPos(x + 1, y, i);
        }
        Z("#selection_tool").css({
            "left": parseFloat(Z("#selection_tool").css("left")) + media.tool.showRatio,
            "top": parseFloat(Z("#selection_tool").css("top"))
        });
        break;
    case "40"://下移
        if (isCtrl || isShift || isAlt)
            break;
        for (i = 0;i < selectedList.length;i++) {
            $curElem = media.tool.getCurSvgElement(i);
            x = $curElem.transform.baseVal[0].matrix.e;
            y = $curElem.transform.baseVal[0].matrix.f;
            updateMaterialPos(x, y + 1, i);
        }
        Z("#selection_tool").css({
            "left": parseFloat(Z("#selection_tool").css("left")),
            "top": parseFloat(Z("#selection_tool").css("top")) + media.tool.showRatio
        });
        break;
    case "46"://删除
        if (isCtrl || isShift || isAlt)
            break;
        deleteMaterial();
        break;
    case "88"://剪切
        if (!isCtrl || isShift || isAlt)
            break;
        copyMaterialData();
        deleteMaterial();
        break;
    case "219":
        if (!isCtrl || isAlt)
            break;
        if (isShift)        //置底图层
            topMaterial();
        else                //下移图层
            upMaterial();
        break;
    case "221":
        if (!isCtrl || isAlt)
            break;
        if (isShift)        //置顶图层
            bottomMaterial();
        else                //上移图层
            downMaterial();
        break;
    }
    if (!Z.AR.contains(["37", "38", "39", "40"], code)) {
        saveHistory();
    }
    return;
}
if (code === "67" && isCtrl && isAlt && !isShift) {      //跨模板复制素材
    copyOverPage();
    return;
}


/****************************************
************** 素材对齐操作 **************
****** 分为素材组对齐/单个画布对齐 ********
*****************************************/
//   1):=====仅当有选时才能操作，以下为已实现的操作=====
//   2):左对齐（L [76]）
//   3):右对齐（R [82]）
//   4):顶对齐（T [84]）
//   5):底对齐（B [66]）
//   6):水平居中对齐（C [67]）
//   7):垂直居中对齐（E [69]）
//   8):水平均匀分布（）
//   9):垂直均与分布（）
var materialGroupEditKey = ["76", "82", "84", "66", "67", "69"]
if (Z.AR.contains(materialGroupEditKey, code))
{//存在于素材操作类型
    if (selectedList.length < 1 || isCtrl || isShift || isAlt){
        return;
    }
    // 执行单个素材的对齐
    if (selectedList.length === 1)
    {
        var theCurMaterial = media.tool.tempMaterial || media.getCurMaterial();
        if (!theCurMaterial || parseFloat(theCurMaterial.status) !== 0)
            return;
        var type = '';
        switch (code)
        {
            case "76":// 左对齐
                type = "left"; break;
            case "82":// 右对齐
                type = "right"; break;
            case "84":// 顶对齐
                type = "top"; break;
            case "66":// 底对齐
                type = "bottom"; break;
            case "67":// 水平居中对齐
                type = "center"; break;
            case "69":// 垂直居中对齐
                type = "middle"; break;
        }
        if (type)
        {
            doSetMaterialPos(type);
            saveHistory();
        }
        return;
    }
    
    //取第一个素材，判断是否可编辑
    firstMid = selectedList[0];
    firstMaterial = media.getMaterialByMid(firstMid);
    if (parseFloat(firstMaterial.status) !== 0)
        return;
    // 执行多素材的对齐
    switch (code)
    {
        case "76"://左对齐
            alignLocation("left");
            break;
        case "82"://右对齐
            alignLocation("left_right");
            break;
        case "84"://顶对齐
            alignLocation("top");
            break;
        case "66"://底对齐
            alignLocation("top_bottom");
            break;
        case "67"://水平居中对齐
            alignByaxis("center");
            break;
        case "69"://垂直居中对齐
            alignByaxis("middle");
            break;
    }
    saveHistory();
}

/******** keydown事件结束 ******/
});


Z(document).keyup(function(event)
{
/******** keyup事件开始 ******/
var code = "" + event.keyCode;                      //按键键值, 字符串型
var isCtrl = event.ctrlKey;                         //是否按下Ctrl
var isShift = event.shiftKey;                       //是否按下Shift
var isAlt = event.altKey;                           //是否按下Alt

var selectedList = media.selectedList;              //当前选中列表

/* 空格键松开标识 */
if (code === "32"){
    Z(media.tool.$svgCover).hide();
}
/* shift松开标识 */
if (code === "16"){
    Z("#selection_tool").css("pointer-events","auto");
}

//上下左右 素材操作完，进行保存
var materialEditKey = ["37", "38", "39", "40"];
if (Z.AR.contains(materialEditKey, code)) {
    if (selectedList.length === 0) { return;}
    if (isCtrl || isShift || isAlt) { return;}
    if (isActiveInput()) { return;}
    saveHistory();
}


/******** keyup事件结束 ******/
});


/****************************************
**************** 轮滑缩放  ***************
*****************************************/
Z("#stage_design").on("mousewheel DOMMouseScroll", function(event)
{
    // 特殊情况，返回
    var $tableCover = Z.D.id("tableEditorCover");
    var tableCoverCN = $tableCover.className;
    if (tableCoverCN && tableCoverCN.indexOf("tableEditing") > -1)
        return;

    var mouseLoc = {x: event.pageX, y: event.pageY};
    var eventType = event.type;
    var wheelType;
    //event.type = "DOMMouseScroll"     //火狐
    //event.type = "wheel"              //谷歌
    //event.type = "mousewheel"         //IE、Edge
    if (eventType === "DOMMouseScroll") {
        wheelType = (event.detail < 0) ? "up":"down";
    } else if (eventType === "wheel" || eventType === "mousewheel") {
        wheelType = (event.wheelDelta > 0) ? "up":"down";
    } else {
        return;
    }
    // 去除编辑工具
    mediaEvent.removeAllEditTool();
    // 去除文字编辑状态
    if (Z.D.id('textEditorWrap').getAttribute('style'))
    {
        if (media.selectedList.length === 1)
            showTextElement(media.tool.getCurSvgElement());
        else
            hideTextEditor();
    }

    // 鼠标位置，相对画布的比例
    var canvasRect = media.tool.$stageCanvas.getBoundingClientRect();
    var leftRatio = (mouseLoc.x - canvasRect.left) / canvasRect.width;
    var topRatio = (mouseLoc.y - canvasRect.top) / canvasRect.height;
    leftRatio = (leftRatio >= 0)?(leftRatio):(0);
    topRatio = (topRatio >= 0)?(topRatio):(0);
    
    // 缩放操作
    var nowRatio = parseInt(Z(".zoombtn>.zoom-text").text());
    var setRatio = nowRatio;
    var maxRatio = 500;
    // 放大操作
    if (wheelType === "up")
    {
        if (nowRatio >= 0 && nowRatio < maxRatio){
            setRatio = Math.round(nowRatio / 10) * 10;
            setRatio = (setRatio <= nowRatio)?(setRatio + 5):(setRatio);
        } else{
            setRatio = maxRatio;
        }
    }
    // 缩小操作
    else if (wheelType === "down")
    {
        if (nowRatio > 5 && nowRatio <= maxRatio){
            setRatio = Math.ceil(nowRatio/10)*10 - 5;
            setRatio = (setRatio >= nowRatio)?(setRatio - 5):(setRatio);
        } else{
            setRatio = 5;
        }
    }
    // 执行缩放操作
    media.tool.setRatioCanvas(setRatio/100);
    
    // 重新获取画布rect，计算偏移位置
    canvasRect = media.tool.$stageCanvas.getBoundingClientRect();
    var designRect = media.tool.$designStage.getBoundingClientRect();
    var setLeft = mouseLoc.x - leftRatio * canvasRect.width - designRect.left;
    var setTop = mouseLoc.y - topRatio * canvasRect.height - designRect.top;
    media.tool.$stageCanvas.style.left = setLeft + "px";
    media.tool.$stageCanvas.style.top = setTop + "px";
    
    // 选择框定位
    setAllToolLoc();
});


/****************************************
**************** 复制粘贴  ***************
*****************************************/

var types = ['text/html', 'text/plain'];

Z(document).on("copy",function(clipboardEvent)
{//复制：Ctrl + C
    function clearClipboardItem()
    {// 清空粘贴板内容
        for (var i = 0;i < types.length;i++) {
            clipboardEvent.clipboardData.setData(types[i], '');
        }
    }

    if (isActiveInput())
    {//输入内容操作，不处理
        return;
    }
    if (media.selectedList.length > 0)
    {//当前有选中素材时，执行素材复制
        Z.E.forbidden(clipboardEvent);
        copyMaterialData();
        clearClipboardItem(clipboardEvent);
    }
    else
        media.tool.tempMetabolic = null;
});
Z(document).on("paste",function(clipboardEvent)
{//粘贴：Ctrl + V//输入内容操作，不处理
    function hasClipboardItem()
    {// 判断粘贴板是否存在内容
        // 1：剪切板没内容，直接返回
        var items = clipboardEvent.clipboardData.items;
        if (items.length === 0){
            clipboardEvent.clipboardData.allTypes = types;
            return false;
        }
        // 2：依据 types 循环获取判断
        for (var i = 0;i < types.length;i++) {
            if (clipboardEvent.clipboardData.getData(types[i])) {
                return true;
            }
        }
        return false;
    }

    if (isActiveInput())
    {//输入内容操作，不处理
        return;
    }
    if (Z("#imgFrameEditor")[0].hasAttribute("style"))
    {//存在容器操作，不处理
        return;
    }
    // 优先判断是否存在粘贴版内容，截取信息，添加内容
    if (clipboardEvent.clipboardData && hasClipboardItem())
    {
        var $focusDiv = Z('<div id="' + Z.Ids.uuid() + '" contenteditable=true></div>');
        $focusDiv.appendTo(Z(document)).css("position","absolute").css("opacity",0);
        $focusDiv.focus();
        // 延时，获取编辑div中的内容
        var timer = setTimeout(function()
        {
            var imgsList = $focusDiv[0].querySelectorAll("img");
            var cText = Z.S.trim( $focusDiv.text());               //获取剪切内容，并去除左右空格
            cText = cText.replace(/\n/g,"-%5-%-%5-");              //保留换行
            cText = cText.replace(/\s/g," ");                      //替换空格
            cText = cText.replace(/-%5-%-%5-/g,"\n");              //保留换行
            // 无内容，清空并返回
            if (!cText && imgsList.length === 0)
            {
                setTimeout(function(){Z.Dialog.close()},500);
                clearTimeout(timer);
                $focusDiv.remove();
                return;
            }
            // 清空选中列表
            media.clearSelected();
            var preLength = media.getBgMaterialList(media.curPage).length;
            media.tool.ajaxLoadedLength = preLength + imgsList.length;
            // 存在字符串数据，进行添加文字
            if (Z.V.isNotEmpty(cText))
            {
                var textMid = preLength;
                preLength++;
                media.tool.ajaxLoadedLength++;
                addNewTextOther(cText, textMid);
            }
            // 存在图片数据时
            if (imgsList.length > 0)
            {
                var i, srcStr;
                for (i = 0;i < imgsList.length;i++){
                    srcStr = imgsList[i].getAttribute("src");
                    uploadFileRequest(srcStr, preLength + i);
                }
            }
            // 清除临时变量
            clearTimeout(timer);
            $focusDiv.remove();
        },100);
    }
    // 临时素材存在，则粘贴该素材
    else if (media.tool.tempMetabolic && media.tool.tempMetabolic.length > 0)
    {
        copyMaterial(media.tool.tempMetabolic);
    }
});



});

