;(function(Z)
{
//BEGIN

/********************************************
**************** 画布 Z.Canvas **************
********************************************/
Z.Canvas = Z.Class.newInstance();
Z.Canvas.prototype = 
{
    defaults:
    {
        mediaId: null,
        mediaName: null,
        baseWidthMm: 0,
        baseHeightMm: 0,
        fullWidth: 0,
        fullHeight: 0,
        fullWidthMm:0,
        fullHeightMm:0,
        width: 0,
        height: 0,
        widthMm:0,
        heightMm:0,
        dpi: 0,
        oddEven:0,
        mediaUrl: null,
        createTime: null,
        updateTime: null,
        editTime: null,
        fullShow: 1,
    },

    init:function()
    {
        
    },
    
    getRatio: function()
    {// 获取画布宽高比
        return this.width/this.height;
    }
};

/********************************************
****************** 背景 Z.Bg ****************
********************************************/
Z.Bg = Z.Class.newInstance();   //背景定义
Z.Bg.prototype = 
{
    defaults:
    {
        mediaId: null,
        bid: 0,
        pos: 0,
        fileId: null,
        oddEven:0,
        source: null,
        bgUrl: null,
        bgMinUrl: null,
        width: 0,
        height: 0,
        widthMm:0,
        heightMm:0,
    },

    init:function()
    {
        
    }

};

/********************************************
*************** 素材 Z.Material *************
********************************************/
Z.Material = Z.Class.newInstance();
Z.Material.prototype = 
{
    defaults:
    {
        $media: null,
        mediaId: null,               //1.媒体编号
        bid: 0,                      //2.背景编号
        mid: 0,                      //3.素材编号
        pos: 0,                      //4.素材位置
        type: 0,                     //5.素材类型，0表示图片，1表示文字，2表示二维码，3表示普通素材，4容器，，5形状
        status: 0,                   //6.素材状态, 0表示正常, 1表示已删除, 2表示已隐藏, 3表示已锁定
        fileId: null,               //7.文件编号ID
        source: null,               //8.素材内容
        paramKey: null,             //9.参数键值，用于模板中的${}
        paramName: null,            //10.参数名
        selected: false,            //11.选中标识
        
        color: "#000000",            //12.字体颜色
        fontSize: 0,                 //13.字体大小
        fontFamily: "",              //14.字体类型
        text: "",                    //15.文本内容
        underlineOffset: 0,          //16.下划线偏移
        underlineThickness: 0,       //17.下划线大小
        letterSpacing: 0,            //18.字间距
        lineHeight: 0,               //19.行距，显示结果
        mathHeight: 0,               //20.用于计算的行距
        singleHeight: 0,             //21.文本单行高度
        fontWeight: 0,               //22.是否是粗体
        textZoom: "1 1",             //23.文字缩放比例
        wordsList: null,            //24.所有文字的样式
        textAlign: 'left',           //25.文字对齐
        textVertical: 'normal',      //26.竖排文字
        textSpecial: "normal",       //27.文字特殊样式
        textSpecialColor: "#000000", //28.文字特殊样式，颜色
        textSpecialSize: -1,         //29.文字特殊样式，大小；< 0 表示无效

        transparency: 100,           //30.透明度
        imgRadius: 0,                //31.图片圆角
        reversal: "1 1",             //32.素材翻转
        groupId: "",                 //33.群组ID
        bgMaterial: false,          //34.是否是背景素材
    },
    
    init: function()
    {
        
    },
    
    doSelected: function()
    {
        this.$media.doSelected(this.bid, this.mid);
    },
    
    doMutliSelected: function()
    {
        this.$media.doMutliSelected(this.bid, this.mid);
    },
    
    unSelected: function()
    {
        this.$media.unSelected(this.bid, this.mid);
    },
    
    doUp: function()
    {
        this.$media.doUp(this.bid, this.pos);
    },
    
    doDown: function()
    {
        this.$media.doDown(this.bid, this.pos);
    },
    
    doLock: function()
    {
        this.$media.doLock(this.mid);
    },
    
    unLock: function()
    {
        this.$media.unLock(this.mid);
    },
    
    doDelete: function()
    {
        this.$media.doDelete(this.mid);
    }
};

/********************************************
 ********* 遮罩素材 Z.CoverMaterial *********
 ********************************************/
Z.CoverMaterial = Z.Class.newInstance();   //遮罩素材
Z.CoverMaterial.prototype =
{
    defaults:
    {
        mediaId: null,               // 1.媒体编号
        bid: 0,                       // 2.背景编号
        mid: 0,                       // 3.素材编号
        source: null,                // 4.素材内容
    },

    init:function()
    {

    }
};

/********************************************
***************** 媒体 Z.Media **************
********************************************/
Z.Media = Z.Class.newInstance();    //媒体定义
Z.Media.prototype =
{
    defaults:
    {
        canvas: null,            //画布类
        bgList: null,            //背景类
        materialList: null,      //素材类
        coverMaterialList: null, //遮罩素材类
        curPage: 0,              //当前版面
        selectedList: []         //默认选中素材列表: length=0未选中, length=1单选, length>1多选
    },
    init: function()
    {
        //工具类定义
        this.tool = new Z.MediaTool();
        this.tool.$media = this;
        
        //画布定义为 Z.Canvas 类
        var tempCanvas = new Z.Canvas();
        var i, item;
        for(item in this.canvas){
            tempCanvas[item] = this.canvas[item];
        }
        this.canvas = tempCanvas;
        this.canvas.$media = this;
        
        //背景定义为 Z.BgList 类
        var tempBgList = [];
        var bgLength = this.bgList.length;
        for (i = 0;i < bgLength;i++)
        {
            tempBgList[i] = new Z.Bg();
            tempBgList[i].$media = this;
            
            for(item in this.bgList[i]){
                tempBgList[i][item] = this.bgList[i][item];
            }
            
            this.initBgSize(tempBgList[i]);
        }
        this.bgList = tempBgList;
        
        //素材定义为 Z.Material 类
        var tempMaterialList = [];
        var mtLength = this.materialList.length;
        for (i = 0;i < mtLength;i++)
        {
            tempMaterialList[i] = new Z.Material();
            tempMaterialList[i].$media = this;
            for(item in this.materialList[i]){
                tempMaterialList[i][item] = this.materialList[i][item];
            }
        }
        this.materialList = tempMaterialList;

    },
    initBgSize:function(bg)
    {
        if(bg.oddEven === 0)
        {//横版
            bg.width = this.canvas.width;
            bg.height = this.canvas.height;
            bg.widthMm = this.canvas.widthMm;
            bg.heightMm = this.canvas.heightMm;
        }
        else
        {//竖版
            bg.width = this.canvas.height;
            bg.height = this.canvas.width;
            bg.widthMm = this.canvas.heightMm;
            bg.heightMm = this.canvas.widthMm;
        }
    },
    getCurBg: function ()
    {// 获取当前背景
        return this.getBg(this.curPage);
    },
    getBg: function (bid)
    {// 获取指定背景
        var i, bgLength = this.bgList.length;
        for (i=0; i<bgLength; i++) {
            if (this.bgList[i].bid === bid) {
                return this.bgList[i];
            }
        }
    },
    getBgIndex: function (bid)
    {// 获取指定背景索引
        var i, bgLength = this.bgList.length;
        for (i=0; i<bgLength; i++) {
            if (this.bgList[i].bid === bid) {
                return i;
            }
        }
    },
    getPageRatio: function()
    {// 获取版面宽高比
        return this.getCurBg().width/this.getCurBg().height;
    },
    getBgMaterialList: function (bid)
    {// 获取指定背景素材列表
        var bgMaterialList = [];
        for (var i=0; i<this.materialList.length; i++) {
            if (this.materialList[i].bid == bid) {
                bgMaterialList.push(this.materialList[i]);
            }
        }
        
        return bgMaterialList;
    },
    setCurPage: function(page)
    {// 设置当前版面
        if (this.curPage == page)
            return;

        this.curPage = page;
        this.unSelected();
    },
    
    getCurPage: function()
    {// 获取当前版面
        return this.curPage;
    },
    getMaterial: function(bid, pos)
    {
        var $material = null;
        for (var i=0; i<this.materialList.length; i++)
        {
            if (this.materialList[i].bid == bid && this.materialList[i].pos == pos)
            {
                $material = this.materialList[i];
                break;
            }
        }
        
        return $material;
    },
    getCurMaterial: function(index)
    {
        var $material = null;
        var ind = 0;
        if (!Z.T.isUndefined(index)) {
            ind = index;
        }
        for (var i=0; i<this.materialList.length; i++)
        {
            if (this.materialList[i].bid == this.curPage && this.materialList[i].mid == this.selectedList[ind])
            {
                $material = this.materialList[i];
                break;
            }
        }
        
        return $material;
    },
    
    getMaterialByMid: function(mid, bid)
    {
        mid = parseInt(mid);
        if (bid === undefined)
            bid = this.curPage;
        bid = parseInt(bid);
        var $material = null;
        for (var i=0; i<this.materialList.length; i++)
        {
            if (this.materialList[i].bid == bid && this.materialList[i].mid == mid)
            {
                $material = this.materialList[i];
                break;
            }
        }
        return $material;
    },
    
    getMaterialsByGroupId: function(groupId)
    {
        var $$material = [];
        var bid = this.curPage;
        for (var i=0; i<this.materialList.length; i++)
        {
            var theMaterial = this.materialList[i];
            if (theMaterial.bid == bid && theMaterial.groupId == groupId) {
                $$material.push(theMaterial.mid);
            }
        }
        return $$material;
    },
    
    addMaterial: function(m)
    {
        var index = 0;
        for (var i=0; i<this.materialList.length; i++) {
            if (this.materialList[i].bid < m.bid){
                index++;
                continue;
            }
            if (this.materialList[i].bid == m.bid){
                if (this.materialList[i].pos <= m.pos) {
                    index++;
                } else {
                    break;
                }
            }
        }
        this.materialList.splice(index, 0, m);
    },
    
    doUp: function(bid, pos)
    {
        if (pos <= 0) {
            return false;
        }
        
        var $material1;
        var $material2;
        for (var i=0; i<this.materialList.length; i++) {
            if (this.materialList[i].bid != bid) {
                continue;
            }

            var $material = this.materialList[i];
            if ($material && $material.pos == pos-1) {
                $material.pos = pos;
                $material1 = $material;
                continue;
            }
            
            if ($material && $material.pos == pos) {
                $material.pos = pos-1;
                $material2 = $material;
            }
        }
        
        this.doChange($material1, $material2);
        return true;
    },
    
    doDown: function(bid, pos)
    {//位置pos下移
        if (pos >= this.getBgMaterialList(bid).length-1) {
            return false;
        }
        
        var $material1;
        var $material2;
        for (var i=0; i<this.materialList.length; i++) {
            if (this.materialList[i].bid != bid) {
                continue;
            }
            
            var $material = this.materialList[i];
            if ($material && $material.pos == pos) {
                $material.pos = pos+1;
                $material1 = $material;
                continue;
            }
            
            if ($material && $material.pos == pos+1) {
                $material.pos = pos;
                $material2 = $material;
            }
        }
        
        this.doChange($material1, $material2);
        return true;
    },
    
    doChange: function($material1, $material2)
    {//交换位置
        var $matClone1 = Z.clone($material1);
        var $matClone2 = Z.clone($material2);
        var pos1 = this.materialList.indexOf($material1);
        var pos2 = this.materialList.indexOf($material2);

        this.materialList[pos2] = $matClone1;
        this.materialList[pos1] = $matClone2;
    },
    
    doSelected: function(bid, mid)
    {// 选择单个素材
        for (var i=0; i<this.materialList.length; i++)
        {
            if (this.materialList[i] && this.materialList[i].bid == bid && this.materialList[i].mid == mid)
                this.materialList[i].selected = true;
            else
                this.materialList[i].selected = false;
        }
        
        this.selectedList = [mid];
    },
    
    doSelectedAll: function()
    {// 选择所有素材
        this.clearSelected();
        for (var i=0; i<this.materialList.length; i++)
        {
            if (this.materialList[i].bid != this.curPage)
                continue;
                
            if (this.materialList[i].status == 0){
                this.materialList[i].selected = true;
                this.selectedList.push(this.materialList[i].mid);
            }
            else
                this.materialList[i].selected = false;
        }
    },
    
    doMutliSelected: function(bid, mid)
    {// 选择多个素材
        for (var i=0; i<this.materialList.length; i++)
        {
            if (this.materialList[i] && this.materialList[i].bid == bid && this.materialList[i].mid == mid) {
                this.materialList[i].selected = true;
            }
        }
        
        if (this.selectedList.indexOf(mid) == -1) {
            this.selectedList.push(mid);
        }
    },
    
    unSelected: function(bid, mid)
    {// 取消素材选择
        for (var i = 0; i < this.materialList.length; i++)
        {
            if (this.materialList[i] && this.materialList[i].bid == bid && this.materialList[i].mid == mid) {
                this.materialList[i].selected = false;
            }
        }
        for (var j = 0; j < this.selectedList.length; j++) {
            if (this.selectedList[j] == mid) {
                this.selectedList.splice(j, 1);
            }
        }
    },
    
    clearSelected: function()
    {// 取消所有素材选择
        for (var i=0; i<this.materialList.length; i++)
        {
            this.materialList[i].selected = false;
        }
        
        this.selectedList = [];
    },
    
    doLock: function(mid)
    {
        for (var i=0; i<this.materialList.length; i++) {
            if (this.materialList[i].bid == this.curPage && this.materialList[i].mid == mid) {
                this.materialList[i].status = 3;
                break;
            }
        }
    },
    
    unLock: function(mid)
    {
        for (var i=0; i<this.materialList.length; i++) {
            if (this.materialList[i].bid == this.curPage && this.materialList[i].mid == mid) {
                this.materialList[i].status = 0;
                break;
            }
        }
    },
    
    doDelete: function(mid)
    {//删除mid素材
        for (var i=0; i<this.materialList.length; i++) {
            if (this.materialList[i].bid == this.curPage && this.materialList[i].mid == mid) {
                this.materialList[i].status = 1;
                break;
            }
        }
        this.unSelected(this.curPage,mid);
    },
    
    toString: function()
    {//转换字符串保存
        var i = 0;
        var _canvas =
        {
            mediaId: this.canvas.mediaId,
            mediaName: this.canvas.mediaName,
            status: this.canvas.status,
            mediaType: this.canvas.mediaType,
            isEdit: this.canvas.isEdit,
            baseWidthMm: this.canvas.baseWidthMm,
            baseHeightMm: this.canvas.baseHeightMm,
            fullWidth: this.canvas.fullWidth,
            fullHeight: this.canvas.fullHeight,
            fullWidthMm: this.canvas.fullWidthMm,
            fullHeightMm: this.canvas.fullHeightMm,
            width: this.canvas.width,
            height: this.canvas.height,
            widthMm: this.canvas.widthMm,
            heightMm: this.canvas.heightMm,
            dpi: this.canvas.dpi,
            bleedSize: this.canvas.bleedSize,
            createMode: this.canvas.createMode,
            isModify: this.canvas.isModify,
            oddEven:this.canvas.oddEven,
            mediaUrl: this.canvas.mediaUrl,
            createTime: this.canvas.createTime,
            updateTime: this.canvas.updateTime,
            editTime: this.canvas.editTime,
            fullShow: this.canvas.fullShow,
        };
        
        var _bgList = [];
        for (i=0; i<this.bgList.length; i++)
        {
            _bgList[i] = {};
            _bgList[i].mediaId = this.bgList[i].mediaId;
            _bgList[i].bid = this.bgList[i].bid;
            _bgList[i].pos = this.bgList[i].pos;
            _bgList[i].oddEven = this.bgList[i].oddEven,
            _bgList[i].fileId = this.bgList[i].fileId;
            _bgList[i].source = this.bgList[i].source;
            _bgList[i].bgUrl = this.bgList[i].bgUrl;
            _bgList[i].bgMinUrl = this.bgList[i].bgMinUrl;
        }

        var _coverMaterialList = [];
        for (i=0; i<this.coverMaterialList.length; i++)
        {
            _coverMaterialList[i] = {};
            _coverMaterialList[i].mediaId = this.coverMaterialList[i].mediaId;
            _coverMaterialList[i].bid = this.coverMaterialList[i].bid;
            _coverMaterialList[i].mid = this.coverMaterialList[i].mid;
            _coverMaterialList[i].source = this.coverMaterialList[i].source;
        }
        
        var _materialList = [];
        for (i=0; i<this.materialList.length; i++)
        {
            _materialList[i] = {};
            _materialList[i].mediaId = this.materialList[i].mediaId;
            _materialList[i].bid = this.materialList[i].bid;
            _materialList[i].mid = this.materialList[i].mid;
            _materialList[i].pos = this.materialList[i].pos;
            _materialList[i].type = this.materialList[i].type;
            _materialList[i].status = this.materialList[i].status;
            _materialList[i].fileId = this.materialList[i].fileId;
            _materialList[i].source = this.materialList[i].source;

            _materialList[i].paramKey = this.materialList[i].paramKey;
            _materialList[i].paramName = this.materialList[i].paramName;

            _materialList[i].fontSize = this.materialList[i].fontSize;
            _materialList[i].fontFamily = this.materialList[i].fontFamily;
            _materialList[i].text = this.materialList[i].text;
            _materialList[i].underlineOffset = this.materialList[i].underlineOffset;
            _materialList[i].underlineThickness = this.materialList[i].underlineThickness;
            _materialList[i].letterSpacing = this.materialList[i].letterSpacing;
            _materialList[i].lineHeight = this.materialList[i].lineHeight;
            _materialList[i].mathHeight = this.materialList[i].mathHeight;
            _materialList[i].singleHeight = this.materialList[i].singleHeight;
            
            _materialList[i].wordsList = this.materialList[i].wordsList;
        }
        
        var _media = {"canvas": _canvas, "bgList": _bgList, "materialList": _materialList, "coverMaterialList": _coverMaterialList, "curPage":this.curPage};
        return Z.J.toString(_media);
    }

};


//END
})(zhiqim);