
/********************************************
*************** 文字操作 *********************
********************************************/

/** 创建文字素材 **/
function createNewText(text)
{
    var cont = text || "双击修改文字";
    var mid_pos = media.getBgMaterialList(media.curPage).length;
    media.getCurBg().widthMm = parseFloat(media.getCurBg().widthMm);

    var fontSize = 7;
    if (parseFloat(media.canvas.createMode) === 1)
        fontSize = 40;
        
    return new Z.Material(
    {
        $media: media,
        mediaId: media.canvas.mediaId,
        bid: media.curPage,
        mid: mid_pos,
        pos: mid_pos,
        type: 1,
        status: 0,
        source: "",
        text: cont,
        fileId: null,
        paramKey: null,
        paramName: null,
        selected: true,
        reversal: "1 1",
        angle: 0,
        
        // 以下是文字特有属性
        fontSize: fontSize,
        fontFamily: "微软雅黑",
        fontItalic: 0,
        textDecoration: 0,
        letterSpacing: 0,
        mathHeight: 0,
        textZoom: "1 1",
        textAlign: 'left',
        textVertical: 'normal',
        transparency: 100,
        stroke: "#000000 0",
        textSpecial: "normal",
        textSpecialColor: "#000000",
        textSpecialSize: -1,
    });
}

/*** 添加未知文字素材 ***/
function addNewTextOther(text, textMid)
{
    function addNewTextTrue(textMaterial)
    {// 添加指定属性的文本素材
        var fontSize = 7;
        if (parseFloat(media.canvas.createMode) === 1)
            fontSize = 40;
        
        var newText = newMediaMaterial(textMaterial);
        newText.type = 1;
        newText.mid = textMaterial.mid;
        newText.pos = textMaterial.mid;
        newText.fontSize = textMaterial.fontSize || fontSize;
        return newText;
    }

    // 主方法
    var material = addNewTextTrue({text: text, mid: textMid});
    material.text = textMaterialWidthReset(material);
    media.addMaterial(material);
    var thisMaterial = media.getMaterialByMid(textMid);
    //创建一个新的空白元素
    var gWrap = media.tool.createNewSvgElement();
    gWrap.insertAdjacentHTML("afterbegin",'<rect fill="rgba(0,0,0,0)" width="0" height="0"></rect>');
    media.tool.$canvasMaterial.appendChild(gWrap);           //插入页面
    media.tool.addEleEvents(gWrap);                     //添加事件
    //给素材添加基本属性
    gWrap.setAttribute("id", "svgElementSon_" + textMid);
    gWrap.setAttribute("data-mid", textMid);
    gWrap.setAttribute("data-pos", textMid);
    gWrap.setAttribute("transform", "translate(0 0) rotate(0 0 0)");

    // 调用路径返回方法，写入路径
    getPathAjax(thisMaterial, gWrap, 2, 1, function(material){
        initWordsListFromMaterial(material);
        material.doMutliSelected();
        ajaxLoadedDone();
    });
}

/** 新增文字路径 **/
function addNewTextPath(text)
{
    sessionStorage.clear();//点击添加文字 清除本地存储 自己新增的
    // 调用路径生成方法
    function setPathFromResult(result)
    {
        setPathForText(result, null, null, null, material, null);
    }
    // 通过浏览器内置，绘制文字
    function getPathByLocal()
    {
        ServiceAPI.text2Svg(material.fontFamily, 0, fontSize, textStr)
            .then(setPathFromResult, getPathByService);
    }
    // 通过远程服务端，绘制文字
    function getPathByService()
    {
        // 生成 SVG 对象
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("getPathData");
        ajax.addParam(material.fontFamily);
        ajax.addParam(0);
        ajax.addParam(fontSize);
        ajax.addParam(textStr);
        ajax.addParam("");
        ajax.setSuccess(function(){
            setPathFromResult(this.responseText);
        });
        ajax.execute();
    }

    // 1：定义素材
    var textObj = createNewText(text);
    textObj.text = textMaterialWidthReset(textObj);
    var textStr = textObj.text.replace(/-%5-%-%5-/g,"\n");
    
    media.addMaterial(textObj);
    var material = media.getMaterialByMid(textObj.mid, textObj.bid);
    var fontSize = material.fontSize;
    if (parseFloat(media.canvas.createMode) === 0) {
        fontSize += "pt";
    } else {
        fontSize += "px";
    }

    // 2：依浏览器判断
    if (typeof(ServiceAPI) === "undefined" || !isUseLocalFont)
        getPathByService();
    else
        getPathByLocal();
}
/** 修改文字路径 **/
function getPathAjax(material, $curElem, groupType, showLoading, fun)
{
    // 调用路径生成方法
    function setPathFromResult(result)
    {
        setPathForText(result, wordsLoading, groupType, fun, material, $curElem);
    }
    // 通过浏览器内置，绘制文字
    function getPathByLocal()
    {
        ServiceAPI.text2Svg(material.fontFamily, style, fontSize, textStr, wordsList)
            .then(setPathFromResult, getPathByService);
    }
    // 通过远程服务端，绘制文字
    function getPathByService()
    {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("getPathData");
        ajax.addParam(material.fontFamily);
        ajax.addParam(style);
        ajax.addParam(fontSize);
        ajax.addParam(textStr);
        ajax.addParam(wordsList);
        ajax.setSuccess(function () {
            setPathFromResult(this.responseText);
        });
        ajax.execute();
    }

    // 1：显示加载框
    if (showLoading){
        var wordsLoading;
        // var wordsLoading = Z.loading({shadow: true, text:"正在加载...", target: 'stage_design'});
    }

    // 2：取得绘制需要参数
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    groupType = parseFloat(groupType + '');
    var style = (material.fontWeight)?(1):(0);
    var wordsList = formatWordsList(material.wordsList);
    var fontSize = material.fontSize;
    var textStr = material.text.replace(/-%5-%-%5-/g,"\n");
    if (parseFloat(media.canvas.createMode) === 0) {
        fontSize += "pt";
    } else {
        fontSize += "px";
    }

    // 3：依浏览器判断
    if (typeof(ServiceAPI) === "undefined" || !isUseLocalFont)
        getPathByService();
    else
        getPathByLocal();
}
// 插入 data-XXX 属性
function setDataInSvg (material, $curElem)
{
    var dataFontSize = material.fontSize;
    if (parseFloat(media.canvas.createMode) === 0) {
        dataFontSize += "pt";
    } else {
        dataFontSize += "px";
    }
    //检查 material 参数，针对某些特定属性
    checkMaterialData(material);

    //设置 material 参数
    $curElem.setAttribute("data-fontfamily", material.fontFamily);
    $curElem.setAttribute("data-fontsize", dataFontSize);
    $curElem.setAttribute("data-text", material.text.replace(/</g, '-%6-%-%0-'));
    $curElem.setAttribute("data-textalign", material.textAlign);
    $curElem.setAttribute("data-underlineoffset", material.underlineOffset);
    $curElem.setAttribute("data-underlinethickness", material.underlineThickness);
    $curElem.setAttribute("data-letterspacing", material.letterSpacing);
    $curElem.setAttribute("data-mathheight", material.mathHeight);
    $curElem.setAttribute("data-singleheight", material.singleHeight);
    $curElem.setAttribute("data-lineheight", material.lineHeight);
    $curElem.setAttribute("data-fontweight", material.fontWeight);
    $curElem.setAttribute("data-fontitalic", material.fontItalic);
    $curElem.setAttribute("data-texty", material.textY);
    $curElem.setAttribute("data-textzoom", material.textZoom);
    $curElem.setAttribute("data-groupid", material.groupId);
    $curElem.setAttribute("data-svgboxx", material.svgboxx);
    $curElem.setAttribute("data-textvertical", material.textVertical);
    $curElem.setAttribute("data-textspecial", material.textSpecial);
    $curElem.setAttribute("data-textspecialcolor", material.textSpecialColor);
    $curElem.setAttribute("data-textspecialsize", material.textSpecialSize);
}
// 检查某些错误数据
function checkMaterialData(material)
{
    //
}
// 解析路径数据结果，生成文字排版
function setPathForText(result, wordsLoading, groupType, fun, material, $curElem)
{
    // 循环处理方法
    function setEachPath()
    {
        var pathIndex = 0;
        var letterSpacing = parseFloat(material.letterSpacing + '');
        var textStr = material.text.replace(/(-%5-%-%5-)|\n/g, "");
        var i, j, lineData, lineWidth, $gLine, dx, transX, transY, pathData, $gItem, $pathItem,
            pathWidth, pathHeight, pathD, word, gItemX, gItemTrans, pathColor, $line, setX2;
        if (!material.wordsList){
            var resetWordsList = true;
            material.wordsList = [];
        }

        // 循环处理
        for (i = 0;i < lineList.length;i++)
        {
            lineData = Z.J.toObject(lineList[i]);
            lineWidth = lineData.width;
            $gLine = document.createElementNS(xmlns, "g");
            dx = -lineData.dx > 0 ? -lineData.dx : 0;
            transX = lineData.x + dx;
            transY = -lineData.y + (material.lineHeight) * i;
            $gLine.setAttribute("transform","translate("+ transX +" " + transY + ")");
            $gLine.setAttribute("data-dx", (0 - lineData.dx) + "");
            if (!lineData.pathList) {
                $svg.appendChild($gLine);
                continue;
            }
            // 循环每个字符
            for (j = 0;j < lineData.pathList.length;j++)
            {
                pathData = Z.J.toObject(lineData.pathList[j]);
                $gItem = document.createElementNS(xmlns, "g");
                $pathItem = document.createElementNS(xmlns, "path");
                pathWidth = pathData.width;
                pathHeight = pathData.height;
                pathD = pathData.d;
                // 通过 wordsList 获取单个文字信息，不存在则新建
                if (resetWordsList)
                {
                    material.wordsList[pathIndex] = {
                        'color' : material.color,
                        'fontFamily' : material.fontFamily,
                        'fontItalic' : material.fontItalic,
                        'fontWeight' : material.fontWeight,
                        'fontSize' : material.fontSize,
                        'textDecoration' : material.textDecoration,
                        'text' : textStr[j],
                        'index' : pathIndex,
                    }
                }
                word = material.wordsList[pathIndex];
                gItemX = parseFloat(pathData.x) + letterSpacing * j;
                gItemTrans = "translate(" + gItemX + " 0)";
                pathColor = word.color;
                // 空白字符不显示
                if (j === lineData.pathList.length - 1 && !pathD)
                {
                    pathWidth = Math.round((parseFloat(media.canvas.createMode) === 0 ?
                        pt2px(material.fontSize) : material.fontSize) / 3);
                    pathD = 'M0 0 L'+ pathWidth +' 0 L'+ pathWidth +' -1 L0 -1 L0 0 Z';
                    $pathItem.setAttribute('style', 'visibility: hidden;');
                    $pathItem.setAttribute('data-hidden', '1');
                }
                // 斜体判断
                if (word.fontItalic)
                    gItemTrans += 'skewX(-18)';
                // 下划线判断
                if (word.textDecoration)
                {
                    $line = document.createElementNS(xmlns, "line");
                    setX2 = pathWidth + parseFloat(material.letterSpacing);
                    $line.setAttribute("x1", '0');
                    $line.setAttribute("y1", material.underlineOffset);
                    $line.setAttribute("x2", setX2);
                    $line.setAttribute("y2", material.underlineOffset);
                    $line.setAttribute("stroke", word.color);
                    $line.setAttribute("stroke-width", material.underlineThickness);
                    $gItem.appendChild($line);
                }
                // path 元素设置属性
                $pathItem.setAttribute("d", pathD);
                $pathItem.setAttribute("fill", pathColor);
                // g 元素设置属性
                $gItem.setAttribute("class", "font-path");
                $gItem.setAttribute("transform", gItemTrans);
                $gItem.setAttribute("data-x", pathData.x);
                $gItem.setAttribute("data-width", pathWidth);
                $gItem.setAttribute("data-height", pathHeight);
                $gItem.setAttribute("data-color", pathColor);
                $gItem.setAttribute("data-fontfamily", word.fontFamily);
                $gItem.setAttribute("data-fontsize", word.fontSize);
                $gItem.setAttribute("data-fontweight", word.fontWeight);
                $gItem.setAttribute("data-fontitalic", word.fontItalic);
                $gItem.setAttribute("data-textdecoration", word.textDecoration);
                $gItem.setAttribute("data-text", word.text.replace(/</g, '-%6-%-%0-'));
				$gItem.appendChild($pathItem);
                $gLine.appendChild($gItem);
                pathIndex++;
            }
            $svg.appendChild($gLine);

            // 定义每一行的宽度
            if (Math.ceil($gLine.getBBox().width) !== lineWidth){
                lineWidth = Math.ceil($gLine.getBBox().width);
            }
            widthArr.push(lineWidth);
            $gLine.setAttribute("data-width", lineWidth + "");
        }
        // 新建素材，插入元素到画布
        if (newElem){
            media.tool.$canvasMaterial.appendChild($curElem);
        }
    }

    // 1：解析数据内容
    var resultObj = Z.J.toObject(result);
    var lineList = Z.J.toObject(resultObj.data);
    material.underlineOffset = parseFloat(resultObj.underlineOffset);
    material.underlineThickness = parseFloat(resultObj.underlineThickness);
    material.singleHeight = parseFloat(resultObj.lineHeight);
    material.mathHeight = parseFloat(material.mathHeight);
    material.lineHeight = Math.round(material.singleHeight + material.mathHeight);
    material.textY = Math.abs(resultObj.textY);

    // 2：定义素材对象
    if (!$curElem){
        var newElem = true;
        $curElem = media.tool.createNewSvgElement();
    }
    var $rect = $curElem.querySelector("rect");
    if (!$rect){
        $curElem.insertAdjacentHTML("afterbegin",'<rect fill="rgba(0,0,0,0)"></rect>');
        $rect = $curElem.querySelector("rect");
    }
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var $svg = $$svg[0];

    // 3：重置对象大小
    $rect.setAttribute("width",'1');
    $rect.setAttribute("height",'1');
    $svg.innerHTML = "";
    $svg.removeAttribute("viewBox");
    $svg.removeAttribute("width");
    $svg.removeAttribute("height");

    // 4：循环处理每行path
    var widthArr = [];
    setEachPath();

    // 5：素材宽度、高度
    material.width = Math.max(getMaxNum(widthArr), $curElem.getBBox().width);
    var singleMax = Math.max(material.lineHeight, material.singleHeight);
    material.height = material.lineHeight * (lineList.length - 1) + singleMax;
    $svg.setAttribute("viewBox","0 0 " + material.width + " " + material.height);
    $svg.setAttribute("width",material.width);
    $svg.setAttribute("height",material.height);
    $rect.setAttribute("width",material.width);
    $rect.setAttribute("height",material.height);
    material.svgboxx = $svg.getBBox().x;

    // 6：文字参数写入SVG
    setDataInSvg (material,$curElem);

    // 7：新素材文字处理
    var transStr = '';
    var rotateStr = '';
    if (newElem)
    {
        $curElem.setAttribute("id", "svgElementSon_" + material.mid);
        $curElem.setAttribute("data-mid", material.mid);
        $curElem.setAttribute("data-pos", material.pos);
        $curElem.setAttribute("fill-opacity", (material.transparency || 100) / 100);
        $curElem.setAttribute("stroke-opacity", (material.transparency || 100) / 100);
        material.x = (media.getCurBg().width - material.width) / 2;
        material.y = (media.getCurBg().height - material.height) / 2;
        transStr = "translate(" + material.x + " " + material.y + ")";
        rotateStr = "rotate(0 " +material.width/2 + " " + material.height/2 +")";
        $curElem.setAttribute("transform", transStr + " " + rotateStr);
        // 更新 source
        updateMaterialSource(material, $curElem);
        // 添加操作事件
        media.tool.addEleEvents($curElem);
        // 选中素材
        selectTheElement(material, $curElem);
        // 保存记录，刷新预览列表
        saveHistory();
        return;
    }

    // 8：文字特效处理（斜体、下划线在路径绘制一并完成）
    // 文字对齐
    if (material.textAlign !== 'left')
        setElementAlign(material.textAlign, material, $curElem);
    // 竖排文字
    if (material.textVertical !== 'normal') {
        var setStyle = material.textVertical;
        material.textVertical = 'normal';
        setTextVerticalLine(setStyle, material, $curElem);
    }
    // 文字缩放
    if (material.textZoom !== '1 1')
        setTextZoom(null, material, $curElem);
    // 文字特效
    doTextSpecialSet(material.textSpecial, getIdObjArrFromMaterial(material));

    // 9：编辑模式
    // groupType 定义为2；粘贴文本的情况 ---- 重定义定位，更新 source；
    if (groupType === 2)
    {
        material.x = (media.getCurBg().width - material.width) / 2;
        material.y = (media.getCurBg().height - material.height) / 2;
        material.x = (material.x > 10)?material.x:10;
        material.y = (material.y > 10)?material.y:10;
        transStr = "translate(" + material.x + " " + material.y + ")";
        rotateStr = "rotate(0 " +material.width/2 + " " + material.height/2 +")";
        $curElem.setAttribute("transform", transStr + " " + rotateStr);
        // 更新 source 数据
        updateMaterialSource(material, $curElem);
    }
    // groupType 定义为1；多素材绘制的情况 ---- 仅更新 source；
    else if (groupType === 1)
    {
        // 更新 source 数据
        // updateMaterialSource(material, $curElem);
    }
    // groupType 未定义，或定义为0；单个素材的情况 ---- 进行偏移校准，更新 source 并保存
    else if (!groupType)
    {
        // 更新 source 数据
        updateMaterialSource(material, $curElem);
        // 更新选中框
        setToolStaticLoc($curElem);
        // 保存
        saveHistory();
    }

    // 10：去除加载框
    if (wordsLoading){
        setTimeout(function(){
            wordsLoading.close();
            wordsLoading = null;
        }, 600);
    }

    // 11：自定义回调方法
    Z.T.isFunction(fun) && fun(material, $curElem);
}

/** 获取文字曲线，纯净代码 **/
function getPathSvgFromText(textStr, textStyle)
{
    function getPathSvg(result)
    {
        // 1：解析数据内容，定义变量
        var resultObj = Z.J.toObject(result);
        var lineList = Z.J.toObject(resultObj.data);
        var pathIndex = 0;
        underlineOffset = parseFloat(resultObj.underlineOffset);
        underlineThickness = parseFloat(resultObj.underlineThickness);
        singleHeight = parseFloat(resultObj.lineHeight);
        if (lineHeight)
            mathHeight = lineHeight - singleHeight;
        else
            lineHeight = singleHeight + mathHeight;
        textStr = textStr.replace(/(-%5-%-%5-)|\n/g, "");
        var i, j, lineData, lineWidth, $gLine, pathData, $gItem, $pathItem,
            pathWidth, pathHeight, pathD, gItemX, gItemTrans;

        // 2：循环处理每行path
        for (i = 0; i < lineList.length; i++)
        {
            lineData = Z.J.toObject(lineList[i]);
            lineWidth = lineData.width;
            $gLine = document.createElementNS(xmlns, "g");
            $gLine.setAttribute("transform", "translate(" + lineData.x + " " + lineHeight * i + ")");
            if (!lineData.pathList) {
                $svg.appendChild($gLine);
                continue;
            }
            // 循环每个字符
            for (j = 0; j < lineData.pathList.length; j++)
            {
                pathData = Z.J.toObject(lineData.pathList[j]);
                $gItem = document.createElementNS(xmlns, "g");
                $pathItem = document.createElementNS(xmlns, "path");
                pathWidth = pathData.width;
                pathHeight = pathData.height;
                pathD = pathData.d;
                gItemX = parseFloat(pathData.x) + letterSpacing * j;
                gItemTrans = "translate(" + gItemX + " 0)";
                // 空白字符不显示
                if (j === lineData.pathList.length - 1 && !pathD) {
                    pathWidth = Math.round(
                        (parseFloat(media.canvas.createMode) === 0 ? pt2px(fontSize) : fontSize) / 3
                    );
                    pathD = 'M0 0 L' + pathWidth + ' 0 L' + pathWidth + ' -1 L0 -1 L0 0 Z';
                    $pathItem.setAttribute('style', 'visibility: hidden;');
                    $pathItem.setAttribute('data-hidden', '1');
                }
                // path 元素设置属性
                $pathItem.setAttribute("d", pathD);
                $pathItem.setAttribute("fill", fontColor);
                // g 元素设置属性
                $gItem.setAttribute("class", "font-path");
                $gItem.setAttribute("transform", gItemTrans);
                $gItem.setAttribute("data-width", pathData.width);
                $gItem.setAttribute("data-x", pathData.x);
                $gItem.appendChild($pathItem);
                $gLine.appendChild($gItem);
                pathIndex++;
            }
            $svg.appendChild($gLine);
        }

        // 3：素材宽度、高度
        var $bodySvg = document.createElementNS(xmlns, 'svg');
        $bodySvg.setAttribute('style', 'position:absolute;z-index:-9999;pointer-events:none;opacity:0;');
        $bodySvg.innerHTML = $svg.outerHTML;
        document.documentElement.appendChild($bodySvg);
        var $svgInsert = $bodySvg.querySelector("svg");
        var $$gLine = $svgInsert.children;
        var lineBox = null;
        for (i = 0;i < $$gLine.length;i++)
        {
            $gLine = $$gLine[i];
            lineBox = $gLine.getBBox();
            if (textDecoration)
            {
                var $line = document.createElementNS(xmlns, "line");
                $line.setAttribute("x1", 0);
                $line.setAttribute("y1", underlineOffset);
                $line.setAttribute("x2", lineBox.width);
                $line.setAttribute("y2", underlineOffset);
                $line.setAttribute("stroke", fontColor);
                $line.setAttribute("stroke-width", underlineThickness);
                $gLine.appendChild($line);
            }
        }
        svgBox = $svgInsert.getBBox();

        $svg.innerHTML = $svgInsert.innerHTML;
        var setHeight = svgBox.height + (textDecoration ? underlineThickness : 0);
        $svg.setAttribute("viewBox", svgBox.x + " " + svgBox.y + " " + svgBox.width + " " + setHeight);
        $svg.setAttribute("width", svgBox.width + "");
        $svg.setAttribute("height", setHeight + "");

        document.documentElement.removeChild($bodySvg);
    }

    var lineHeight = textStyle.lineHeight || 0;
    var $svg = document.createElementNS(xmlns, "svg");
    $svg.setAttribute("preserveAspectRatio", "none");
    $svg.setAttribute("version", "1.1");
    $svg.setAttribute("xmlns", xmlns);
    $svg.setAttribute("data-lineheight", lineHeight);
    $svg.setAttribute("data-singleheight", lineHeight);
    $svg.setAttribute("data-mathheight", "0");

    if (!textStr.trim())
        return $svg;

    var fontSize = textStyle.fontSize;
    var fontFamily = textStyle.fontFamily || "微软雅黑";
    var fontWeight = textStyle.fontWeight || 0;
    var textDecoration = textStyle.textDecoration || 0;
    var fontColor = textStyle.fontColor || "#000000";
    var letterSpacing = parseFloat(textStyle.letterSpacing || 0);
    var mathHeight = parseFloat(textStyle.mathHeight || 0);
    var singleHeight = parseFloat(textStyle.singleHeight || 0);
    var underlineOffset = 0;
    var underlineThickness = 0;

    var ajax = new Z.Ajax();
    ajax.setSync();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("getPathData");
    ajax.addParam(fontFamily);
    ajax.addParam(fontWeight);
    ajax.addParam(fontSize);
    ajax.addParam(textStr);
    ajax.addParam("");
    ajax.setSuccess(function () {
        getPathSvg(this.responseText);
    });
    ajax.execute();

    $svg.setAttribute("data-lineheight", lineHeight);
    $svg.setAttribute("data-singleheight", singleHeight);
    $svg.setAttribute("data-mathheight", mathHeight);
    $svg.setAttribute("data-underlineoffset", underlineOffset);
    $svg.setAttribute("data-underlinethickness", underlineThickness);

    return $svg;
}

/** 判断富文本修改是否全选 **/
function isSelectAll()
{
    var selection = window.getSelection();
    if (selection.isCollapsed) {
        return false;
    }
    var selectText = selection + "";
    var activeEle = document.activeElement;
    var editorText = Z(activeEle).text();
    if (Z.S.trim(selectText) === Z.S.trim(editorText)) {
        return true;
    }
    return false;
}

/** 文字字体/文字大小输入框-点击 **/
function fontSetInputClick(event)
{
    // 主方法，定义变量
    Z.E.stop(event);
    var $input = Z.E.current(event);
    var $dropDown = $input.parentNode.parentNode.querySelector(".z-dropdown");
    var $list = $dropDown.querySelector(".z-list");

    // 1：隐藏其他弹窗
    hideTextDropList($list)

    // 2：输入框默认值
    if (Z($input).parent().hasClass("fontFamily_inputWrap")){
        Z($input).removeClass("invisible");
    }
    var defaultVal = $dropDown.querySelector(".z-default").getAttribute('value');
    Z($input).attr('placeholder', defaultVal);

    // 3：模拟点击事件
    var evClick = new Event("click", {"bubbles":false, "cancelable":false});
    if ($list.style.display === "none") {
        $dropDown.dispatchEvent(evClick);
    }

    // 4：获取输入框焦点
    $input.focus();
}
/** 文字字体输入框-变化 **/
function fontSetInputInput(elem)
{
    var $input = elem;
    var inputVal = $input.value.toLowerCase();
    var $dropDown = Z($input).parent().parent().find(".z-dropdown");
    var $list = $dropDown.find(".z-list");
    var $$span = $dropDown.find(".z-list > span");
    $$span.each(function($item){
        var spanVal = Z($item).attr("value").toLowerCase();
        if (spanVal.indexOf(inputVal) === -1) {
            Z($item).addClass("zi-hide").removeClass("zi-show-ib");
        } else {
            Z($item).addClass("zi-show-ib").removeClass("zi-hide");
        }
    });
    if (!$dropDown.find(".z-list > span.zi-show-ib")[0]) {
        $list.addClass("emptyTip");
    } else {
        $list.removeClass("emptyTip");
    }
}
/** 文字字体输入框-失焦 **/
function fontSetInputBlur(elem)
{
    var $input = elem;
    var $dropDown = Z($input).parent().parent().find(".z-dropdown");
    var $$span = $dropDown.find(".z-list > span");
    Z($input).addClass("invisible").val("");
    $$span.addClass("zi-show-ib").removeClass("zi-hide");
}
/** 文字大小输入框-变化 **/
function fontSizeInputChange(elem)
{
    changeMaterialFontSize(elem.value);
}

/** 更新文字字间距 **/
function updateFontLetterSpacing(letterSpacing)
{
    // 进行偏移设置
    function setElemTranslate()
    {
        if (material.textVertical !== 'normal')
            return;
        if (oldData.width === newWidth || textAlign === 'left' || textAlign === 'justify'){
            return;
        }
        var mx = oldData.width - newWidth;
        var setTrans = $curElem.getAttribute('transform');
        var transX = oldData.x;
        var transY = oldData.y;
        var angle = oldData.rotate * Math.PI / 180;

        if (textAlign === 'center'){
            mx /= 2;
        }
        transX += Math.cos(angle) * mx;
        transY += Math.sin(angle) * mx;

        setTrans = setTrans.replace(/translate\([^/)]+\)/, "translate(" + transX + " " + transY + ")");
        $curElem.setAttribute("transform", setTrans);
    }
    // 设置 $svg、$rect 的 width、height
    function resetElemAttr()
    {
        var setWidth, setHeight;
        if (material.textVertical !== 'normal')
        {
            setWidth = $curElem.getBBox().width;
            setHeight = $curElem.getBBox().height;
        }
        else
        {
            newWidth = $curElem.getBBox().width;
            material.width =  newWidth;
            if (!material.height) {
                material.height = oldData.height;
            }
            newHeight = material.height;
            setWidth = material.width;
            setHeight = material.height;
        }

        material.letterSpacing = letterSpacing;
        $svg.setAttribute("viewBox","0 0 " + setWidth + " " + setHeight);
        $svg.setAttribute("width", setWidth);
        $svg.setAttribute("height", setHeight);
        $rect.setAttribute("width", setWidth);
        $rect.setAttribute("height", setHeight);
        $curElem.setAttribute("data-letterspacing", material.letterSpacing);
    }
    // 循环处理，每个路径偏移
    function setEachPath()
    {
        // 重设单行 g 素材的偏移
        function setGLine($gLine){
            if (material.textVertical !== 'normal')
                return;
            var dx = parseFloat($gLine.getAttribute('data-dx'));
            var gTrans = $gLine.getAttribute('transform');
            dx = dx > 0 ? dx : 0;
            gTrans = gTrans.replace(/translate\s?\(\s?-?\d+(\.\d+)?/, 'translate(' + dx);
            $gLine.setAttribute('transform', gTrans);
        }

        // 主方法
        var i, j, $gLine, $$gPath, transMatrix, matrixE, matrixF, pathText,
            transX, transY, transDataVal, tempX, $gPath, pathTrans, $line;
        for (i = 0;i < $$gLine.length;i++)
        {
            $gLine = $$gLine[i];
            setGLine($gLine);
            $$gPath = $gLine.querySelectorAll(".font-path");

            // 第一个字的偏移
            transX = $$gPath[0].transform.baseVal[0].matrix.e;
            for (j = 0;j < $$gPath.length;j++)
            {
                $gPath = $$gPath[j];
                pathText = $gPath.getAttribute('data-text').replace(/-%6-%-%0-/g, '<');
                pathTrans = $gPath.getAttribute("transform");
                transDataVal = parseFloat($gPath.getAttribute("data-x"));
                transMatrix = $gPath.transform.baseVal[0].matrix;
                matrixE = transMatrix.e;
                matrixF = transMatrix.f;
                if (material.textVertical === 'normal'){
                    transY = matrixF;
                    transX = transDataVal + letterSpacing * j;
                } else {
                    transX = matrixE;
                    transY = transDataVal + letterSpacing * j;
                    if (/[\u4e00-\u9fa5]/.test(pathText))
                        transY -= $gPath.getBBox().y;
                }
                pathTrans = pathTrans.replace(/translate\([^)]+\)/, 'translate(' + transX + ' ' + transY +')');
                $gPath.setAttribute("transform", pathTrans);

                tempX = parseFloat($gPath.getAttribute("data-width")) + letterSpacing;
                // 下划线判断
                if (material.textDecoration && ($line = Z($gPath).children("line")[0])) {
                    $line.setAttribute("x2",tempX);
                }
            }
        }
    }

    // 主方法
    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (!material)
        return;

    if (material.type !== 1 && material.type !== 5)
        return;

    letterSpacing = parseFloat(letterSpacing + "");
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();

    if (material.type === 5)
    {
        var dataType = $svg.getAttribute("data-type");
        if (dataType === "shape-table")
            return updateTableFontLetterSpacing(letterSpacing);
    }

    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var textAlign = material.textAlign;
    var $rect = $curElem.querySelector("rect");
    var $$gLine = Z($svg).children("g");
    var oldData, newWidth, newHeight;

    // 1：保存变化前的值，去除宽高限制
    oldData = media.tool.getEleData($curElem);
    $svg.removeAttribute("viewBox");
    $svg.removeAttribute("width");
    $svg.removeAttribute("height");
    $rect.setAttribute("width", '1');
    $rect.setAttribute("height", '1');

    // 2：循环处理每个字符路径
    setEachPath();

    // 3：设置素材的宽高、属性
    resetElemAttr();

    // 4：特效和展示
    // 缩放
    setTextZoom();
    // 对齐
    if (material.textVertical === 'normal') setElementAlign(textAlign, material, $curElem);
    // 文字特效
    doTextSpecialSet();
    editOverSet($curElem);      // 位置较准
    setToolStaticLoc();         // 选择框定位
}
// 更新表格字间距
function updateTableFontLetterSpacing(letterSpacing)
{
    // 表格素材的字间距修改
    function updateTableMaterialLetterSpacing()
    {
        material.letterSpacing = letterSpacing;
        var $$gTd = $svg.querySelectorAll("g[data-colspan]");
        var allGTdLength = $$gTd.length;
        var i = 0, j = 0, k = 0;
        var $gTd = null, tdAlign = "center";
        var $gPathSvg = null, gPathSvgTrans = null, gTdWidth = 0, gPathSvgWidth = 0, setGPathSvgTrans = "", $svgText = null;
        var svgTextBox = null, svgTextView = null, $$line = null, allLineLength = 0, svgLineWidth = 0;
        var $line = null, lineBoxWidth = null, lineTransX = 0, lineTransY = 0, setLineTrans = "";
        var $$path = null, allPathLength = 0, $path, pathX = 0, pathTrans = "";
        for (i;i < allGTdLength;i++)
        {
            $gTd = $$gTd[i];
            $gTd.setAttribute("data-letterspacing", letterSpacing);
            $gPathSvg = $gTd.querySelector("g");
            $svgText = $gPathSvg.querySelector("svg");
            $$line = $svgText.children;
            allLineLength = $$line.length;
            // 遍历每行
            for (j = 0;j < allLineLength;j++)
            {
                $$path = $$line[j].querySelectorAll("g.font-path");
                allPathLength = $$path.length;
                // path偏移
                for (k = 0;k < allPathLength;k++)
                {
                    $path = $$path[k];
                    pathX = parseFloat($path.getAttribute("data-x")) + k * letterSpacing;
                    pathTrans = $path.getAttribute("transform");
                    pathTrans = pathTrans.replace(/translate\s*\([^\s]+/, "translate(" + pathX);
                    $path.setAttribute("transform", pathTrans);
                }
            }
            // 尺寸校准
            svgTextBox = $svgText.getBBox();
            svgTextView = $svgText.viewBox.baseVal;
            $svgText.setAttribute("width", svgTextBox.width);
            $svgText.setAttribute("height", svgTextBox.height);
            $svgText.setAttribute("viewBox", svgTextView.x + " " + svgTextView.y + " " + svgTextBox.width + " " + svgTextBox.height);
            // 内容对齐
            tdAlign = $gTd.getAttribute("data-textalign") || "center";


            gPathSvgTrans = $gPathSvg.transform.baseVal[0].matrix;
            gTdWidth = $gTd.querySelector("rect").width.baseVal.value;
            gPathSvgWidth = $gPathSvg.getBBox().width;
            switch(tdAlign)
            {
                case "left":
                    setGPathSvgTrans = 0;
                    break;
                case "center":
                    setGPathSvgTrans = (gTdWidth - gPathSvgWidth)/2;
                    break;
                case "right":
                    setGPathSvgTrans = gTdWidth - gPathSvgWidth;
                    break;
            }
            setGPathSvgTrans = "translate(" + setGPathSvgTrans + " " + gPathSvgTrans.f + ")";
            $gPathSvg.setAttribute("transform", setGPathSvgTrans);
            // 多行处理
            $svgText = $gPathSvg.querySelector("svg");
            $$line = $svgText.children;
            if ($$line.length <= 1)
                continue;

            svgLineWidth = $svgText.getBBox().width;
            for (j = 0;j < $$line.length;j++)
            {
                $line = $$line[j];
                lineBoxWidth = $line.getBBox().width;
                switch(tdAlign)
                {
                    case "left":
                        lineTransX = 0;
                        break;
                    case "center":
                        lineTransX = (svgLineWidth - lineBoxWidth)/2;
                        break;
                    case "right":
                        lineTransX = svgLineWidth - lineBoxWidth;
                        break;
                }
                lineTransY = $line.transform.baseVal[0].matrix.f;
                setLineTrans = "translate(" + lineTransX + " " + lineTransY +")";
                $line.setAttribute("transform", setLineTrans);
            }
            // 位置较准
            resetTdTextSizeTrans($gTd);
        }
        // 更新素材source
        updateMaterialSource();
    }

    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (!material || material.type !== 5)
        return;

    letterSpacing = parseFloat(letterSpacing + "");
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = $gWrap.querySelector("svg");
    var $$svg = $gWrap.children;
    while ($$svg.length > 1)
        $gWrap.removeChild($$svg[$$svg.length - 1]);
    var dataType = $svg.getAttribute("data-type");
    if (dataType !== "shape-table")
        return;

    var $activeElem = document.activeElement;
    if ($activeElem.className.includes("tableText-editArea"))
        $activeElem.style.letterSpacing = letterSpacing + "px";
    else
        updateTableMaterialLetterSpacing();
}
/** 更新文字行间距 **/
function updateFontLineHeight(newLineHeight)
{
    // 竖排的行间距设置
    function setVerticalTrans(i)
    {
        $line = $$gLine[i];
        lineTrans = $line.getAttribute("transform");
        lineTransData = /translate\(([^)\s]+)\s([^)\s]+)\)/.exec(lineTrans);
        setLineTransY = parseFloat(lineTransData[2]);
        setLineTransX += underlineSpace + material.mathHeight;

        lineTrans = lineTrans.replace(/translate\([^)]+\)/, 'translate(' + (setLineTransX - $line.getBBox().x) + ' ' + setLineTransY + ')');
        $line.setAttribute("transform", lineTrans);
        setLineTransX += $line.getBBox().width;
    }

    // 1：主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (!material)
        return;

    newLineHeight = parseFloat(newLineHeight);
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();

    if (material.type === 5)
    {
        var dataType = $svg.getAttribute("data-type");
        if (dataType === "shape-table")
            return updateTableFontLineHeight(newLineHeight);
    }

    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var $rect = $curElem.querySelector("rect");
    var $$gLine = Z($curElem.querySelector("svg")).children("g");
    var gLength = $$gLine.length;

    // 2：取消宽高设置
    $svg.removeAttribute("viewBox");
    $svg.removeAttribute("width");
    $svg.removeAttribute("height");
    $rect.setAttribute("width",1);
    $rect.setAttribute("height",1);

    // 3：计算 mathHeight、lineHeight
    material.singleHeight = parseFloat(material.singleHeight);
    var mathHeight = newLineHeight - material.singleHeight;
    if (gLength === 1) {
        mathHeight = mathHeight > 0 ? mathHeight : 0;
    }
    material.mathHeight = mathHeight;
    material.lineHeight = material.singleHeight + material.mathHeight;

    // 4：设置每个 tspan 的偏移量
    var i, $line, lineTrans, lineTransData;
    var underlineSpace = parseFloat(material.underlineOffset) + parseFloat(material.underlineThickness);
    var setLineTransX = 0, setLineTransY = 0;
    if (material.textVertical === 'right')
    {
        for (i = gLength - 1;i > -1;i--)
            setVerticalTrans(i);
    }
    else
    {
        for (i = 0;i < gLength;i++)
        {
            if (material.textVertical === 'left') {
                setVerticalTrans(i);
                continue;
            }
            $line = $$gLine[i];
            lineTrans = $line.getAttribute("transform");
            lineTransData = /translate\(([^)\s]+)\s([^)\s]+)\)/.exec(lineTrans);
            setLineTransX = parseFloat(lineTransData[1]);
            setLineTransY = material.textY + material.lineHeight * i;
            lineTrans = lineTrans.replace(/translate\([^)]+\)/, 'translate(' + setLineTransX + ' ' + setLineTransY + ')');
            $line.setAttribute("transform", lineTrans);
        }
    }

    // 5：计算 setWidth、setHeight
    var setWidth =  $curElem.getBBox().width;
    var setHeight =  $curElem.getBBox().height;
    if (material.textVertical === 'normal')
    {
        setWidth += parseFloat(material.fontSize);
        if (!material.width){
            material.width =  setWidth;
        }
        var singleMax = Math.max(material.lineHeight, material.singleHeight);
        material.height = material.lineHeight * ($$gLine.length - 1) + singleMax;
        setHeight = material.height;
    }

    // 6：设置 svg 属性
    $svg.setAttribute("viewBox","0 0 " + setWidth + " " + setHeight);
    $svg.setAttribute("width", setWidth + '');
    $svg.setAttribute("height", setHeight + '');
    $rect.setAttribute("width", setWidth + '');
    $rect.setAttribute("height", setHeight + '');
    $curElem.setAttribute("data-mathheight", material.mathHeight);
    $curElem.setAttribute("data-lineheight", material.lineHeight);

    // 7：缩放、定位处理
    // 文字缩放处理
    setTextZoom();
    // 文字特效
    doTextSpecialSet();
    // 位置较准
    editOverSet($curElem);
    // 选择框定位
    setToolStaticLoc();
}
// 更新表格行间距
function updateTableFontLineHeight(newLineHeight)
{
    // 表格素材的行间距修改
    function updateTableMaterialLineHeight()
    {
        material.lineHeight = newLineHeight;
        var $$gTd = $svg.querySelectorAll("g[data-colspan]");
        var allGTdLength = $$gTd.length;
        var i = 0, j = 0, $gTd = null, $gPathSvg = null, $svgText = null, $$line = null, $line = null;
        var svgTextBox = null, svgTextView = null, allLineLength = 0, lineTrans = "", setY = 0;
        for (i;i < allGTdLength;i++)
        {
            $gTd = $$gTd[i];
            $gTd.setAttribute("data-lineheight", newLineHeight);
            $gPathSvg = $gTd.querySelector("g");
            $svgText = $gPathSvg.querySelector("svg");
            $$line = $svgText.children;
            allLineLength = $$line.length;
            // 遍历每行
            for (j = 0;j < allLineLength;j++)
            {
                $line = $$line[j];
                lineTrans = $line.getAttribute("transform");
                lineTrans = lineTrans.replace(/\s[^)]+\)/, " " + newLineHeight * j + ")");
                $line.setAttribute("transform", lineTrans);
            }
            // 尺寸校准
            svgTextBox = $svgText.getBBox();
            svgTextView = $svgText.viewBox.baseVal;
            $svgText.setAttribute("width", svgTextBox.width);
            $svgText.setAttribute("height", svgTextBox.height);
            $svgText.setAttribute("viewBox", svgTextView.x + " " + svgTextView.y + " " + svgTextBox.width + " " + svgTextBox.height);

            // 位置较准
            resetTdTextSizeTrans($gTd);
        }
        // 更新素材source
        updateMaterialSource();
    }

    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (!material || material.type !== 5)
        return;

    newLineHeight = parseFloat(newLineHeight + "");
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = $gWrap.querySelector("svg");
    var $$svg = $gWrap.children;
    while ($$svg.length > 1)
        $gWrap.removeChild($$svg[$$svg.length - 1]);
    var dataType = $svg.getAttribute("data-type");
    if (dataType !== "shape-table")
        return;

    var $activeElem = document.activeElement;
    if ($activeElem.className.includes("tableText-editArea"))
        $activeElem.style.lineHeight = newLineHeight + "px";
    else
        updateTableMaterialLineHeight();
}

/********************************************
************ 文字编辑通用设置 ***************
********************************************/
// 设置每个文字的 data 属性，并依据 wordsList 判断文本特殊性
function setTextMaterialData (material, $curElem)
{
    var list = material.wordsList;
    var paths = Z($curElem).find("g>svg:last-child>g>.font-path");
    if (list.length !== paths.length)
        return;

    var special = false;
    var i, j, $word;
    for (i = 0;i < list.length;i++)
    {
        $word = list[i];
        for (j in $word)
        {
            if (j === "index") continue;
            if (j === "text") {
                paths[i].setAttribute("data-text", $word[j].replace(/</g, '-%6-%-%0-'));
                continue;
            }
            paths[i].setAttribute("data-" + j.toLowerCase(), $word[j]);
            if (!special && $word[j] !== material[j]) {
                special = true;
            }
        }
    }
    if (special) {
        $curElem.setAttribute("data-special","1");
    } else {
        $curElem.removeAttribute("data-special");
    }
}

// 设置文字竖版
function doSetTextVertical(setType)
{
    // 1：判断是否可编辑
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;
    var verticalType = $curElem.getAttribute('data-textvertical') || 'normal';
    if (verticalType === setType)
        return;

    // 1：执行竖版操作
    setTextVerticalLine(setType, material, $curElem);

    // 2：缩放变换
    setTextZoom(null, material, $curElem);

    // 3：对齐
    if (setType === 'normal' && material.textAlign !== 'left')
        setElementAlign(material.textAlign, material, $curElem);

    // 4：选中素材
    selectTheElement(material, $curElem);

    // 5：偏移校准
    editOverSet($curElem);
}
// 竖版排列文字
function setTextVerticalLine(setType, material, $curElem)
{
    // right -> left
    function right2left()
    {
        for (i = 0;i < $$line.length;i++)
            switchLine(i);
    }
    // left -> right
    function left2right()
    {
        for (i = $$line.length - 1;i > -1;i--)
            switchLine(i);
    }
    // left/right -> right/left
    function switchLine(i)
    {
        $line = $$line[i];
        lineBox = $line.getBBox();
        lineTransX += underlineSpace + material.mathHeight;
        $line.setAttribute('transform', 'translate(' + (lineTransX - lineBox.x) + ' 0)');
        lineTransX += lineBox.width;
    }
    // normal -> left
    function normal2left()
    {
        for (i = 0;i < $$line.length;i++) {
            normalTo(i);
        }
    }
    // normal -> right
    function normal2right()
    {
        for (i = $$line.length - 1;i > -1;i--) {
            normalTo(i);
        }
    }
    // normal -> left/right
    function normalTo(i)
    {
        var skew = '';
        $line = $$line[i];
        $$gPath = $line.querySelectorAll('.font-path');
        for (j = 0;j < $$gPath.length;j++)
        {
            $gPath = $$gPath[j];
            pathBox = $gPath.getBBox();
            pathText = $gPath.getAttribute('data-text').replace(/-%6-%-%0-/g, '<');
            pathTrans = $gPath.getAttribute('transform');
            pathTransData = /translate\(([^)\s]+)(?:\s|,)([^)\s]+)/.exec(pathTrans);
			pathTransY = parseFloat(pathTransData[1]);
            pathTransX = parseFloat(pathTransData[2]);
            // 除：汉字，其他字符都要旋转
            if (!/[\u4e00-\u9fa5]/.test(pathText))
            {
                if (pathTrans.indexOf('rotate') === -1) {
                    pathTrans += ' rotate(90 0 0)';
                }
                if (/skewX/.test(pathTrans)) {
                    skew = 'skewY(' + (- parseFloat(/skewX\(([^)]+)\)/.exec(pathTrans)[1])) + ')';
                    pathTrans = pathTrans.replace(/skew[^)]+\)/, skew);
                }
            } else {
                pathTransY -= pathBox.y;
                pathTransY += (pathBox.width - pathBox.height) / 2;
            }
            pathTrans = pathTrans.replace(/translate\([^)]+\)/, 'translate(' + pathTransX + ' ' + pathTransY + ')');
            $gPath.setAttribute('transform', pathTrans);
        }
        lineBox = $line.getBBox();
        lineTransX += underlineSpace + material.mathHeight;
        $line.setAttribute('transform', 'translate(' + (lineTransX - lineBox.x) + ' 0)');
        $line.removeAttribute('data-justify');
        lineTransX += lineBox.width;
    }
    // left/right -> normal
    function all2normal()
    {
        var skew = '';
        for (i = 0;i < $$line.length;i++)
        {
            $line = $$line[i];
            $$gPath = $line.querySelectorAll('.font-path');
            for (j = 0;j < $$gPath.length;j++)
            {
                $gPath = $$gPath[j];
                pathTrans = $gPath.getAttribute('transform');
                pathTrans = pathTrans.replace(/rotate\([^)]+\)/, '').trim();
                pathTransX = parseFloat($gPath.getAttribute('data-x'));
                pathTransX += j * material.letterSpacing;
                pathTrans = pathTrans.replace(/translate\([^)]+\)/, 'translate(' + pathTransX + ' 0)');
                if (/skewY/.test(pathTrans)) {
                    skew = 'skewX(' + (- parseFloat(/skewY\(([^)]+)\)/.exec(pathTrans)[1])) + ')';
                    pathTrans = pathTrans.replace(/skew[^)]+\)/, skew);
                }
                $gPath.setAttribute('transform', pathTrans);
            }
            lineTransY = lineIndex * material.lineHeight + material.textY;
            lineTransX = $line.getAttribute('data-dx');
            lineTransX = lineTransX < 0 ? 0 : lineTransX;
            $line.setAttribute('transform', 'translate(' + lineTransX + ' ' + lineTransY + ')');
            lineIndex++;
        }
    }
    // 分情况处理切换方法
    function changeTextLine()
    {
        lineTransX = 0;
        lineIndex = 0;

        // left/right -> normal
        if (setType === 'normal') all2normal();
        // normal/left -> right
        else if (setType === 'right')
        {
            if (material.textVertical === 'normal')
                normal2right();
            else if (material.textVertical === 'left')
                left2right();
        }
        // normal/right -> left
        else if (setType === 'left')
        {
            if (material.textVertical === 'normal')
                normal2left();
            else if (material.textVertical === 'right')
                right2left();
        }
    }
    // 重设某些文字属性
    function resetTextAttributes()
    {
        //
    }

    // 1：定义变量
    if (material.textVertical === setType)
        return;
    material.letterSpacing = parseFloat(material.letterSpacing);
    material.mathHeight = parseFloat(material.mathHeight);
    material.underlineOffset = parseFloat(material.underlineOffset);
    material.underlineThickness = parseFloat(material.underlineThickness);
    var underlineSpace = material.underlineOffset + material.underlineThickness;
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var $svg = $$svg[0];
    var $rect = $curElem.querySelector('rect');
    var $$line = $svg.children;
    var i, j, $line, lineTransX, lineIndex, lineTransY, $$gPath, $gPath, pathBox, pathTrans, pathTransData,
        pathTransX, pathTransY, pathText, lineBox;

    // 2：去除宽高设置属性
    $rect.setAttribute('width', '1');
    $rect.setAttribute('height', '1');
    $svg.removeAttribute('viewBox');
    $svg.removeAttribute('width');
    $svg.removeAttribute('heihgt');

    // 3：执行文字排版转换
    changeTextLine();

    // 4：重设文字特殊编辑
    resetTextAttributes();

    // 5：重设大小
    var setSvgWidth = $curElem.getBBox().width + '';
    var setSvgHeight = $curElem.getBBox().height;
    if (setType === 'normal')
    {
        var singleMax = Math.max(material.lineHeight, material.singleHeight);
        setSvgHeight = Math.max(material.lineHeight * ($$line.length - 1) + singleMax, setSvgHeight);
    }
    setSvgHeight = setSvgHeight + '';
    $rect.setAttribute('width', setSvgWidth);
    $rect.setAttribute('height', setSvgHeight);
    $svg.setAttribute('viewBox', '0 0 ' + setSvgWidth + ' ' + setSvgHeight);
    $svg.setAttribute('width', setSvgWidth);
    $svg.setAttribute('height', setSvgHeight);

    // 6：完成切换，赋值
    material.textVertical = setType;
    $curElem.setAttribute('data-textvertical', setType);

    // 7：文字特效
    doTextSpecialSet();
}

// 初始化 wordList
function initWordsListFromMaterial (material)
{
    material.wordsList = [];
    var words = material.text.replace(/(-%5-%-%5-)|(\n)/g,"");
    for (var i = 0;i < words.length;i++) {
        material.wordsList.push({
            "color": material.color,
            "fontFamily": material.fontFamily,
            "fontSize": material.fontSize,
            "fontWeight": material.fontWeight,
            "fontItalic": material.fontItalic,
            "textDecoration": material.textDecoration,
            "text": words[i],
            "index": i,
        });
    }
}

/********************************************
************* 文字编辑框显示 ****************
********************************************/
/** 文字素材宽度检测 **/
function textMaterialWidthReset(material)
{
    function getWordWidth(word)
    {// 获取指定文字的宽度
        var $newFont = Z('<span style="z-index: -999;opacity: 0;">' + word + '</span>');
        var fontSizePX = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 0) {
            fontSizePX = pt2px(fontSizePX);
        }
        $newFont.appendTo(document.documentElement);
        $newFont.css({
            'fontFamily' : material.fontFamily,
            'fontSize' : fontSizePX,
            'fontStyle' : material.fontStyle,
            'letterSpacing' : material.letterSpacing,
        });
        var fontWidth = $newFont[0].getBoundingClientRect().width;
        $newFont.remove();
        return fontWidth;
    }
    var $canvasSvg = media.tool.$canvasSvg;
    var bleedWidth = mm2px(media.canvas.bleedSize, media.canvas.dpi);
    // 出去出血的有效宽度
    var maxWidth = $canvasSvg.viewBox.baseVal.width - 2 * bleedWidth;
    var textArr = material.text.split('\n');
    var totalWidth = 0, i = 0, j = 0, newArr = [], newWords = '';
    var $$line, wordWidth;
    // 有效宽度的 100%
    maxWidth *= 1;
    for (i = 0;i < textArr.length;i++)
    {
        $$line = textArr[i];
        for (j = 0; j < $$line.length;j++)
        {
            wordWidth = getWordWidth($$line[j]);
            totalWidth += getWordWidth($$line[j]);
            if (totalWidth >= maxWidth) {
                newArr.push(newWords);
                newArr.push('-%5-%-%5-');
                newWords = '';
                totalWidth = wordWidth;
            }
            newWords += $$line[j];
        }
        newArr.push(newWords);
        newArr.push('\n');
        newWords = '';
        totalWidth = 0;
    }

    return newArr.join('').trim();
};