/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.task;

import com.zhiqim.media.service.cdr.CdrImport;
import com.zhiqim.media.service.cdr.CdrOrderAtta;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.httpclient.HttpDownload;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class CdrBatchImportTimer
implements Task {
    private static final Log log = LogFactory.getLog(CdrBatchImportTimer.class);

    public void execute() {
        String cdrDir = Global.getString((String)"cdr", (String)"cdrDir");
        String cdrDestDir = Global.getString((String)"cdr", (String)"cdrDestDir");
        if (cdrDestDir == null) {
            log.error((Object)"Cdr\u6279\u91cf\u5bfc\u5165\u4efb\u52a1\u4efb\u52a1\u672a\u914d\u7f6e\u56fe\u7247\u5b58\u50a8\u76ee\u5f55...");
            return;
        }
        log.info((Object)"Cdr\u6279\u91cf\u5bfc\u5165\u4efb\u52a1\u4efb\u52a1\u5f00\u59cb...");
        Selector selector = new Selector();
        selector.addMaybe("fileType", (Object)"cdr");
        selector.addMaybe("attaModul", (Object)"DesginFile");
        selector.addMaybeNotEqual("uploadType", (Object)9);
        List cdrOrderList = new ArrayList();
        try {
            cdrOrderList = ((ZTable)ORM.get(ZTable.class)).list(CdrOrderAtta.class, selector);
        }
        catch (Exception exception) {
            log.error((Object)"Cdr\u6279\u91cf\u5bfc\u5165\u4efb\u52a1\u67e5\u8be2\u6570\u636e\u5f02\u5e38...");
        }
        CdrImport cdrImport = new CdrImport(cdrDestDir);
        cdrImport.start();
        int count = 0;
        for (CdrOrderAtta order : cdrOrderList) {
            float fileSize;
            int index = order.getFileSize().indexOf("MiB");
            if (index != -1 && (fileSize = Float.parseFloat(order.getFileSize().substring(0, index).trim())) > 20.0f || order.getUploadType() != 0) continue;
            String url = "http://erp.xwyin.cn/downEndFile.htm?attaId=" + order.getAttaId();
            HttpDownload conn = new HttpDownload(url);
            conn.setFileDir(Strings.addEndsWith((String)cdrDir, (String)"/"));
            conn.setFileName(String.valueOf(order.getAttaId()) + ".cdr");
            conn.execute();
            if (!conn.isResponseSuccess()) {
                this.update(order.getAttaId(), 7);
                log.error((Object)"Cdr\u6279\u91cf\u5bfc\u5165\u4efb\u52a1\u67e5\u8be2\u6570\u636e\u5f02\u5e38...");
                continue;
            }
            String filePath = String.valueOf(Strings.addEndsWith((String)cdrDir, (String)"/")) + order.getAttaId() + ".cdr";
            try {
                boolean isSuccess = cdrImport.excute(filePath);
                if (isSuccess) {
                    this.update(order.getAttaId(), 9);
                } else {
                    this.update(order.getAttaId(), 8);
                }
            }
            catch (Exception exception) {
                continue;
            }
            if (++count % 10 != 0) continue;
            try {
                cdrImport.stop();
                Thread.sleep(3000L);
                cdrImport.start();
                log.error((Object)"CorelDraw\u91cd\u542f\u6210\u529f\uff01");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        cdrImport.stop();
        log.info((Object)("Cdr\u6279\u91cf\u5bfc\u5165\u4efb\u52a1\u5904\u7406\u7ed3\u675f\uff0c\u5171\u5904\u7406[" + cdrOrderList.size() + "]\u6761\u6570\u636e"));
    }

    private void update(long attaId, int uploadType) {
        try {
            Updater updater = new Updater();
            updater.addMust("attaId", (Object)attaId);
            updater.addField("uploadType", (Object)uploadType);
            ((ZTable)ORM.get(ZTable.class)).update(CdrOrderAtta.class, updater);
        }
        catch (Exception exception) {
            log.error((Object)"Cdr\u6279\u91cf\u5bfc\u5165\u4efb\u52a1\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38...");
        }
    }
}

