/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.svg;

import com.zhiqim.media.service.svg.MediaSvgDocument;
import com.zhiqim.media.service.svg.MediaSvgElement;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Strings;

public class MediaSvgBg
extends MediaSvgElement {
    private MediaSvgDocument mediaSvgDoc;
    private Element node = null;
    private int bgType = 0;
    private Map<String, String> attributeMap = new HashMap<String, String>();

    public MediaSvgBg(String svgCode) {
        super(svgCode);
    }

    public MediaSvgBg(MediaSvgDocument mediaSvgDoc, Element node) {
        super(null);
        this.mediaSvgDoc = mediaSvgDoc;
        this.document = mediaSvgDoc.getDocument();
        this.node = node;
    }

    public MediaSvgDocument getMediaSvgDoc() {
        return this.mediaSvgDoc;
    }

    @Override
    public void parse() {
        Element g = this.node;
        if (g == null) {
            g = this.getChildNode(this.document, "g");
        }
        Element svg = this.getChildNode(g, "svg");
        Element image = this.getChildNode(svg, "image");
        Element subG = this.getChildNode(svg, "g");
        if (image != null) {
            this.bgType = 1;
            this.attributeMap.put("preserveAspectRatio", "none");
            this.attributeMap.put("width", svg.getAttribute("width"));
            this.attributeMap.put("height", svg.getAttribute("height"));
            this.attributeMap.put("xlink:href", image.getAttribute("xlink:href"));
        } else if (subG == null) {
            Element rect = this.getChildNode(svg, "rect");
            this.attributeMap.put("width", svg.getAttribute("width"));
            this.attributeMap.put("height", svg.getAttribute("height"));
            this.attributeMap.put("fill", rect.getAttribute("fill"));
        } else {
            this.bgType = 2;
            float w = Float.parseFloat(svg.getAttribute("width"));
            float h = Float.parseFloat(svg.getAttribute("height"));
            String viewBox = svg.getAttribute("viewBox");
            String[] vbs = Strings.split((String)viewBox, (String)" ");
            float width = Float.parseFloat(vbs[2]);
            float height = Float.parseFloat(vbs[3]);
            float sx = w / width;
            float sy = h / height;
            float[] flatmatrix = new float[]{sx, 0.0f, 0.0f, sy, 0.0f, 0.0f};
            String transform = "matrix(" + Arrays.toString((float[])flatmatrix, (String)" ") + ")";
            this.attributeMap.put("transform", transform);
        }
    }

    @Override
    public Element toElement() {
        if (this.bgType == 0) {
            Element ele = this.document.createElement("rect");
            for (String key : this.attributeMap.keySet()) {
                ele.setAttribute(key, this.attributeMap.get(key));
            }
            return ele;
        }
        if (this.bgType == 1) {
            Element ele = this.document.createElement("image");
            for (String key : this.attributeMap.keySet()) {
                ele.setAttribute(key, this.attributeMap.get(key));
            }
            return ele;
        }
        Element ele = this.document.createElement("g");
        for (String key : this.attributeMap.keySet()) {
            ele.setAttribute(key, this.attributeMap.get(key));
        }
        Element g = this.node;
        if (g == null) {
            g = this.getChildNode(this.document, "g");
        }
        Element svg = this.getChildNode(g, "svg");
        NodeList nodelist = svg.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node child = nodelist.item(i);
            if (child.getNodeType() == 1) {
                ele.appendChild(child);
            }
            ++i;
        }
        return ele;
    }

    public String toXml() {
        Element element = this.toElement();
        return super.toXml(element);
    }
}

