/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.model;

import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.MediaCoverMaterial;
import com.zhiqim.media.dbo.MediaMaterial;
import com.zhiqim.media.dbo.MediaMaterialParam;
import com.zhiqim.media.dbo.MediaMaterialParamEx;
import com.zhiqim.media.dbo.MediaParam;
import com.zhiqim.media.service.cache.MediaParamCache;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.util.Objects;
import org.zhiqim.kernel.util.Validates;

public class MediaModel {
    private MediaCanvas canvas;
    private MediaBg[] bgList;
    private MediaMaterialParamEx[] materialList;
    private MediaCoverMaterial[] coverMaterialList;

    public MediaModel() {
    }

    public MediaModel(MediaCanvas canvas, List<MediaBg> bgList, List<MediaMaterialParamEx> materialList, List<MediaCoverMaterial> coverMaterialList) {
        this.canvas = canvas;
        this.setBgList(bgList);
        this.setMaterialList(materialList);
        this.setCoverMaterialList(coverMaterialList);
    }

    public MediaCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(MediaCanvas canvas) {
        this.canvas = canvas;
    }

    public List<MediaBg> getBgList() {
        ArrayList<MediaBg> list = new ArrayList<MediaBg>();
        MediaBg[] mediaBgArray = this.bgList;
        int n = this.bgList.length;
        int n2 = 0;
        while (n2 < n) {
            MediaBg bg = mediaBgArray[n2];
            list.add(bg);
            ++n2;
        }
        return list;
    }

    public void setBgList(List<MediaBg> bgList) {
        this.bgList = new MediaBg[bgList.size()];
        int i = 0;
        while (i < bgList.size()) {
            this.bgList[i] = bgList.get(i);
            ++i;
        }
    }

    public void setMaterialList(List<MediaMaterialParamEx> materialList) {
        this.materialList = new MediaMaterialParamEx[materialList.size()];
        int i = 0;
        while (i < materialList.size()) {
            this.materialList[i] = materialList.get(i);
            ++i;
        }
    }

    public void setCoverMaterialList(List<MediaCoverMaterial> coverMaterialList) {
        this.coverMaterialList = new MediaCoverMaterial[coverMaterialList.size()];
        int i = 0;
        while (i < coverMaterialList.size()) {
            this.coverMaterialList[i] = coverMaterialList.get(i);
            ++i;
        }
    }

    public List<MediaMaterialParamEx> getMaterialList() {
        ArrayList<MediaMaterialParamEx> list = new ArrayList<MediaMaterialParamEx>();
        MediaMaterialParamEx[] mediaMaterialParamExArray = this.materialList;
        int n = this.materialList.length;
        int n2 = 0;
        while (n2 < n) {
            MediaMaterialParamEx material = mediaMaterialParamExArray[n2];
            list.add(material);
            ++n2;
        }
        return list;
    }

    public List<MediaCoverMaterial> getCoverMaterialList() {
        ArrayList<MediaCoverMaterial> list = new ArrayList<MediaCoverMaterial>();
        MediaCoverMaterial[] mediaCoverMaterialArray = this.coverMaterialList;
        int n = this.coverMaterialList.length;
        int n2 = 0;
        while (n2 < n) {
            MediaCoverMaterial coverMaterial = mediaCoverMaterialArray[n2];
            list.add(coverMaterial);
            ++n2;
        }
        return list;
    }

    public MediaMaterialParamEx getMaterial(int bid, int mid) {
        MediaMaterialParamEx[] mediaMaterialParamExArray = this.materialList;
        int n = this.materialList.length;
        int n2 = 0;
        while (n2 < n) {
            MediaMaterialParamEx param = mediaMaterialParamExArray[n2];
            if (param.getBid() == bid && param.getMid() == mid) {
                return param;
            }
            ++n2;
        }
        return null;
    }

    public List<MediaMaterial> getMediaMaterialList() {
        ArrayList<MediaMaterial> mlist = new ArrayList<MediaMaterial>();
        MediaMaterialParamEx[] mediaMaterialParamExArray = this.materialList;
        int n = this.materialList.length;
        int n2 = 0;
        while (n2 < n) {
            MediaMaterialParamEx materialEx = mediaMaterialParamExArray[n2];
            MediaMaterial m = new MediaMaterial();
            Objects.copyDeep((Object)materialEx, (Object)m);
            mlist.add(m);
            ++n2;
        }
        return mlist;
    }

    public List<MediaCoverMaterial> getCoverMediaMaterialList() {
        ArrayList<MediaCoverMaterial> cmlist = new ArrayList<MediaCoverMaterial>();
        MediaCoverMaterial[] mediaCoverMaterialArray = this.coverMaterialList;
        int n = this.coverMaterialList.length;
        int n2 = 0;
        while (n2 < n) {
            MediaCoverMaterial coverMaterial = mediaCoverMaterialArray[n2];
            MediaCoverMaterial m = new MediaCoverMaterial();
            Objects.copyDeep((Object)coverMaterial, (Object)m);
            cmlist.add(m);
            ++n2;
        }
        return cmlist;
    }

    public List<MediaMaterialParam> getMaterialParamList() {
        ArrayList<MediaMaterialParam> plist = new ArrayList<MediaMaterialParam>();
        MediaMaterialParamEx[] mediaMaterialParamExArray = this.materialList;
        int n = this.materialList.length;
        int n2 = 0;
        while (n2 < n) {
            MediaMaterialParamEx materialEx = mediaMaterialParamExArray[n2];
            if (Validates.isNotEmpty((String)materialEx.getParamKey())) {
                MediaMaterialParam param = new MediaMaterialParam();
                param.setMediaId(materialEx.getMediaId());
                param.setBid(materialEx.getBid());
                param.setMid(materialEx.getMid());
                param.setParamKey(materialEx.getParamKey());
                param.setParamName(materialEx.getParamName());
                MediaParam mParam = ((MediaParamCache)Global.get(MediaParamCache.class)).item(this.canvas.getMediaType(), param.getParamKey());
                param.setParamType(mParam == null ? 0 : mParam.getParamType());
                plist.add(param);
            }
            ++n2;
        }
        return plist;
    }
}

