/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.dao;

import com.baidu.aip.nlp.AipNlp;
import com.baidu.aip.ocr.AipOcr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.consts.Str;

public class BaiduDao {
    public static final String APP_ID = Global.getString((String)"baidu", (String)"appId", (String)"20172700");
    public static final String API_KEY = Global.getString((String)"baidu", (String)"appKey", (String)"f0MDrkGuOEnN7VBXm8efdDQB");
    public static final String SECRET_KEY = Global.getString((String)"baidu", (String)"appSecret", (String)"etKiDgKiBGCxIuZQ33F8GmYNx6FDFngf");
    public static final Str NAME = new Str("PER", "\u59d3\u540d");
    public static final Str MOBILE = new Str("MOB", "\u624b\u673a");
    public static final Str PHONE = new Str("PHONE", "\u56fa\u5b9a\u7535\u8bdd");
    public static final Str ADDR = new Str("LOC", "\u516c\u53f8\u5730\u5740");
    public static final Str ORG = new Str("ORG", "\u516c\u53f8\u540d\u79f0");
    public static final Map<String, Str> dataMap = new HashMap<String, Str>();

    static {
        dataMap.put(NAME.value(), NAME);
        dataMap.put(MOBILE.value(), MOBILE);
        dataMap.put(PHONE.value(), PHONE);
        dataMap.put(ADDR.value(), ADDR);
        dataMap.put(ORG.value(), ORG);
    }

    public static Map<String, List<String>> parseText(String text) throws Exception {
        AipNlp client = new AipNlp(APP_ID, API_KEY, SECRET_KEY);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        text = text.replace(" ", "");
        text = text.replace("\r\n", "/");
        JSONObject res = client.lexerCustom(text = text.replace("\n", "/"), null);
        if (res.has("error_code")) {
            throw new Exception("\u767e\u5ea6\u8bcd\u6cd5\u5206\u6790\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + res.getString("error_msg"));
        }
        JSONArray arr = res.getJSONArray("items");
        int i = 0;
        while (i < arr.length()) {
            JSONObject item = arr.getJSONObject(i);
            String key = item.getString("ne").trim();
            if (!Validates.isEmpty((String)key)) {
                String value = item.getString("item");
                if (map.containsKey(key)) {
                    ((List)map.get(key)).add(value);
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(value);
                    map.put(key, list);
                }
            }
            ++i;
        }
        return map;
    }

    public static List<String> parseText2(String text) throws Exception {
        Map<String, List<String>> map = BaiduDao.parseText(text);
        ArrayList<String> dataList = new ArrayList<String>();
        for (String key : map.keySet()) {
            List<String> list = map.get(key);
            if (ADDR.value().equals(key)) {
                dataList.add(String.valueOf(ADDR.desc()) + ":" + Lists.toString(list, (String)""));
                continue;
            }
            dataList.add(String.valueOf(dataMap.get(key).desc()) + ":" + list.get(0));
        }
        return dataList;
    }

    public static List<String> generalOcr(String path) throws Exception {
        AipOcr client = new AipOcr(APP_ID, API_KEY, SECRET_KEY);
        client.setConnectionTimeoutInMillis(2000);
        client.setSocketTimeoutInMillis(60000);
        JSONObject res = client.basicGeneral(path, new HashMap());
        if (res.has("error_code")) {
            throw new Exception("\u767e\u5ea6\u666e\u901a\u8bc6\u522b\u56fe\u7247\u522b\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + res.getString("error_msg"));
        }
        JSONArray arr = res.getJSONArray("words_result");
        ArrayList<String> dataList = new ArrayList<String>();
        int i = 0;
        while (i < arr.length()) {
            JSONObject item = arr.getJSONObject(i);
            dataList.add(item.getString("words"));
            ++i;
        }
        return dataList;
    }

    public static void main(String[] args) throws Exception {
        String text = "D:\\111.png";
        List<String> list = BaiduDao.generalOcr(text);
        System.out.println(list);
    }
}

