/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.Dispatch;
import com.zhiqim.media.service.cdr.Application;
import com.zhiqim.media.service.cdr.CdrDispatch;
import com.zhiqim.media.service.util.UnitUtil;

public class TextRange
extends CdrDispatch {
    private String text;
    private String font;
    private float wordSpacing;
    private float lineSpacing;
    private float size;
    private int alignment;
    private int charSet;
    private int underline;
    private boolean italic;
    private boolean bold;

    public TextRange(Application application, Dispatch dispatch) {
        super(application, dispatch);
        this.parse();
    }

    @Override
    protected void parseComposite() {
        this.dispatch.safeRelease();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getFont() {
        if (this.font == null) {
            return "\u5fae\u8f6f\u96c5\u9ed1";
        }
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public float getWordSpacing() {
        return this.wordSpacing;
    }

    public void setWordSpacing(float wordSpacing) {
        this.wordSpacing = wordSpacing;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public float getSize() {
        if (this.size < 5.0f) {
            return 10.0f;
        }
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getCharSet() {
        return this.charSet;
    }

    public void setCharSet(int charSet) {
        this.charSet = charSet;
    }

    public int getUnderline() {
        return this.underline;
    }

    public void setUnderline(int underline) {
        this.underline = underline;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("<tspan ").append("font-family=\"").append(this.font).append("\" ").append("font-size=\"").append(UnitUtil.point2pixel(this.size, 300)).append("\" ").append("word-spacing=\"").append(this.wordSpacing).append("\" ").append("line-spacing=\"").append(this.lineSpacing).append("\" ").append(">").append(this.text).append("</tspan>");
        return strb.toString();
    }
}

