/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.zhiqim.media.service.cdr.Application;
import com.zhiqim.media.service.cdr.CdrConstants;
import com.zhiqim.media.service.cdr.CdrDispatch;
import com.zhiqim.media.service.cdr.Page;
import com.zhiqim.media.service.cdr.Shape;
import com.zhiqim.media.service.cdr.ShapeRange;
import com.zhiqim.media.service.util.UnitUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.util.Files;

public class Document
extends CdrDispatch
implements CdrConstants {
    private int resolution;
    private int unit;
    private ShapeRange shapeRange;
    private int cardType = -1;
    private double pageWidth = 0.0;
    private double pageHeight = 0.0;
    private double pageWidthMm = 0.0;
    private double pageHeightMm = 0.0;
    private double sizeWidth = 0.0;
    private double sizeHeight = 0.0;

    public Document(Application app, Dispatch dispatch) {
        super(app, dispatch);
    }

    @Override
    protected void parseComposite() {
    }

    @Override
    public void parse() {
        this.setPixelUnit();
        this.resizePage();
        this.extract();
        this.updateShapeRange();
        this.shapeRange.parseAllshapes();
    }

    public boolean isSimpleCard() {
        this.setMmUnit();
        this.deleteSurplusShape();
        Dispatch dispatchSelectableShapes = Dispatch.call((Dispatch)this.dispatch, (String)"SelectableShapes").getDispatch();
        Dispatch dispatchShapeRange = Dispatch.call((Dispatch)dispatchSelectableShapes, (String)"All").getDispatch();
        this.sizeWidth = Dispatch.call((Dispatch)dispatchShapeRange, (String)"SizeWidth").getDouble();
        this.sizeHeight = Dispatch.call((Dispatch)dispatchShapeRange, (String)"SizeHeight").getDouble();
        if (Math.abs(this.sizeWidth - 92.0) < 4.0 || Math.abs(this.sizeWidth - 88.0) < 4.0) {
            if (Math.abs(this.sizeWidth - 92.0) < Math.abs(this.sizeWidth - 88.0)) {
                this.cardType = 1;
                this.pageWidth = UnitUtil.mm2pixel(92.0, 300);
                this.pageHeight = UnitUtil.mm2pixel(56.0, 300);
                this.pageWidthMm = 92.0;
                this.pageHeightMm = 56.0;
                return true;
            }
            this.cardType = 1;
            this.pageWidth = UnitUtil.mm2pixel(88.0, 300);
            this.pageHeight = UnitUtil.mm2pixel(57.0, 300);
            this.pageWidthMm = 88.0;
            this.pageHeightMm = 57.0;
            return true;
        }
        if (Math.abs(this.sizeWidth - 56.0) < 4.0 || Math.abs(this.sizeWidth - 57.0) < 4.0) {
            if (Math.abs(this.sizeWidth - 56.0) < Math.abs(this.sizeWidth - 57.0)) {
                this.cardType = 3;
                this.pageWidth = UnitUtil.mm2pixel(56.0, 300);
                this.pageHeight = UnitUtil.mm2pixel(92.0, 300);
                this.pageWidthMm = 56.0;
                this.pageHeightMm = 92.0;
                return true;
            }
            this.cardType = 3;
            this.pageWidth = UnitUtil.mm2pixel(57.0, 300);
            this.pageHeight = UnitUtil.mm2pixel(88.0, 300);
            this.pageWidthMm = 57.0;
            this.pageHeightMm = 88.0;
            return true;
        }
        if (Math.abs(this.sizeHeight - 92.0) < 4.0 || Math.abs(this.sizeHeight - 88.0) < 4.0) {
            if (Math.abs(this.sizeHeight - 92.0) < Math.abs(this.sizeHeight - 88.0)) {
                this.cardType = 2;
                this.pageWidth = UnitUtil.mm2pixel(56.0, 300);
                this.pageHeight = UnitUtil.mm2pixel(92.0, 300);
                this.pageWidthMm = 56.0;
                this.pageHeightMm = 92.0;
                return true;
            }
            this.cardType = 2;
            this.pageWidth = UnitUtil.mm2pixel(57.0, 300);
            this.pageHeight = UnitUtil.mm2pixel(88.0, 300);
            this.pageWidthMm = 57.0;
            this.pageHeightMm = 88.0;
            return true;
        }
        if (Math.abs(this.sizeHeight - 56.0) < 4.0 || Math.abs(this.sizeHeight - 57.0) < 4.0) {
            if (Math.abs(this.sizeHeight - 56.0) < Math.abs(this.sizeHeight - 57.0)) {
                this.cardType = 0;
                this.pageWidth = UnitUtil.mm2pixel(92.0, 300);
                this.pageHeight = UnitUtil.mm2pixel(56.0, 300);
                this.pageWidthMm = 92.0;
                this.pageHeightMm = 56.0;
                return true;
            }
            this.cardType = 0;
            this.pageWidth = UnitUtil.mm2pixel(88.0, 300);
            this.pageHeight = UnitUtil.mm2pixel(57.0, 300);
            this.pageWidthMm = 88.0;
            this.pageHeightMm = 57.0;
            return true;
        }
        return false;
    }

    public void deleteSurplusShape() {
        int count;
        Dispatch dispatchSelectableShapes = Dispatch.call((Dispatch)this.dispatch, (String)"SelectableShapes").getDispatch();
        Dispatch dispatchShapeRange = Dispatch.call((Dispatch)dispatchSelectableShapes, (String)"All").getDispatch();
        Dispatch dispatchShapes = Dispatch.get((Dispatch)dispatchShapeRange, (String)"Shapes").toDispatch();
        int i = count = Dispatch.get((Dispatch)dispatchShapes, (String)"Count").getInt();
        while (i >= 1) {
            Dispatch dispatchShape = Dispatch.invoke((Dispatch)dispatchShapes, (String)"Item", (int)2, (Object[])new Object[]{new Variant(i)}, (int[])new int[1]).toDispatch();
            int type = Dispatch.get((Dispatch)dispatchShape, (String)"Type").getInt();
            if (type == 9) {
                Dispatch.call((Dispatch)dispatchShape, (String)"Delete");
            } else if (type == 1) {
                double sizeWidth = Dispatch.get((Dispatch)dispatchShape, (String)"SizeWidth").getDouble();
                double sizeHeight = Dispatch.get((Dispatch)dispatchShape, (String)"SizeHeight").getDouble();
                if (sizeWidth > 100.0 || sizeHeight > 100.0) {
                    Dispatch.call((Dispatch)dispatchShape, (String)"Delete");
                }
            }
            --i;
        }
        dispatchShapes.safeRelease();
        dispatchShapeRange.safeRelease();
        dispatchSelectableShapes.safeRelease();
    }

    public void extract() {
        int count;
        Dispatch dispatchSelectableShapes = Dispatch.call((Dispatch)this.dispatch, (String)"SelectableShapes").getDispatch();
        Dispatch dispatchShapeRange = Dispatch.call((Dispatch)dispatchSelectableShapes, (String)"All").getDispatch();
        Dispatch dispatchShapes = Dispatch.get((Dispatch)dispatchShapeRange, (String)"Shapes").toDispatch();
        int i = count = Dispatch.get((Dispatch)dispatchShapes, (String)"Count").getInt();
        while (i >= 1) {
            Dispatch dispatchShape = Dispatch.invoke((Dispatch)dispatchShapes, (String)"Item", (int)2, (Object[])new Object[]{new Variant(i)}, (int[])new int[1]).toDispatch();
            int type = Dispatch.get((Dispatch)dispatchShape, (String)"Type").getInt();
            if (type == 1) {
                Dispatch dispatchPowerClip = Dispatch.get((Dispatch)dispatchShape, (String)"PowerClip").toDispatch();
                if (dispatchPowerClip.m_pDispatch != 0L) {
                    Dispatch.call((Dispatch)dispatchPowerClip, (String)"ExtractShapes");
                }
            }
            --i;
        }
        dispatchShapes.safeRelease();
        dispatchShapeRange.safeRelease();
        dispatchSelectableShapes.safeRelease();
    }

    public void resizePage() {
        Dispatch dispatchSelectableShapes = Dispatch.call((Dispatch)this.dispatch, (String)"SelectableShapes").getDispatch();
        Dispatch dispatchShapeRange = Dispatch.call((Dispatch)dispatchSelectableShapes, (String)"All").getDispatch();
        ShapeRange shapeRange = new ShapeRange(this.application, dispatchShapeRange);
        this.sizeWidth = shapeRange.getSizeWidth();
        this.sizeHeight = shapeRange.getSizeHeight();
        this.setShapeRange(shapeRange);
        Dispatch dispatchPages = Dispatch.call((Dispatch)this.dispatch, (String)"Pages").toDispatch();
        Dispatch dispatchPage = Dispatch.call((Dispatch)dispatchPages, (String)"First").toDispatch();
        Page page = new Page(this.application, dispatchPage);
        page.resize();
        page.safeRelease();
        dispatchPages.safeRelease();
    }

    public void updateShapeRange() {
        Dispatch dispatchSelectableShapes = Dispatch.call((Dispatch)this.dispatch, (String)"SelectableShapes").getDispatch();
        Dispatch dispatchShapeRange = Dispatch.call((Dispatch)dispatchSelectableShapes, (String)"All").getDispatch();
        ShapeRange shapeRange = new ShapeRange(this.application, dispatchShapeRange);
        this.setShapeRange(shapeRange);
    }

    public void exportSelection(String path, int cdrFilter, Dispatch exportOptions) {
        Dispatch exportFilter = Dispatch.call((Dispatch)this.dispatch, (String)"ExportEx", (Object[])new Object[]{path, cdrFilter, 2, exportOptions, this.getNothingVariant()}).toDispatch();
        Dispatch.call((Dispatch)exportFilter, (String)"Finish");
        exportFilter.safeRelease();
        exportOptions.safeRelease();
    }

    public void clearSelection() {
        Dispatch.call((Dispatch)this.dispatch, (String)"ClearSelection");
    }

    public void save() {
        Dispatch.call((Dispatch)this.dispatch, (String)"Save");
    }

    public void revert() {
        Dispatch.call((Dispatch)this.dispatch, (String)"Revert");
    }

    public void close() {
        Dispatch.call((Dispatch)this.dispatch, (String)"Close");
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public void setPixelUnit() {
        Dispatch.put((Dispatch)this.dispatch, (String)"Unit", (Object)5);
    }

    public void setMmUnit() {
        Dispatch.put((Dispatch)this.dispatch, (String)"Unit", (Object)3);
    }

    public ShapeRange getShapeRange() {
        return this.shapeRange;
    }

    public void setShapeRange(ShapeRange shapeRange) {
        this.shapeRange = shapeRange;
    }

    public int getCardType() {
        return this.cardType;
    }

    public void setCardType(int cardType) {
        this.cardType = cardType;
    }

    public double getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(double pageWidth) {
        this.pageWidth = pageWidth;
    }

    public double getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(double pageHeight) {
        this.pageHeight = pageHeight;
    }

    public double getPageWidthMm() {
        return this.pageWidthMm;
    }

    public void setPageWidthMm(double pageWidthMm) {
        this.pageWidthMm = pageWidthMm;
    }

    public double getPageHeightMm() {
        return this.pageHeightMm;
    }

    public void setPageHeightMm(double pageHeightMm) {
        this.pageHeightMm = pageHeightMm;
    }

    public boolean isInFirstPage(Shape shape) {
        if (this.cardType == 0 || this.cardType == 2) {
            return shape.getRotationCenterX() < this.pageWidth;
        }
        if (this.cardType == 1 || this.cardType == 3) {
            return -shape.getRotationCenterY() < this.pageHeight;
        }
        return false;
    }

    public double getRealX(Shape shape) {
        if (this.isInFirstPage(shape)) {
            return shape.getLeftX();
        }
        if (this.cardType == 0 || this.cardType == 2) {
            return shape.getLeftX() - (this.sizeWidth - this.pageWidth);
        }
        return shape.getLeftX();
    }

    public double getRealX(Shape shape, double x) {
        if (this.isInFirstPage(shape)) {
            return x;
        }
        if (this.cardType == 0 || this.cardType == 2) {
            return x - (this.sizeWidth - this.pageWidth);
        }
        return x;
    }

    public double getRealY(Shape shape) {
        if (this.isInFirstPage(shape)) {
            return -shape.getTopY();
        }
        if (this.cardType == 1 || this.cardType == 3) {
            return -shape.getTopY() - (this.sizeHeight - this.pageHeight);
        }
        return -shape.getTopY();
    }

    public double getRealY(Shape shape, double y) {
        if (this.isInFirstPage(shape)) {
            return y;
        }
        if (this.cardType == 1 || this.cardType == 3) {
            return y - (this.sizeHeight - this.pageHeight);
        }
        return y;
    }

    public Map<Integer, List<Shape>> getShapeMap() {
        HashMap<Integer, List<Shape>> map = new HashMap<Integer, List<Shape>>();
        map.put(0, new ArrayList());
        map.put(1, new ArrayList());
        this.shapeRange.getShapeMap(map);
        return map;
    }

    public void out2Files() {
        Map<Integer, List<Shape>> map = this.getShapeMap();
        for (int key : map.keySet()) {
            List<Shape> shapeList = map.get(key);
            StringBuffer strb = new StringBuffer();
            strb.append("<svg ").append("width=\"").append(this.pageWidth).append("\" ").append("height=\"").append(this.pageHeight).append("\" ").append("viewBox=\"0 0 ").append(this.pageWidth).append(" ").append(this.pageHeight).append("\" ").append("xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"").append(">");
            for (Shape shape : shapeList) {
                strb.append(shape.toSvg());
            }
            strb.append("</svg>");
            String filepath = String.valueOf(this.application.getFileDestDir()) + this.application.getFileName() + "_" + key + ".svg";
            Files.writeUTF8((String)filepath, (String)strb.toString());
        }
    }
}

