/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.zhiqim.media.service.cdr.Application;
import com.zhiqim.media.service.cdr.CdrDispatch;
import com.zhiqim.media.service.cdr.Shape;
import com.zhiqim.media.service.cdr.SubPath;
import java.util.ArrayList;
import java.util.List;

public class Curve
extends CdrDispatch {
    private List<SubPath> subPathList = new ArrayList<SubPath>();
    private Shape shape;

    public Curve(Application application, Dispatch dispatch, Shape shape) {
        super(application, dispatch);
        this.shape = shape;
        this.parse();
    }

    @Override
    protected void parseComposite() {
        Dispatch subPaths = Dispatch.get((Dispatch)this.dispatch, (String)"SubPaths").toDispatch();
        int count = Dispatch.get((Dispatch)subPaths, (String)"Count").getInt();
        int i = 1;
        while (i <= count) {
            Dispatch dispatchSubPath = Dispatch.invoke((Dispatch)subPaths, (String)"Item", (int)2, (Object[])new Object[]{new Variant(i)}, (int[])new int[1]).toDispatch();
            SubPath subpath = new SubPath(this.application, dispatchSubPath, this.shape);
            this.subPathList.add(subpath);
            ++i;
        }
    }

    public List<SubPath> getSubPathList() {
        return this.subPathList;
    }

    public void setSubPathList(List<SubPath> subPathList) {
        this.subPathList = subPathList;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public String toSvg() {
        StringBuffer strb = new StringBuffer();
        strb.append("<path fill=\"" + this.shape.getFill() + "\" ").append("d=\"");
        for (SubPath path : this.subPathList) {
            strb.append(path.toSvg());
        }
        strb.append("\" ").append("/>");
        return strb.toString();
    }
}

