/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.ComThread;
import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.MediaMaterial;
import com.zhiqim.media.service.cdr.Application;
import com.zhiqim.media.service.cdr.Document;
import com.zhiqim.media.service.cdr.Shape;
import com.zhiqim.media.service.dao.MediaPathDao;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.uploadlarge.dbo.UpllFile;

public class CdrImport {
    private static final Log log = LogFactory.getLog(CdrImport.class);
    private Application app;
    private String cdrDestDir;
    private long mediaId;

    public CdrImport(String destDir) {
        this.cdrDestDir = destDir;
    }

    public void start() {
        ComThread.InitSTA();
        if (this.app == null) {
            this.app = new Application();
        }
        this.app.setDestDir(this.cdrDestDir);
        this.app.start();
    }

    public void reStart() {
        ComThread.Release();
        ComThread.InitSTA();
        this.app.getActiveXcom().safeRelease();
        this.app.start();
    }

    public void stop() {
        this.app.quit();
        this.app = null;
        ComThread.Release();
    }

    public boolean excute(String filePath) {
        Document doc;
        block18: {
            block19: {
                doc = null;
                try {
                    doc = this.app.openDocument(filePath);
                }
                catch (Exception exception) {
                    log.info((Object)("Cdr\u6587\u4ef6[" + filePath + "]\u6253\u5f00\u6587\u6863\u5f02\u5e38"));
                    return false;
                }
                if (doc.isSimpleCard()) break block18;
                log.info((Object)("Cdr\u6587\u4ef6[" + filePath + "]\u5c3a\u5bf8\u5f02\u5e38"));
                if (doc == null) break block19;
                try {
                    doc.revert();
                    doc.close();
                    doc.getDispatch().safeRelease();
                }
                catch (Exception exception) {}
            }
            return false;
        }
        try {
            try {
                doc.parse();
                this.importCdr(doc);
                log.info((Object)("Cdr\u6587\u4ef6[" + filePath + "]\u5bfc\u5165\u6210\u529f"));
            }
            catch (Exception exception) {
                log.info((Object)("Cdr\u6587\u4ef6[" + filePath + "]\u5bfc\u5165\u5f02\u5e38"));
                if (doc != null) {
                    try {
                        doc.revert();
                        doc.close();
                        doc.getDispatch().safeRelease();
                    }
                    catch (Exception exception2) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (doc != null) {
                try {
                    doc.revert();
                    doc.close();
                    doc.getDispatch().safeRelease();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (doc != null) {
            try {
                doc.revert();
                doc.close();
                doc.getDispatch().safeRelease();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private void importCdr(Document doc) throws Exception {
        MediaCanvas canvas = this.createMediaCanvas(doc);
        this.mediaId = canvas.getMediaId();
        ArrayList<MediaBg> bgList = new ArrayList<MediaBg>();
        ArrayList<MediaMaterial> materialList = new ArrayList<MediaMaterial>();
        Map<Integer, List<Shape>> map = doc.getShapeMap();
        for (Integer key : map.keySet()) {
            MediaBg bg = this.createMediaBg(canvas.getMediaId(), key, canvas.getWidth(), canvas.getHeight());
            bgList.add(bg);
            int index = 0;
            for (Shape shape : map.get(key)) {
                int type = shape.getType();
                int mediaType = 3;
                String source = null;
                String fileId = null;
                switch (type) {
                    case 1: {
                        source = shape.toRectangeSvg();
                        break;
                    }
                    case 2: {
                        source = shape.toEllipseSvg();
                        break;
                    }
                    case 6: {
                        source = shape.toTextSvg();
                        mediaType = 1;
                        break;
                    }
                    case 5: {
                        this.uploadImage(shape);
                        source = shape.toBitmapSvg();
                        mediaType = 0;
                        break;
                    }
                    case 3: {
                        source = shape.toCurveSvg();
                        break;
                    }
                    default: {
                        mediaType = -1;
                    }
                }
                if (mediaType == -1) continue;
                MediaMaterial m = this.createMediaMaterial(canvas.getMediaId(), bg.getBid(), index, mediaType, source, fileId);
                materialList.add(m);
                ++index;
            }
        }
        ((ZTable)ORM.get(ZTable.class)).insert((Object)canvas);
        ((ZTable)ORM.get(ZTable.class)).insertBatch(bgList);
        ((ZTable)ORM.get(ZTable.class)).insertBatch(materialList);
    }

    private String uploadImage(Shape shape) {
        String imagePath = String.valueOf(shape.getApplication().getFileDestDir()) + shape.getName();
        try {
            byte[] bytes = Files.read((String)imagePath);
            String curDate = DateTimes.getDateTime8String();
            String jpgFile = String.valueOf(MediaPathDao.getDesignMaterialLocalPre(curDate)) + shape.getName();
            UpllFile file = MediaPathDao.createUpllFile(bytes, jpgFile);
            shape.setName(file.getFileUrl());
            return file.getFileId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private MediaCanvas createMediaCanvas(Document doc) {
        long mediaId = Ids.longId();
        String time = DateTimes.getDateTimeString();
        MediaCanvas canvas = new MediaCanvas();
        canvas.setMediaId(mediaId);
        canvas.setMediaName("\u672a\u547d\u540d");
        canvas.setStatus(0);
        canvas.setIsEdit(0);
        canvas.setMediaUrl(null);
        canvas.setDpi(300);
        canvas.setBleedSize(2.0);
        canvas.setCreateMode(0);
        canvas.setModify(true);
        canvas.setCreateTime(time);
        canvas.setUpdateTime(time);
        canvas.setWidth(doc.getPageWidth());
        canvas.setHeight(doc.getPageHeight());
        canvas.setWidthMm(doc.getPageWidthMm());
        canvas.setHeightMm(doc.getPageHeightMm());
        canvas.setOddEven(0L);
        return canvas;
    }

    private MediaBg createMediaBg(long mediaId, int bid, double width, double height) {
        MediaBg bg = new MediaBg();
        bg.setMediaId(mediaId);
        bg.setBid(bid);
        bg.setOddEven(0L);
        bg.setFileId(null);
        bg.setBgUrl(null);
        bg.setBgMinUrl(null);
        bg.setSource("<svg width=\"" + width + "\" height=\"" + height + "\" preserveAspectRatio=\"none\" ><rect x=\"0\" y=\"0\" width=\"100%\" height=\"100%\" fill=\"#ffffff\"></rect></svg>");
        return bg;
    }

    private MediaMaterial createMediaMaterial(long mediaId, int bid, int mid, int type, String source, String fileId) {
        MediaMaterial m = new MediaMaterial();
        m.setMediaId(mediaId);
        m.setBid(bid);
        m.setMid(mid);
        m.setPos(mid);
        m.setType(type);
        m.setStatus(0);
        m.setFileId(null);
        m.setSource(source);
        return m;
    }

    public long getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }
}

