/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cache;

import com.zhiqim.media.dbo.MediaParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"MediaParamCache"})
public class MediaParamCache {
    private static final Log log = LogFactory.getLog(MediaParamCache.class);
    private static final HashMap<Long, List<MediaParam>> cacheMap = new HashMap();

    public List<MediaParam> list(long cat) {
        return cacheMap.get(cat);
    }

    public MediaParam item(long cat, String key) {
        List<MediaParam> list = cacheMap.get(cat);
        if (Validates.isEmpty(list)) {
            return null;
        }
        for (MediaParam param : list) {
            if (!key.equals(param.getParamKey())) continue;
            return param;
        }
        return null;
    }

    public synchronized MediaParamCache doRefresh() {
        try {
            cacheMap.clear();
            Selector selector = new Selector();
            selector.addOrderbyAsc("paramIndex");
            List paramList = ((ZTable)ORM.get(ZTable.class)).list(MediaParam.class, selector);
            for (MediaParam param : paramList) {
                long cat = param.getParamCat();
                if (cacheMap.containsKey(cat)) {
                    cacheMap.get(cat).add(param);
                    continue;
                }
                ArrayList<MediaParam> list = new ArrayList<MediaParam>();
                list.add(param);
                cacheMap.put(cat, list);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u5237\u65b0\u5c5e\u6027\u53c2\u6570\u7f13\u5b58\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        return this;
    }
}

