/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.action;

import com.zhiqim.media.dbo.MaterialSvg;
import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.dzmp.DzmpImageStorage;
import com.zhiqim.media.dbo.dzmp.DzmpUserCardStorage;
import com.zhiqim.media.dbo.order.DesignOrder;
import com.zhiqim.media.service.constants.MaterialConstants;
import com.zhiqim.media.service.dao.MediaDao;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.model.MediaBgModel;
import com.zhiqim.media.service.model.MediaModel;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.annotation.AnFilterNot;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Objects;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class MediaDesignAction
implements Action {
    private static final int ORDER_50 = 50;

    @AnFilterNot
    public void execute(HttpRequest request) throws Exception {
        String mediaModelJson = request.getParameterNoFilter("mediaModel");
        String paramJson = request.getParameter("paramJson", "");
        long mediaId = request.getParameterLong("mediaId", -1L);
        double widthMm = Double.parseDouble(request.getParameter("width", "92"));
        double heightMm = Double.parseDouble(request.getParameter("height", "56"));
        int dpi = request.getParameterInt("dpi", 300);
        long paramCat = request.getParameterLong("paramCat", 1L);
        double bleedSize = Double.parseDouble(request.getParameter("bleedSize", "2"));
        boolean isTemplateEdit = request.getParameterBoolean("isTemplateEdit");
        int createMode = request.getParameterInt("createMode", 0);
        boolean isModify = request.getParameterBoolean("isModify", false);
        int totalPage = request.getParameterInt("totalPage", 2);
        double baseWidthMm = Double.parseDouble(request.getParameter("designWidth", "0"));
        double baseHeightMm = Double.parseDouble(request.getParameter("designHeight", "0"));
        double printWidth = Double.parseDouble(request.getParameter("printWidth", "0"));
        double printHeight = Double.parseDouble(request.getParameter("printHeight", "0"));
        if (request.hasParameter("isModify") && ((ZTable)ORM.get(ZTable.class)).count(MediaCanvas.class, new Object[]{mediaId}) > 0) {
            ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, ((Updater)new Updater().addMust("mediaId", (Object)mediaId)).addField("isModify", (Object)isModify));
        }
        MediaModel media = null;
        media = Validates.isNotEmpty((String)mediaModelJson) ? (MediaModel)Jsons.toObject((String)mediaModelJson, MediaModel.class) : MediaDao.getOrCreateMedia(mediaId, paramCat, baseWidthMm, baseHeightMm, widthMm, heightMm, 0.0, 0.0, dpi, totalPage, bleedSize, createMode, isModify);
        MediaCanvas canvas = media.getCanvas();
        canvas.setBleedSize(bleedSize);
        MediaDao.updateCanvasFullSize(canvas, baseWidthMm, baseHeightMm, true);
        mediaId = canvas.getMediaId();
        paramCat = canvas.getMediaType();
        if (baseWidthMm <= 0.0) {
            baseWidthMm = canvas.getBaseWidthMm();
        }
        if (baseHeightMm <= 0.0) {
            baseHeightMm = canvas.getBaseHeightMm();
        }
        ArrayList<MediaBgModel> pageList = new ArrayList<MediaBgModel>();
        for (MediaBg bg : media.getBgList()) {
            String page = MediaDao.toPageSvgCode(canvas, bg, media.getMaterialList(), 120, null);
            MediaBgModel bgModel = new MediaBgModel();
            Objects.copyDeep((Object)bg, (Object)bgModel);
            bgModel.setSvgCode(page);
            pageList.add(bgModel);
        }
        Selector sel = new Selector("svgStatus", (Object)0);
        sel.addMustIn("typeCode", new String[]{MaterialConstants.MATERIAL_BG.value(), MaterialConstants.MATERIAL_BG.value(), MaterialConstants.MATERIAL_TEXT.value(), MaterialConstants.MATERIAL_QCODE.value()});
        sel.addOrderbyAsc("svgSeq");
        List materialList = ((ZTable)ORM.get(ZTable.class)).list(MaterialSvg.class, sel);
        request.setAttribute("media", (Object)media);
        request.setAttribute("materialList", (Object)materialList);
        request.setAttribute("paramJson", (Object)paramJson);
        request.setAttribute("paramCat", (Object)paramCat);
        request.setAttribute("pageList", pageList);
        request.setAttribute("designWidth", (Object)canvas.getBaseWidthMm());
        request.setAttribute("designHeight", (Object)canvas.getBaseHeightMm());
        request.setAttribute("printWidth", (Object)printWidth);
        request.setAttribute("printHeight", (Object)printHeight);
        String curDate = DateTimes.getDateTime8String();
        String prePath = MediaPathDao.getDesignMaterialMidPath(curDate);
        request.setAttribute("prePath", (Object)prePath);
        request.setAttribute("mediaId", (Object)mediaId);
        request.setAttribute("isTemplateEdit", (Object)isTemplateEdit);
        boolean orderIsCardType = request.getParameterBoolean("orderIsCardType");
        boolean editable = Boolean.TRUE;
        if (orderIsCardType) {
            long cardId = request.getParameterLong("cardId");
            long designId = request.getParameterLong("designId");
            DesignOrder designOrder = (DesignOrder)((ZTable)ORM.get(ZTable.class)).item(DesignOrder.class, new Selector("designId", (Object)designId));
            if (designOrder.getStatus() > 50) {
                editable = Boolean.FALSE;
            }
            DzmpUserCardStorage cardInfo = (DzmpUserCardStorage)((ZTable)ORM.get(ZTable.class)).item(DzmpUserCardStorage.class, new Selector("id", (Object)cardId));
            List albumList = ((ZTable)ORM.get(ZTable.class)).list(DzmpImageStorage.class, new Selector("userCardId", (Object)cardId).addOrderbyAsc("sort"));
            String bkgSavePath = "dzmpImages/" + DateTimes.getDateTime7String() + "/5";
            String albumSavePath = "dzmpImages/" + DateTimes.getDateTime7String() + "/1";
            request.setAttribute("cardInfo", (Object)cardInfo);
            request.setAttribute("albumList", (Object)albumList);
            request.setAttribute("bkgSavePath", (Object)bkgSavePath);
            request.setAttribute("albumSavePath", (Object)albumSavePath);
            request.setAttribute("cardId", (Object)cardId);
            request.setAttribute("designId", (Object)designId);
            request.setAttribute("orderIsCardType", (Object)orderIsCardType);
        }
        request.setAttribute("editable", (Object)editable);
    }
}

