/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.presenter;

import java.util.regex.Pattern;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsByteLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.onex.IsUserPass;
import org.zhiqim.httpd.validate.two.IsEqual;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Images;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.manager.SmsUtils;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrAvatar;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrParamOperator;
import org.zhiqim.manager.presenter.WorkWechatPresenter;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"ZmrProfilePresenter"})
@AnIntercept(value={"chkZmrLogin"})
public class ZmrProfilePresenter
implements CodeConstants {
    public static void doModifyPass(HttpRequest request) throws Exception {
        String newPassword;
        request.addValidate((Validate)new IsByteLen("oldPassword", "\u5bc6\u7801\u4e3a6-16\u4f4d\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u65e7\u5bc6\u7801", 6, 16));
        request.addValidate((Validate)new IsUserPass("newPassword", "\u65b0\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u8981\u6c426-16\u4f4d\uff08\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09\uff09"));
        request.addValidate((Validate)new IsUserPass("newPassword2", "\u65b0\u5bc6\u7801\u786e\u8ba4\u4e0d\u5408\u6cd5\uff0c\u8981\u6c426-16\u4f4d\uff08\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09\uff09"));
        request.addValidate((Validate)new IsEqual("newPassword", "newPassword2", "\u65b0\u5bc6\u7801\u548c\u65b0\u5bc6\u7801\u786e\u8ba4\u4e0d\u4e00\u81f4"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String oldPassword = request.getParameter("oldPassword");
        if (oldPassword.equals(newPassword = request.getParameter("newPassword"))) {
            request.setResponseError("\u4fee\u6539\u5bc6\u7801\u65f6\u4e0d\u80fd\u4f7f\u7528\u65e7\u5bc6\u7801");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        String operatorCode = sessionUser.getOperatorCode();
        ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
        String oldPassEncode = passworder.encode(operatorCode, oldPassword, sessionUser.getOperatorPassSalt());
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null || !oldPassEncode.equalsIgnoreCase(operator.getOperatorPass())) {
            request.setResponseError("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e");
            return;
        }
        String newPassSalt = Randoms.lettersDigitsSecure((int)64);
        newPassword = passworder.encode(operatorCode, newPassword, newPassSalt);
        Updater updater = new Updater();
        updater.addMaybe("operatorCode", (Object)operatorCode);
        updater.addField("operatorPass", (Object)newPassword);
        updater.addField("operatorPassSalt", (Object)newPassSalt);
        updater.addField("operatorModified", (Object)DateTimes.getDateTimeString());
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }

    public static void sendSmsByModifyMobile(HttpRequest request) throws Exception {
        boolean isMatch;
        request.addValidate((Validate)new IsNotEmpty("operatorMobile", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        String operatorMobile = request.getParameter("operatorMobile");
        Selector selector = new Selector();
        selector.addMust("operatorMobile", (Object)operatorMobile);
        ZmrOperator operatorNew = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, selector);
        if (operatorNew != null) {
            request.setResponseError("\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
            return;
        }
        if (Validates.isNotEmpty((String)operatorMobile) && !(isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", operatorMobile))) {
            request.setResponseError("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            return;
        }
        SmsUtils.sendSmsCode(request, operatorMobile, "SMS_174195343");
    }

    public static void doModifyMobile(HttpRequest request, String mobile, String smsCode) throws Exception {
        boolean isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", mobile);
        if (!isMatch) {
            request.setResponseError("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            return;
        }
        String sessionSmsCodeSession = request.getSessionAttributeString("_smscode_");
        if (!smsCode.equals(sessionSmsCodeSession)) {
            request.setResponseError("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u65b0\u8f93\u5165\uff01");
            return;
        }
        String accessToken = WorkWechatPresenter.doGetWorkWechatAccessToken();
        String wkwechatAccount = WorkWechatPresenter.getUserIdByPhoneNumber(accessToken, mobile);
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        Updater updater = new Updater();
        updater.addMust("operatorCode", (Object)sessionUser.getOperatorCode());
        updater.addField("operatorMobile", (Object)mobile);
        updater.addField("wkwechatAccount", (Object)wkwechatAccount);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }

    public static void doModifyEmail(HttpRequest request, String email) throws Exception {
        if (!Validates.isEmail((String)email, (boolean)false)) {
            request.setResponseError("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        Updater updater = new Updater();
        updater.addMust("operatorCode", (Object)sessionUser.getOperatorCode());
        updater.addField("operatorEmail", (Object)email);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }

    public static void doModifyWangwang(HttpRequest request, String wagnwang) throws Exception {
        if (Validates.isEmptyBlank((String)wagnwang)) {
            request.setResponseError("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u65fa\u65fa");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        Updater updater = new Updater();
        updater.addMust("operatorCode", (Object)sessionUser.getOperatorCode());
        updater.addField("operatorWangwang", (Object)wagnwang);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }

    public static void doModifyWkwechatAccount(HttpRequest request, String wkwechatAccount) throws Exception {
        if (Validates.isEmptyBlank((String)wkwechatAccount)) {
            request.setResponseError("\u8bf7\u8f93\u5165\u64cd\u4f5c\u5458\u4f01\u4e1a\u5fae\u4fe1\u8d26\u53f7");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        Updater updater = new Updater();
        updater.addMust("operatorCode", (Object)sessionUser.getOperatorCode());
        updater.addField("wkwechatAccount", (Object)wkwechatAccount);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }

    public static void doModifyWxcode(HttpRequest request, String operatorWxcode) throws Exception {
        if (Validates.isEmptyBlank((String)operatorWxcode)) {
            request.setResponseError("\u8bf7\u8f93\u5165\u64cd\u4f5c\u5458\u4e2a\u4eba\u5fae\u4fe1\u8d26\u53f7");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        Updater updater = new Updater();
        updater.addMust("operatorCode", (Object)sessionUser.getOperatorCode());
        updater.addField("operatorWxcode", (Object)operatorWxcode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }

    public static String doQuerySysAvatar(HttpRequest request, int pageNo) throws Exception {
        int pageSize = 18;
        if (pageNo < 1) {
            pageNo = 1;
        }
        PageResult result = ZmrBootstrap.table(request).page(ZmrAvatar.class, pageNo, pageSize, new Selector("avatarType", (Object)0).addOrderbyAsc("avatarId"));
        HashMapSO attrMap = new HashMapSO();
        attrMap.put("result", (Object)result);
        attrMap.put("pageNo", (Object)pageNo);
        return ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/zhiqim_manager/presenter/selSysAvatarInfo.zml", (MapSO)attrMap);
    }

    public static void doModifySysAvatar(HttpRequest request, long avatarId) throws Exception {
        ZmrAvatar avatar;
        if (ZmrBootstrap.table(request).item(ZmrAvatar.class, new Object[]{avatarId}) == null) {
            request.setResponseError("\u9009\u62e9\u7684\u5934\u50cf\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()});
        if (operator.getOperatorAvatar() != 0L && (avatar = (ZmrAvatar)ZmrBootstrap.table(request).item(ZmrAvatar.class, new Object[]{operator.getOperatorAvatar()})) != null && avatar.getAvatarType() == 1) {
            ZmrBootstrap.table(request).delete(ZmrAvatar.class, new Object[]{operator.getOperatorAvatar()});
        }
        Updater updater = new Updater();
        updater.addMust("operatorCode", (Object)sessionUser.getOperatorCode());
        updater.addField("operatorAvatar", (Object)avatarId);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }

    public static void doModifySelfAvatar(HttpRequest request, String data) throws Exception {
        ZmrAvatar avatar;
        int idx = data.indexOf(",");
        byte[] imageData = Base64.decode((String)data.substring(idx + 1));
        byte[] bytes50 = Images.resizePNG((byte[])imageData, (int)50, (int)50);
        if (bytes50 == null) {
            request.setResponseError("\u56fe\u7247\u9519\u8bef");
            return;
        }
        byte[] bytes100 = Images.resizePNG((byte[])imageData, (int)100, (int)100);
        if (bytes100 == null) {
            request.setResponseError("\u56fe\u7247\u9519\u8bef");
            return;
        }
        byte[] bytes150 = Images.resizePNG((byte[])imageData, (int)150, (int)150);
        if (bytes150 == null) {
            request.setResponseError("\u56fe\u7247\u9519\u8bef");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()});
        if (operator.getOperatorAvatar() != 0L && (avatar = (ZmrAvatar)ZmrBootstrap.table(request).item(ZmrAvatar.class, new Object[]{operator.getOperatorAvatar()})).getAvatarType() == 1) {
            ZmrBootstrap.table(request).delete(ZmrAvatar.class, new Object[]{operator.getOperatorAvatar()});
        }
        long avatarId = Ids.longId13();
        ZmrAvatar avatar2 = new ZmrAvatar();
        avatar2.setAvatarId(avatarId);
        avatar2.setAvatarType(1);
        avatar2.setAvatarTime(System.currentTimeMillis());
        avatar2.setAvatar50(bytes50);
        avatar2.setAvatar100(bytes100);
        avatar2.setAvatar150(bytes150);
        ZmrBootstrap.table(request).insert((Object)avatar2);
        Updater updater = new Updater();
        updater.addMust("operatorCode", (Object)sessionUser.getOperatorCode());
        updater.addField("operatorAvatar", (Object)avatarId);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        operator.setOperatorAvatar(avatarId);
        sessionUser.setOperator(operator);
    }

    public static void doCloseSuperAdmin(HttpRequest request) throws Exception {
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        if (!sessionUser.isSuperAdmin()) {
            request.setResponseError("\u4f60\u6ca1\u6709\u5173\u95ed\u8d85\u7ea7\u7ba1\u7406\u5458\u6743\u9650");
            return;
        }
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Selector("operatorType", (Object)1)) == 0) {
            request.setResponseError("\u8fd8\u6ca1\u6709\u8bbe\u7f6e\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u5173\u95ed\u8d85\u7ea7\u7ba1\u7406\u5458");
            return;
        }
        Updater updater = new Updater();
        updater.addField("operatorStatus", (Object)1);
        updater.addMust("operatorType", (Object)0);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    public static void doModifyOperatorParam(HttpRequest request) throws Exception {
        String paramKey = request.getParameter("paramKey");
        String paramValue = request.getParameter("paramValue");
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        if (ZmrBootstrap.tableOpr(request).count(ZmrParamOperator.class, new Object[]{paramKey}) <= 0) {
            request.setResponseError("\u8be5\u64cd\u4f5c\u5458\u53c2\u6570\u952e\u672a\u5b9a\u4e49\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return;
        }
        ZmrOperatorDao.addOrUpdateOperatorParam(request, sessionUser.getOperatorCode(), paramKey, paramValue);
        sessionUser.setOperator((ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{sessionUser.getOperatorCode()}));
    }
}

