/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.presenter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Linux;
import org.zhiqim.kernel.util.Systems;

@AnAlias(value={"ZmrProcessPresenter"})
@AnIntercept(value={"chkZmrLogin"})
public class ZmrProcessPresenter
implements CodeConstants {
    public static void doShowProcessInfo(HttpRequest request) throws Exception {
        if (Systems.isWindows()) {
            request.setResponseError("\u6682\u4e0d\u652f\u6301Windows\u67e5\u8be2\u8fdb\u7a0b\u4fe1\u606f");
            return;
        }
        int pid = Systems.getPid();
        String shell = "top -H -p " + pid + " -n 1 -b";
        String result = Linux.shell((String)shell, (String)"UTF-8");
        List<String> list = ZmrProcessPresenter.findProcessInfo(result);
        List<List<String>> threadList = ZmrProcessPresenter.findThreadList(result);
        int pageNo = request.getParameterInt("pageNo", 1);
        PageResult pageResult = PageBuilder.pageResult((int)pageNo, (int)15, threadList);
        HashMapSO variable = new HashMapSO();
        variable.put("pid", (Object)pid);
        variable.put("list", list);
        variable.put("pageResult", (Object)pageResult);
        String responseText = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/zhiqim_manager/presenter/processInfo.zml", (MapSO)variable);
        request.setResponseResult(responseText);
    }

    public static List<List<String>> findThreadList(String result) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        Pattern pattern = Pattern.compile("(\\d+)\\s+(\\w+)\\s+(\\d)+\\s+(\\d+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)");
        Matcher matcher = pattern.matcher(result);
        while (matcher.find()) {
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(matcher.group(1));
            stringList.add(matcher.group(2));
            stringList.add(matcher.group(3));
            stringList.add(matcher.group(4));
            stringList.add(matcher.group(5));
            stringList.add(matcher.group(6));
            stringList.add(matcher.group(7));
            stringList.add(matcher.group(8));
            stringList.add(matcher.group(9));
            stringList.add(matcher.group(10));
            stringList.add(matcher.group(11));
            stringList.add(matcher.group(12));
            list.add(stringList);
        }
        return list;
    }

    public static List<String> findProcessInfo(String result) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\S.+\\n");
        Matcher matcher = pattern.matcher(result);
        int i = 0;
        while (matcher.find()) {
            if (i++ == 5) break;
            list.add(matcher.group());
        }
        return list;
    }

    public static List<String> findThreadStack(String result) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\\"([\\s\\S]+?\"[\\s\\S]+?)(?=\\\"|JNI)");
        Matcher matcher = pattern.matcher(result);
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static String findPid(String result) {
        StringBuilder str = new StringBuilder();
        Pattern pattern = Pattern.compile("nid=0x(\\w+)");
        Matcher matcher = pattern.matcher(result);
        while (matcher.find()) {
            str.append(matcher.group(1));
        }
        return str.toString();
    }
}

