/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.presenter;

import com.miaohui.service.constant.ParamOfTypeAndSceneEnum;
import com.miaohui.service.constant.WorkWechatResultCodeEnum;
import com.miaohui.service.request.WorkWechatConfigContactWayRequest;
import com.miaohui.service.request.WorkWechatGetAccessTokenRequest;
import com.miaohui.service.request.WorkWechatGetContactWayRequest;
import com.miaohui.service.request.WorkWechatGetUserIdByPhoneNumberRequest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Collectionx;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"WorkWechatPresenter"})
public class WorkWechatPresenter {
    private static final Log log = LogFactory.getLog(WorkWechatPresenter.class);

    public static String doGetWorkWechatAccessToken() {
        String accessToken = null;
        WorkWechatGetAccessTokenRequest accessTokenRequest = new WorkWechatGetAccessTokenRequest();
        try {
            String result = accessTokenRequest.execute();
            HashMapSO resultMap = Jsons.toMapSO((String)result);
            Object errcodeObj = resultMap.get("errcode");
            if (Validates.isNotEmpty((Object)errcodeObj)) {
                String errcode = errcodeObj.toString();
                if (WorkWechatResultCodeEnum.REQUEST_SUCCESSFUL.getCode().equals(errcode)) {
                    Object accessTokenObj = resultMap.get("access_token");
                    if (Validates.isNotEmpty((Object)accessTokenObj)) {
                        accessToken = accessTokenObj.toString();
                    } else {
                        log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API\u83b7\u53d6access_token\u5931\u8d25\uff1a[access_token\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                    }
                } else {
                    log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API\u83b7\u53d6access_token\u5931\u8d25\uff1a[" + WorkWechatResultCodeEnum.getNameByCode((String)errcode) + "]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                }
            } else {
                log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API\u83b7\u53d6access_token\u9519\u8bef\uff1a[\u7ed3\u679c\u7801\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API\u83b7\u53d6access_token\u5f02\u5e38\uff1a[" + e.getMessage() + "]\n" + e));
        }
        return accessToken;
    }

    public static String doConfigContactWay(String accessToken, String type, String scene, List<String> user, Boolean isTemp) {
        String configId = null;
        Boolean validate = WorkWechatPresenter.validateConfigContactWayParams(accessToken, type, scene, user);
        if (!validate.booleanValue()) {
            return configId;
        }
        if (Validates.isEmpty((Object)isTemp)) {
            isTemp = Boolean.FALSE;
        }
        WorkWechatConfigContactWayRequest configContactWayRequest = new WorkWechatConfigContactWayRequest();
        TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
        urlParamsMap.put("access_token", accessToken);
        LinkedHashMap<String, Object> jsonParamsMap = new LinkedHashMap<String, Object>();
        jsonParamsMap.put("type", type);
        jsonParamsMap.put("scene", scene);
        jsonParamsMap.put("user", user);
        jsonParamsMap.put("is_temp", isTemp.toString());
        try {
            String result = configContactWayRequest.execute(urlParamsMap, jsonParamsMap);
            HashMapSO resultMap = Jsons.toMapSO((String)result);
            Object errcodeObj = resultMap.get("errcode");
            if (Validates.isNotEmpty((Object)errcodeObj)) {
                String errcode = errcodeObj.toString();
                if (WorkWechatResultCodeEnum.REQUEST_SUCCESSFUL.getCode().equals(errcode)) {
                    Object configIdObj = resultMap.get("config_id");
                    if (Validates.isNotEmpty((Object)configIdObj)) {
                        configId = configIdObj.toString();
                    } else {
                        log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u5931\u8d25\uff1a[config_id\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                        log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
                    }
                } else {
                    log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u5931\u8d25\uff1a[" + WorkWechatResultCodeEnum.getNameByCode((String)errcode) + "]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                    log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
                }
            } else {
                log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u9519\u8bef\uff1a[\u7ed3\u679c\u7801\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u5f02\u5e38\uff1a[" + e.getMessage() + "]\n" + e));
            log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
        }
        return configId;
    }

    private static Boolean validateConfigContactWayParams(String accessToken, String type, String scene, List<String> user) {
        Boolean flag = Boolean.TRUE;
        if (Validates.isEmpty((String)accessToken)) {
            log.error((Object)"\u8c03\u7528\u63a5\u53e3\u51ed\u8bc1 accessToken \u4e0d\u80fd\u4e3a\u7a7a");
            flag = Boolean.FALSE;
            return flag;
        }
        if (Validates.isEmpty((String)type)) {
            log.error((Object)"\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b type \u4e0d\u80fd\u4e3a\u7a7a");
            flag = Boolean.FALSE;
            return flag;
        }
        if (!ParamOfTypeAndSceneEnum.TYPE_SINGLE_PERSON.getCode().equals(type) && !ParamOfTypeAndSceneEnum.TYPE_MANY_PEOPLE.getCode().equals(type)) {
            log.error((Object)"\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b type \u503c\u53ea\u80fd\u662f1\u62162");
            flag = Boolean.FALSE;
            return flag;
        }
        if (Validates.isEmpty((String)scene)) {
            log.error((Object)"\u573a\u666f scene \u4e0d\u80fd\u4e3a\u7a7a");
            flag = Boolean.FALSE;
            return flag;
        }
        if (!ParamOfTypeAndSceneEnum.SCENE_CONTACT_WITH_MINIPROGRAM.getCode().equals(scene) && !ParamOfTypeAndSceneEnum.SCENE_CONTACT_WITH_QRCODE.getCode().equals(scene)) {
            log.error((Object)"\u573a\u666f scene \u503c\u53ea\u80fd\u662f1\u62162");
            flag = Boolean.FALSE;
            return flag;
        }
        if (Collectionx.isEmpty(user)) {
            log.error((Object)"\u4f7f\u7528\u8be5\u8054\u7cfb\u65b9\u5f0f\u7684\u7528\u6237userID\u5217\u8868 user \u4e0d\u80fd\u4e3a\u7a7a");
            flag = Boolean.FALSE;
            return flag;
        }
        if (user.size() > 1 && ParamOfTypeAndSceneEnum.TYPE_SINGLE_PERSON.getCode().equals(type)) {
            log.error((Object)"\u5728type\u4e3a1\u65f6 user \u5217\u8868\u5143\u7d20\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a");
            flag = Boolean.FALSE;
            return flag;
        }
        return flag;
    }

    public static String getContactWay(String accessToken, String configId) {
        String qrcode = null;
        if (Validates.isEmpty((String)accessToken)) {
            log.error((Object)"\u8c03\u7528\u63a5\u53e3\u51ed\u8bc1 accessToken \u4e0d\u80fd\u4e3a\u7a7a");
            return qrcode;
        }
        if (Validates.isEmpty((String)configId)) {
            log.error((Object)"\u8054\u7cfb\u65b9\u5f0f\u7684\u914d\u7f6eid configId \u4e0d\u80fd\u4e3a\u7a7a");
            return qrcode;
        }
        WorkWechatGetContactWayRequest getContactWayRequest = new WorkWechatGetContactWayRequest();
        TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
        urlParamsMap.put("access_token", accessToken);
        LinkedHashMap<String, String> jsonParamsMap = new LinkedHashMap<String, String>();
        jsonParamsMap.put("config_id", configId);
        try {
            String result = getContactWayRequest.execute(urlParamsMap, jsonParamsMap);
            HashMapSO resultMap = Jsons.toMapSO((String)result);
            Object errcodeObj = resultMap.get("errcode");
            if (Validates.isNotEmpty((Object)errcodeObj)) {
                String errcode = errcodeObj.toString();
                if (WorkWechatResultCodeEnum.REQUEST_SUCCESSFUL.getCode().equals(errcode)) {
                    Object contactWayObj = resultMap.get("contact_way");
                    if (Validates.isEmpty((Object)contactWayObj)) {
                        log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u83b7\u53d6\u4f01\u4e1a\u5df2\u914d\u7f6e\u7684\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u5931\u8d25\uff1a[contact_way\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                    } else {
                        HashMapSO contactWay = Jsons.toMapSO((String)contactWayObj.toString());
                        Object qrcodeObj = contactWay.get("qr_code");
                        if (Validates.isNotEmpty((Object)qrcodeObj)) {
                            qrcode = qrcodeObj.toString();
                        } else {
                            log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u83b7\u53d6\u4f01\u4e1a\u5df2\u914d\u7f6e\u7684\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u5931\u8d25\uff1a[qr_code\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                            log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
                        }
                    }
                } else {
                    log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u83b7\u53d6\u4f01\u4e1a\u5df2\u914d\u7f6e\u7684\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u5931\u8d25\uff1a[" + WorkWechatResultCodeEnum.getNameByCode((String)errcode) + "]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                    log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
                }
            } else {
                log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u83b7\u53d6\u4f01\u4e1a\u5df2\u914d\u7f6e\u7684\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u9519\u8bef\uff1a[\u7ed3\u679c\u7801\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u83b7\u53d6\u4f01\u4e1a\u5df2\u914d\u7f6e\u7684\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u5f02\u5e38\uff1a[" + e.getMessage() + "]\n" + e));
            log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
        }
        return qrcode;
    }

    public static String getUserIdByPhoneNumber(String accessToken, String mobile) {
        String userId = null;
        if (Validates.isEmpty((String)accessToken)) {
            log.error((Object)"\u8c03\u7528\u63a5\u53e3\u51ed\u8bc1 accessToken \u4e0d\u80fd\u4e3a\u7a7a");
            return userId;
        }
        if (Validates.isEmpty((String)mobile)) {
            log.error((Object)"\u4f01\u4e1a\u6210\u5458\u624b\u673a\u53f7\u7801 mobile \u4e0d\u80fd\u4e3a\u7a7a");
            return userId;
        }
        WorkWechatGetUserIdByPhoneNumberRequest getUserIdByPhoneNumberRequest = new WorkWechatGetUserIdByPhoneNumberRequest();
        TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
        urlParamsMap.put("access_token", accessToken);
        LinkedHashMap<String, String> jsonParamsMap = new LinkedHashMap<String, String>();
        jsonParamsMap.put("mobile", mobile);
        try {
            String result = getUserIdByPhoneNumberRequest.execute(urlParamsMap, jsonParamsMap);
            HashMapSO resultMap = Jsons.toMapSO((String)result);
            Object errcodeObj = resultMap.get("errcode");
            if (Validates.isNotEmpty((Object)errcodeObj)) {
                String errcode = errcodeObj.toString();
                if (WorkWechatResultCodeEnum.REQUEST_SUCCESSFUL.getCode().equals(errcode)) {
                    Object userIdObj = resultMap.get("userid");
                    if (Validates.isNotEmpty((Object)userIdObj)) {
                        userId = userIdObj.toString();
                    } else {
                        log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u6839\u636e\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u624b\u673a\u53f7\u83b7\u53d6userid\u65b9\u5f0f\u5931\u8d25\uff1a[userid\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                        log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
                    }
                } else {
                    log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u6839\u636e\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u624b\u673a\u53f7\u83b7\u53d6userid\u65b9\u5f0f\u5931\u8d25\uff1a[" + WorkWechatResultCodeEnum.getNameByCode((String)errcode) + "]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                    log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
                }
            } else {
                log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u6839\u636e\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u624b\u673a\u53f7\u83b7\u53d6userid\u65b9\u5f0f\u9519\u8bef\uff1a[\u7ed3\u679c\u7801\u4e3a\u7a7a]\uff0c\u8fd4\u56de\u7ed3\u679c[" + resultMap + "]"));
                log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1API \u6839\u636e\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u624b\u673a\u53f7\u83b7\u53d6userid\u65b9\u5f0f\u5f02\u5e38\uff1a[" + e.getMessage() + "]\n" + e));
            log.error((Object)("\u5730\u5740\u680f\u8bf7\u6c42\u53c2\u6570[" + urlParamsMap + "]\uff0c\u8bf7\u6c42\u4f53\u8bf7\u6c42\u53c2\u6570[" + jsonParamsMap + "]"));
        }
        return userId;
    }

    public static void main(String[] args) {
        String accessToken = WorkWechatPresenter.doGetWorkWechatAccessToken();
        System.out.println(accessToken);
        ArrayList<String> users = new ArrayList<String>();
        users.add("caohong");
        String contactWay = WorkWechatPresenter.doConfigContactWay(accessToken, ParamOfTypeAndSceneEnum.TYPE_SINGLE_PERSON.getCode(), ParamOfTypeAndSceneEnum.SCENE_CONTACT_WITH_QRCODE.getCode(), users, Boolean.TRUE);
        System.out.println(contactWay);
        String qrcode = WorkWechatPresenter.getContactWay(accessToken, contactWay);
        System.out.println(qrcode);
        String userId = WorkWechatPresenter.getUserIdByPhoneNumber(accessToken, "17346884115");
        System.out.println(userId);
    }
}

