/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.dao;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.config.ItemType;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dbo.ZmrParam;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"ZmrParamDao"})
public class ZmrParamDao
implements ZmrConstants,
SignConstants {
    public static void addParam(HttpContext context, String paramGroup, String paramKey, int paramSeq, String paramDesc) throws Exception {
        ZmrParamDao.addParam(context, paramGroup, paramKey, null, paramSeq, ItemType.PUBLIC, null, paramDesc);
    }

    public static void addParam(HttpContext context, String paramGroup, String paramKey, String paramValue, int paramSeq, ItemType paramType, String paramDesc) throws Exception {
        ZmrParamDao.addParam(context, paramGroup, paramKey, paramValue, paramSeq, paramType, null, paramDesc);
    }

    public static void addParam(HttpContext context, String paramGroup, String paramKey, String paramValue, int paramSeq, ItemType paramType, String paramValidate, String paramDesc) throws Exception {
        if (ZmrBootstrap.table(context).count(ZmrParam.class, new Object[]{paramGroup, paramKey}) == 0) {
            ZmrParam param = new ZmrParam();
            param.setParamGroup(paramGroup);
            param.setParamKey(paramKey);
            param.setParamValue(paramValue);
            param.setParamSeq(paramSeq);
            param.setParamType(ItemType.toString((ItemType)paramType));
            param.setParamValidate(paramValidate);
            param.setParamDesc(paramDesc);
            ZmrBootstrap.table(context).insert((Object)param);
        }
    }

    public static boolean hasGroup(HttpContext context, String paramGroup) throws ORMException, SQLException {
        return ZmrBootstrap.table(context).count(ZmrParam.class, new Selector("paramGroup", (Object)paramGroup)) > 0;
    }

    public static boolean hasParam(HttpContext context, String paramGroup, String paramKey) throws ORMException, SQLException {
        return ZmrBootstrap.table(context).count(ZmrParam.class, new Object[]{paramGroup, paramKey}) > 0;
    }

    public static LinkedHashMap<String, LinkedHashMap<String, ZmrParam>> getGroupMap(HttpContext context) throws ORMException, SQLException {
        LinkedHashMap<String, LinkedHashMap<String, ZmrParam>> groupMap = new LinkedHashMap<String, LinkedHashMap<String, ZmrParam>>();
        List paramList = ZmrBootstrap.table(context).list(ZmrParam.class, ((Selector)new Selector().addMustNotEqual("paramType", (Object)"private")).addOrderbyAsc("paramGroup,paramSeq"));
        for (ZmrParam param : paramList) {
            LinkedHashMap<String, ZmrParam> paramMap = groupMap.get(param.getParamGroup());
            if (paramMap == null) {
                paramMap = new LinkedHashMap();
                groupMap.put(param.getParamGroup(), paramMap);
            }
            paramMap.put(param.getParamKey(), param);
        }
        return groupMap;
    }

    public static ZmrParam getParam(HttpContext context, String paramGroup, String paramKey) throws ORMException, SQLException {
        ZTable table = ZmrBootstrap.table(context);
        return (ZmrParam)table.item(ZmrParam.class, new Object[]{paramGroup, paramKey});
    }

    public static String getString(HttpContext context, String paramGroup, String paramKey) throws ORMException, SQLException {
        ZmrParam param = ZmrParamDao.getParam(context, paramGroup, paramKey);
        return param == null ? null : param.getParamValue();
    }

    public static String getString(HttpContext context, String paramGroup, String paramKey, String defaultValue) throws ORMException, SQLException {
        String value = ZmrParamDao.getString(context, paramGroup, paramKey);
        return Validates.isEmptyBlank((String)value) ? defaultValue : value;
    }

    public static int getInt(HttpContext context, String paramGroup, String paramKey) throws ORMException, SQLException {
        return ZmrParamDao.getInt(context, paramGroup, paramKey, -1);
    }

    public static int getInt(HttpContext context, String paramGroup, String paramKey, int defaultValue) throws ORMException, SQLException {
        return Ints.toInt((String)ZmrParamDao.getString(context, paramGroup, paramKey), (int)defaultValue);
    }

    public static boolean isTrue(HttpContext context, String paramGroup, String paramKey) throws ORMException, SQLException {
        return "true".equals(ZmrParamDao.getString(context, paramGroup, paramKey));
    }

    public static boolean isTrue(HttpContext context, String paramGroup, String paramKey, String defaultValue) throws ORMException, SQLException {
        return "true".equals(ZmrParamDao.getString(context, paramGroup, paramKey, defaultValue));
    }

    public static boolean doUpdate(HttpContext context, String paramGroup, String paramKey, int paramValue) throws ORMException, SQLException {
        return ZmrParamDao.doUpdate(context, paramGroup, paramKey, String.valueOf(paramValue));
    }

    public static boolean doUpdate(HttpContext context, String paramGroup, String paramKey, long paramValue) throws ORMException, SQLException {
        return ZmrParamDao.doUpdate(context, paramGroup, paramKey, String.valueOf(paramValue));
    }

    public static boolean doUpdate(HttpContext context, String paramGroup, String paramKey, boolean paramValue) throws ORMException, SQLException {
        return ZmrParamDao.doUpdate(context, paramGroup, paramKey, String.valueOf(paramValue));
    }

    public static boolean doUpdate(HttpContext context, String paramGroup, String paramKey, String paramValue) throws ORMException, SQLException {
        Updater updater = new Updater();
        updater.addMust("paramGroup", (Object)paramGroup);
        updater.addMust("paramKey", (Object)paramKey);
        updater.addField("paramValue", (Object)paramValue);
        return ZmrBootstrap.table(context).update(ZmrParam.class, updater) > 0;
    }

    public static String getThemeIndex(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getString(context, "zhiqim.manager", "themeIndex", "00_default");
    }

    public static void doUpdateThemeIndex(HttpContext context, String theme) throws ORMException, SQLException {
        ZmrParamDao.doUpdate(context, "zhiqim.manager", "themeIndex", theme);
    }

    public static String getThemeMain(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getString(context, "zhiqim.manager", "themeMain", "00_default");
    }

    public static void doUpdateThemeMain(HttpContext context, String theme) throws ORMException, SQLException {
        ZmrParamDao.doUpdate(context, "zhiqim.manager", "themeMain", theme);
    }

    public static boolean isThemeFrame(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.isTrue(context, "zhiqim.manager", "themeFrame", "false");
    }

    public static String getMhIp(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getString(context, "zhiqim.manager", "mhIp");
    }

    public static boolean hasManageLogin(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.isTrue(context, "zhiqim.manager", "hasManageLogin");
    }

    public static boolean hasVerificationCode(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.isTrue(context, "zhiqim.manager", "hasVerificationCode");
    }

    public static boolean hasRememberCode(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.isTrue(context, "zhiqim.manager", "hasRememberCode");
    }

    public static boolean hasRememberPass(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.isTrue(context, "zhiqim.manager", "hasRememberPass");
    }

    public static String getMainUrl(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getString(context, "zhiqim.manager", "mainUrl", "/${zhiqim_manager}/main.htm");
    }

    public static String getMainIndexUrl(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.isThemeFrame(context) ? "/${zhiqim_manager}/welcome.htm" : "/${zhiqim_manager}/main.htm";
    }

    public static int getRemainLogDay(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getInt(context, "zhiqim.manager", "remainLogDay", 7);
    }

    public static boolean isOperatorDeptAllRule(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.isTrue(context, "zhiqim.manager", "operatorDeptAllRule");
    }

    public static boolean hasCdnPath(HttpContext context) throws ORMException, SQLException {
        return !Validates.isEmptyBlank((String)ZmrParamDao.getString(context, "zhiqim.manager", "cdnPath"));
    }

    public static String getCdnPath(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getString(context, "zhiqim.manager", "cdnPath");
    }

    public static String getPublicKey(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getString(context, "zhiqim.manager", "publicKey");
    }

    public static String getPrivateKey(HttpContext context) throws ORMException, SQLException {
        return ZmrParamDao.getString(context, "zhiqim.manager", "privateKey");
    }
}

