/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"ZmrDeptDao"})
public class ZmrDeptDao {
    public static List<ZmrDept> getOrgDeptList(HttpRequest request, long orgId) throws ORMException, SQLException {
        return ZmrBootstrap.table(request).list(ZmrDept.class, new Selector("orgId", (Object)orgId).addOrderbyAsc("deptLevel,deptSeq,deptId"));
    }

    public static Tree<ZmrDept> getOrgDeptTree(HttpRequest request, long orgId) throws ORMException, SQLException {
        return TreeBuilder.newTree(ZmrDeptDao.getOrgDeptList(request, orgId), (String)"parentId", (String)"deptId");
    }

    public static boolean isDeptManager(HttpRequest request, String operatorCode) throws ORMException, SQLException {
        return !ZmrBootstrap.table(request).list(ZmrDept.class, new Selector("deptId", "deptManager", (Object)operatorCode)).isEmpty();
    }

    public static List<String> getDeptOperatorCodeList(HttpRequest request, String operatorCode, boolean recursion) throws Exception {
        Asserts.assertNotEmpty((String)operatorCode, (String)"\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        List deptList = ZmrBootstrap.table(request).list(ZmrDept.class, new Selector("deptManager", (Object)operatorCode));
        if (deptList.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        List operatorList = ZmrBootstrap.tableOpr(request).list(ZmrOperator.class);
        block0: for (ZmrOperator operator : operatorList) {
            String deptAll = recursion ? operator.getOperatorDeptAll() : operator.getOperatorDept();
            for (ZmrDept dept : deptList) {
                if (!Validates.isContain((String)deptAll, (String)",", (long)dept.getDeptId())) continue;
                list.add(operator.getOperatorCode());
                continue block0;
            }
        }
        return list;
    }

    public static List<ZmrOperator> getDeptOperatorList(HttpRequest request, String operatorCode, boolean recursion) throws Exception {
        Asserts.assertNotEmpty((String)operatorCode, (String)"\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        List deptList = ZmrBootstrap.table(request).list(ZmrDept.class, new Selector("deptManager", (Object)operatorCode));
        if (deptList.isEmpty()) {
            return new ArrayList<ZmrOperator>();
        }
        ArrayList<ZmrOperator> list = new ArrayList<ZmrOperator>();
        List operatorList = ZmrBootstrap.tableOpr(request).list(ZmrOperator.class);
        block0: for (ZmrOperator operator : operatorList) {
            String deptAll = recursion ? operator.getOperatorDeptAll() : operator.getOperatorDept();
            for (ZmrDept dept : deptList) {
                if (!Validates.isContain((String)deptAll, (String)",", (long)dept.getDeptId())) continue;
                list.add(operator);
                continue block0;
            }
        }
        return list;
    }

    public static void doUpdateDeptManeger(HttpRequest request, List<String> operatorCodeList, String deptId, String deptParentAll) throws Exception {
        for (String operatorCode : operatorCodeList) {
            ZmrOperator operator = (ZmrOperator)((ZTable)ORM.get(ZTable.class)).item(ZmrOperator.class, new Object[]{operatorCode});
            if (operator == null) {
                request.returnHistory("\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728");
                return;
            }
            String operatorDept = operator.getOperatorDept();
            operatorDept = Validates.isEmptyBlank((String)operatorDept) ? deptId : String.valueOf(operatorDept) + "," + deptId;
            String operatorDeptAll = operator.getOperatorDeptAll();
            operatorDeptAll = Validates.isEmptyBlank((String)operatorDeptAll) ? String.valueOf(deptParentAll) + "," + deptId : String.valueOf(operatorDeptAll) + "," + deptParentAll + "," + deptId;
            operatorDept = Arrays.toFilterSameStr((String[])Arrays.toStringArray((String)operatorDept));
            operatorDeptAll = Arrays.toFilterSameStr((String[])Arrays.toStringArray((String)operatorDeptAll));
            Updater updater = new Updater();
            updater.addMust("operatorCode", (Object)operatorCode);
            updater.addField("operatorDept", (Object)operatorDept);
            updater.addField("operatorDeptAll", (Object)operatorDeptAll);
            ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
        }
    }
}

