/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.Arrays;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.ones.IsNumericLen;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrParamDao;

public class IndexAction
implements Action,
ZhiqimConstants,
ZmrConstants {
    public void execute(HttpRequest request) throws Exception {
        if (request.isMobile()) {
            request.setResponseError("\u8bf7\u4f7f\u7528PC\u7535\u8111\u7aef\u8bbf\u95ee\uff01");
            return;
        }
        HttpContext context = request.getContext();
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        if (sessionUser != null) {
            String mainUrl = ZmlContexts.parseZmlContent((HttpRequest)request, (String)ZmrParamDao.getMainUrl(context));
            if (!ZmrParamDao.isThemeFrame(context)) {
                request.setRedirect(mainUrl);
            } else {
                String defaultUrl = ZmlContexts.parseZmlContent((HttpRequest)request, (String)"/${zhiqim_manager}/main.htm");
                String welcomeUrl = ZmlContexts.parseZmlContent((HttpRequest)request, (String)"/${zhiqim_manager}/welcome.htm");
                sessionUser.setMainUrl(defaultUrl.equals(mainUrl) ? welcomeUrl : mainUrl);
                request.setRedirect(defaultUrl);
            }
            return;
        }
        request.setResponsePrivateCache();
        request.addValidate((Validate)new IsLen("operatorCode", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5e10\u53f7", 2, 32));
        request.addValidate((Validate)new IsLen("operatorPass", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5bc6\u7801", 6, 90));
        boolean hasVerificationSms = false;
        String userIp = request.getRemoteAddr();
        if (userIp.contains("192.168.3.136") && request.getPort() == 8089) {
            hasVerificationSms = true;
        } else if ("0:0:0:0:0:0:0:1".equals(userIp) || userIp.contains("192.168.3") || "127.0.0.1".equals(userIp)) {
            hasVerificationSms = false;
        } else {
            List<String> mhIpArray = null;
            String mhIpString = ZmrParamDao.getMhIp(context);
            if (mhIpString != null && !Validates.isEmptyBlank((String)mhIpString) && !(mhIpArray = Arrays.asList(mhIpString.split(","))).contains(userIp)) {
                hasVerificationSms = true;
            }
        }
        boolean hasVerificationCode = ZmrParamDao.hasVerificationCode(context);
        boolean hasRememberCode = ZmrParamDao.hasRememberCode(context);
        boolean hasRememberPass = ZmrParamDao.hasRememberPass(context);
        if (hasVerificationSms) {
            request.addValidate((Validate)new IsNumericLen("smsCode", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e3a6\u4f4d\u6570\u5b57", 6, 6));
        }
        if (hasVerificationCode) {
            request.addValidate((Validate)new IsNumericLen("verificationCode", "\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f4\u4f4d\u6570\u5b57", 4, 4));
        }
        request.setAttribute("hasRememberCode", (Object)hasRememberCode);
        request.setAttribute("hasRememberPass", (Object)hasRememberPass);
        request.setAttribute("hasVerificationSms", (Object)hasVerificationSms);
        request.setSessionAttribute("hasVerificationSms", (Object)hasVerificationSms);
        request.setAttribute("hasVerificationCode", (Object)hasVerificationCode);
        if (hasRememberCode) {
            String operatorPass;
            String operatorCode = request.getCookie("operatorCode");
            request.setAttribute("operatorCode", (Object)operatorCode);
            if (hasRememberPass && !Validates.isEmptyBlank((String)(operatorPass = request.getCookie("operatorPass")))) {
                ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
                int len = passworder.secretLen(operatorPass);
                request.setAttribute("operatorPass", (Object)Strings.prefixLen((String)"", (int)len, (char)'\u25cf'));
            }
        }
    }
}

