/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.extend.SwitchAction;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dbo.ZmrAvatar;
import org.zhiqim.orm.dbo.Selector;

public class AvatarAction
extends SwitchAction
implements ZmrConstants {
    public void list(HttpRequest request) throws Exception {
        int page = request.getParameterInt("page", 1);
        int pageSize = request.getContextAttributeInt("zmr_page_size", 20);
        PageResult result = ZmrBootstrap.table(request).page(ZmrAvatar.class, page, pageSize, new Selector("avatarType", (Object)0));
        request.setAttribute("result", (Object)result);
    }

    public void modify(HttpRequest request) throws Exception {
        long avatarId = request.getParameterLong("avatarId");
        ZmrAvatar avatar = (ZmrAvatar)ZmrBootstrap.table(request).item(ZmrAvatar.class, new Object[]{avatarId});
        if (avatar == null) {
            request.returnHistory("\u5934\u50cf\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            return;
        }
        request.setAttribute("avatar", (Object)avatar);
    }

    public void access(HttpRequest request) throws Exception {
        HttpResponse response = request.getResponse();
        List paramList = request.getParameterMatch();
        if (paramList == null || paramList.size() != 2 || !Validates.isIntegerNonnegative((String)((String)paramList.get(0))) || !Validates.isIntegerPositive((String)((String)paramList.get(1)))) {
            response.sendError(400);
            return;
        }
        int avatarSize = Ints.toInt((String)((String)paramList.get(1)));
        if (avatarSize != 50 && avatarSize != 100 && avatarSize != 150) {
            response.sendError(400);
            return;
        }
        long avatarId = Longs.toLong((String)((String)paramList.get(0)));
        if (avatarId == 0L) {
            response.sendRedirect(request.getRootPath("/service/res/image/pic_avatar.jpg"));
            return;
        }
        Selector selector = new Selector();
        selector.addFields("avatarTime, avatar" + avatarSize);
        selector.addMust("avatarId", (Object)avatarId);
        ZmrAvatar avatar = (ZmrAvatar)ZmrBootstrap.table(request).item(ZmrAvatar.class, selector);
        if (avatar == null) {
            response.sendError(404);
            return;
        }
        response.removeHeader("Pragma");
        response.removeHeader("P3P");
        response.removeHeader("Cache-Control");
        long lastModified = avatar.getAvatarTime();
        String lastModifiedTime = DateTimes.getDateTimeHttp((long)lastModified);
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && ifModifiedSince.indexOf(lastModifiedTime) != -1) {
            response.setHeader("Expires", (Object)DateTimes.getDateTimeHttpNextHour());
            response.sendError(304);
            return;
        }
        response.setContentType("image/png");
        response.setHeader("Accept-Ranges", (Object)"bytes");
        response.setHeader("Last-Modified", (Object)lastModifiedTime);
        response.setHeader("Expires", (Object)DateTimes.getDateTimeHttpNextHour());
        byte[] data = null;
        switch (avatarSize) {
            case 50: {
                data = avatar.getAvatar50();
                break;
            }
            case 100: {
                data = avatar.getAvatar100();
                break;
            }
            case 150: {
                data = avatar.getAvatar150();
            }
        }
        response.write(data);
        response.commit();
    }
}

