/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOperatorLog;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class ZmrTask
implements Task {
    private static final Log log = LogFactory.getLog(ZmrTask.class);
    private ZmrBootstrap bootstrap;

    public ZmrTask(ZmrBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void execute() {
        this.chkCloseSuperAdmin();
        this.delExpireOperateLog();
    }

    private void chkCloseSuperAdmin() {
        try {
            if (this.bootstrap.tableOpr().count(ZmrOperator.class, (Selector)new Selector("operatorType", (Object)0).addMust("operatorStatus", (Object)0)) == 0) {
                return;
            }
            if (this.bootstrap.tableOpr().count(ZmrOperator.class, (Selector)new Selector("operatorType", (Object)1).addMust("operatorStatus", (Object)0)) == 0) {
                return;
            }
            this.bootstrap.tableOpr().update(ZmrOperator.class, (Updater)new Updater().addField("operatorStatus", (Object)1).addMust("operatorType", (Object)0));
            log.info((Object)"\u505c\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u6210\u529f...");
        }
        catch (Exception e) {
            log.error((Object)"\u505c\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u65f6\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }

    private void delExpireOperateLog() {
        try {
            int remainDay = ZmrParamDao.getRemainLogDay((HttpContext)this.bootstrap.getContext());
            String datetime = String.valueOf(DateTimes.getDateString()) + " 00:00:00";
            String operateTime = DateTimes.getPreviousDateTimeString((String)datetime, (int)remainDay);
            Selector selector = (Selector)new Selector().addMustThenL("operateTime", (Object)Sqls.toTimestamp((String)operateTime));
            this.bootstrap.table().delete(ZmrOperatorLog.class, selector);
            log.info((Object)"\u5220\u9664[%s]\u4e4b\u524d\u7684\u64cd\u4f5c\u65e5\u5fd7\u6210\u529f...", new Object[]{operateTime});
        }
        catch (Exception e) {
            log.error((Object)"\u5220\u9664\u4e4b\u524d\u7684\u64cd\u4f5c\u65e5\u5fd7\u65f6\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }
}

