/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager;

import java.sql.SQLException;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.orm.ORMException;
import org.zhiqim.zml.ZmlVarRuntime;

@AnAlias(value={"ZmrCdnRuntime"})
public class ZmrCdnRuntime
implements ZmlVarRuntime,
ZmrConstants {
    private HttpContext context;
    private String pathInContext;

    public ZmrCdnRuntime(HttpContext context, String pathInContext) {
        this.context = context;
        this.pathInContext = pathInContext;
    }

    public Object build() {
        try {
            String cdnPath = ZmrParamDao.getString(this.context, "zhiqim.manager", "cdnPath");
            if (Validates.isEmptyBlank((String)cdnPath)) {
                return this.context.getRootPath(this.pathInContext);
            }
            return String.valueOf(Strings.trimRight((String)cdnPath, (String)"/")) + this.pathInContext;
        }
        catch (SQLException | ORMException throwable) {
            return this.context.getRootPath(this.pathInContext);
        }
    }
}

